package rearth.oritech.client.ui;

import io.wispforest.owo.ui.container.FlowLayout;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.util.ScreenProvider;

public class CentrifugeScreen extends UpgradableMachineScreen<CentrifugeScreenHandler> {
    private final FluidDisplay inFluidDisplay;
    
    private static final ScreenProvider.BarConfiguration inputConfig = new ScreenProvider.BarConfiguration(28, 6, 21, 74);
    
    public CentrifugeScreen(CentrifugeScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        
        if (((CentrifugeBlockEntity) handler.blockEntity).hasFluidAddon) {
            inFluidDisplay = initFluidDisplay(handler.inputTank, inputConfig);
            
        } else {
            inFluidDisplay = null;
        }
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        if (inFluidDisplay != null) {
            addFluidDisplay(overlay, inFluidDisplay);
            updateFluidDisplay(inFluidDisplay);
        }
        
    }
    
    @Override
    protected void method_37432() {
        
        if (inFluidDisplay != null)
            updateFluidDisplay(inFluidDisplay);
        
        super.method_37432();
    }
}
