package rearth.oritech.client.renderers;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.blocks.processing.RefineryModuleBlock;
import rearth.oritech.block.blocks.storage.LargeStorageBlock;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;

public class BlockOutlineRenderer {
    public static void render(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer) {
        if (world == null) return;
        
        var client = class_310.method_1551();
        var player = client.field_1724;
        if (player == null || player.method_5715()) return;
        if (client.field_1765 == null || client.field_1765.method_17783() != class_239.class_240.field_1332) return;
        
        var itemStack = player.method_6047();
        var blockPos = ((class_3965) client.field_1765).method_17777();
        
        if (Oritech.CONFIG.showMachinePreview()) {
            renderBlockPlacementPreviewOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
            renderParticlePlacementHelper(world, camera, matrixStack, consumer, itemStack, player, blockPos);
        }
        
        renderPromethiumPickaxeOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
    }
    
    private static void renderBlockPlacementPreviewOutline(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        
        var hasBlockItem = itemStack.method_7909() instanceof class_1747 || itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER);
        
        if (!hasBlockItem) return;
        
        var block = itemStack.method_7909() instanceof class_1747 ? ((class_1747) itemStack.method_7909()).method_7711() : BlockContent.UNSTABLE_CONTAINER;
        
        if (!(block instanceof class_2343 entityProvider) || !block.method_9564().method_28498(MultiblockMachine.ASSEMBLED))
            return;
        
        var machinePos = blockPos.method_10081(((class_3965) player.field_3937.field_1765).method_17780().method_10163());
        if (itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER))
            machinePos = blockPos;
        var placementState = block.method_9605(new class_1750(player, player.field_6266, itemStack, (class_3965) player.field_3937.field_1765));
        var entity = entityProvider.method_10123(machinePos, placementState);
        if (!(entity instanceof MultiblockMachineController multiblockController)) return;
        
        if (itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER)) {
            var blockState = world.method_8320(machinePos);
            var isValid = blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW) || blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM) || blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH);
            if (!isValid) return;
        }
        
        var coreOffsets = multiblockController.getCorePositions();
        var machineFacing = getFacingFromState(placementState);
        
        if (block instanceof LargeStorageBlock) {    // the large block is weird
            machineFacing = player.method_5735().method_10153();
        } else if (block instanceof AugmentResearchStationBlock) {
            machineFacing = player.method_58149();
        } else if (!(block instanceof MultiblockMachine || block instanceof RefineryModuleBlock)) {
            machineFacing = machineFacing.method_10153();
        }
        
        var fullList = new ArrayList<>(coreOffsets);
        fullList.add(class_2382.field_11176);
        
        matrixStack.method_22903();
        var cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        matrixStack.method_46416(0.005f, 0.005f, 0.005f); // slight offset to avoid z fighting
        
        var shape = class_259.method_1077();
        for (var coreOffset : fullList) {
            var fixedOffset = new class_2382(coreOffset.method_10263(), coreOffset.method_10264(), coreOffset.method_10260());
            var worldOffset = Geometry.offsetToWorldPosition(machineFacing, fixedOffset, machinePos);
            shape = class_259.method_1084(shape, class_259.method_1081(worldOffset.method_10263(), worldOffset.method_10264(), worldOffset.method_10260(), worldOffset.method_10263() + 1, worldOffset.method_10264() + 1, worldOffset.method_10260() + 1));
        }
        
        class_761.method_3291(matrixStack, consumer.getBuffer(class_1921.method_23594()), shape, 0, 0, 0, 1f, 1f, 1f, 0.7F);
        matrixStack.method_22909();
        
    }
    
    private static class_2350 getFacingFromState(class_2680 state) {
        if (state.method_28498(class_2741.field_12481)) {
            return state.method_11654(class_2741.field_12481);
        } else if (state.method_28498(class_2741.field_12525)) {
            return state.method_11654(class_2741.field_12525);
        } else if (state.method_28498(SmallStorageBlock.TARGET_DIR)) {
            return state.method_11654(SmallStorageBlock.TARGET_DIR);
        }
        
        return class_2350.field_11043;
    }
    
    private static void renderPromethiumPickaxeOutline(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        if (!itemStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) return;
        
        var offsetBlocks = PromethiumPickaxeItem.getOffsetBlocks(world, player, blockPos);
        
        matrixStack.method_22903();
        var cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        
        for (var offsetPos : offsetBlocks) {
            var offsetState = world.method_8320(offsetPos);
            var renderShape = offsetState.method_26218(world, offsetPos);
            
            matrixStack.method_22903();
            matrixStack.method_46416(offsetPos.method_10263(), offsetPos.method_10264(), offsetPos.method_10260());
            class_761.method_3291(matrixStack, consumer.getBuffer(class_1921.method_23594()), renderShape, 0, 0, 0, 0.0F, 0.0F, 0.0F, 0.35F);
            matrixStack.method_22909();
        }
        
        matrixStack.method_22909();
    }
    
    private static void renderParticlePlacementHelper(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        
        var isRing = itemStack.method_31574(BlockContent.ACCELERATOR_RING.method_8389());
        var isMotor = itemStack.method_31574(BlockContent.ACCELERATOR_MOTOR.method_8389());
        
        if (!isRing && !isMotor) return;
        
        assert player.field_3937.field_1765 != null;
        
        var facing = player.method_5735();
        var cameraPos = camera.method_19326();
        var blockHit = (class_3965) player.field_3937.field_1765;
        var targetPos = class_243.method_24954(blockHit.method_17777().method_10081(blockHit.method_17780().method_10163()));
        
        if (isMotor)
            facing = facing.method_10170();
        
        var shape = class_259.method_1081(7/16f, 7/16f, 0, 9/16f, 9/16f, 1f);
        var halfShape = class_259.method_1081(4/16f, 7/16f, 0.8, 6/16f, 9/16f, 1.3f);
        var halfShapeLeft = class_259.method_1081(8/16f, 7/16f, 0.3, 10/16f, 9/16f, 0.8f);
        
        matrixStack.method_22903();
        
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        matrixStack.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        matrixStack.method_46416(0.005f, 0.005f, 0.005f); // slight offset to avoid z fighting
        
        var rotationY = 0;
        var extraOffset = class_243.field_1353;
        if (facing.equals(class_2350.field_11039)) {
            rotationY = 90;
            extraOffset = new class_243(0, 0, 1);
        }
        if (facing.equals(class_2350.field_11035)) {
            rotationY = 180;
            extraOffset = new class_243(1, 0, 1);
        }
        if (facing.equals(class_2350.field_11034)) {
            rotationY = 270;
            extraOffset = new class_243(1, 0, 0);
        }
        
        
        matrixStack.method_22904(extraOffset.field_1352, extraOffset.field_1351, extraOffset.field_1350);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
        
        class_761.method_3291(matrixStack, consumer.getBuffer(class_1921.method_23594()), shape, 0, 0, 0, 1F, 1.0F, 1.0F, 1F);
        
        if (isRing) {
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(30));
            class_761.method_3291(matrixStack, consumer.getBuffer(class_1921.method_23594()), halfShape, 0, 0, 0, 1F, 1.0F, 1.0F, 1F);
            matrixStack.method_22909();
            
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-30));
            class_761.method_3291(matrixStack, consumer.getBuffer(class_1921.method_23594()), halfShapeLeft, 0, 0, 0, 1F, 1.0F, 1.0F, 1F);
            matrixStack.method_22909();
        }
        
        matrixStack.method_22909();
    }
}
