package rearth.oritech.block.blocks.interaction;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.PumpBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5558;

import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class PumpBlock extends class_2248 implements class_2343 {
    
    public PumpBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481);
    }
    
    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PumpBlockEntity(pos, state);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            var pumpEntity = world.method_35230(pos, BlockEntitiesContent.PUMP_BLOCK);
            pumpEntity.ifPresent(pumpBlockEntity -> pumpBlockEntity.onUsed(player));
        }
        return class_1269.field_5812;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.field_9236) {
            // break all trunk blocks below
            var checkPos = pos.method_10074();
            while (world.method_8320(checkPos).method_26204().equals(BlockContent.PUMP_TRUNK_BLOCK)) {
                world.method_22352(checkPos, false);
                checkPos = checkPos.method_10074();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.pump_redstone"));
        }
        addMachineTooltip(tooltip, this, this);
    }
}
