package rearth.oritech;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.*;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.init.world.FeatureContent;
import rearth.oritech.item.tools.ElectricMaceItem;

import rearth.oritech.util.registry.ArchitecturyBlockRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRecipeRegistryContainer;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

public final class Oritech {
    
    public static final String MOD_ID = "oritech";
    public static final Logger LOGGER = LoggerFactory.getLogger("oritech");
    public static final OritechConfig CONFIG = OritechConfig.createAndLoad();
    
    public static final Multimap<class_2960, Runnable> EVENT_MAP = initEventMap();
    
    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }
    
    static {
        ReflectiveEndecBuilder.SHARED_INSTANCE.register(MinecraftEndecs.IDENTIFIER, class_2960.class);
    }
    
    public static void initialize() {
        
        LOGGER.info("Begin Oritech initialization");
        NetworkManager.init();
        NetworkManager.registerDefaultCodecs();
        ParticleContent.registerParticles();
        FeatureContent.initialize();
        
        // for pipe data
        LifecycleEvent.SERVER_STARTED.register(Oritech::onServerStarted);
        
        // for augment data
        LifecycleEvent.SERVER_STARTED.register(server -> PlayerAugments.loadAllAugments(server.method_3772()));
        
        // for particle collisions
        TickEvent.SERVER_POST.register(elem -> AcceleratorParticleLogic.onTickEnd());
        TickEvent.SERVER_POST.register(elem -> AddonBlockEntity.completeInits());
        TickEvent.SERVER_POST.register(elem -> ElectricMaceItem.processLightningEvents(elem.method_30002()));
        
        ComponentContent.COMPONENTS.register();
        
        // for player augment ticks
        TickEvent.SERVER_PRE.register(event -> event.method_3738().forEach(world -> world.method_18456().forEach(PlayerAugments::serverTickAugments)));
        LOGGER.info("Oritech initialization complete");
    }
    
    // fabric only
    public static void runAllRegistries() {
        
        LOGGER.info("Running Oritech registrations...");
        
        // fluids need to be first
        LOGGER.debug("Registering fluids");
        EVENT_MAP.get(class_7924.field_41270.method_29177()).forEach(Runnable::run);
        
        for (var type : EVENT_MAP.keySet()) {
            if (type.equals(class_7924.field_41270.method_29177()) || type.equals(class_7924.field_44688.method_29177())) continue;
            EVENT_MAP.get(type).forEach(Runnable::run);
        }
        
        LOGGER.debug("Registering item groups");
        EVENT_MAP.get(class_7924.field_44688.method_29177()).forEach(Runnable::run);
        LOGGER.info("Oritech registrations complete");
    }
    
    public static Multimap<class_2960, Runnable> initEventMap() {
        
        Multimap<class_2960, Runnable> res = ArrayListMultimap.create();
        res.put(class_7924.field_41270.method_29177(), FluidContent::registerFluids);
        res.put(class_7924.field_41254.method_29177(), FluidContent::registerBlocks);
        res.put(class_7924.field_41197.method_29177(), FluidContent::registerItems);
        res.put(class_7924.field_41197.method_29177(), () -> ArchitecturyRegistryContainer.register(ItemContent.class, MOD_ID, false));
        res.put(class_7924.field_41254.method_29177(), () -> ArchitecturyRegistryContainer.register(BlockContent.class, MOD_ID, false));
        res.put(class_7924.field_41197.method_29177(), ArchitecturyBlockRegistryContainer::finishItemRegister);
        res.put(class_7924.field_41255.method_29177(), () -> ArchitecturyRegistryContainer.register(BlockEntitiesContent.class, MOD_ID, false));
        res.put(class_7924.field_41225.method_29177(), () -> ArchitecturyRegistryContainer.register(SoundContent.class, MOD_ID, false));
        res.put(class_7924.field_41197.method_29177(), () -> ArchitecturyRegistryContainer.register(ToolsContent.class, MOD_ID, false));
        res.put(class_7924.field_41267.method_29177(), () -> ArchitecturyRegistryContainer.register(FeatureContent.class, MOD_ID, false));
        res.put(class_7924.field_41199.method_29177(), () -> ArchitecturyRegistryContainer.register(LootContent.class, MOD_ID, false));
        res.put(class_7924.field_41266.method_29177(), () -> ArchitecturyRegistryContainer.register(EntitiesContent.class, MOD_ID, false));
        res.put(class_7924.field_41197.method_29177(), ToolsContent::registerEventHandlers);
        res.put(class_7924.field_41207.method_29177(), () -> ArchitecturyRegistryContainer.register(ModScreens.class, MOD_ID, false));
        res.put(class_7924.field_41217.method_29177(), () -> ArchitecturyRegistryContainer.register(RecipeContent.class, MOD_ID, false));
        res.put(class_7924.field_44688.method_29177(), () -> ArchitecturyRegistryContainer.register(ItemGroups.class, MOD_ID, false));
        res.put(class_7924.field_41216.method_29177(), ArchitecturyRecipeRegistryContainer::finishSerializerRegister);
        res.put(class_7924.field_41199.method_29177(), FluidContent::registerItemsToGroups);
        res.put(class_2960.method_60655("neoforge", "attachment_types"), Augment::registerAttachmentTypes);   // this works just fine on fabric aswell, as they key is not really relevant there.
        
        return res;
    }
    
    private static void onServerStarted(MinecraftServer minecraftServer) {
        minecraftServer.method_3738().forEach(world -> {
            if (world.field_9236) return;
            
            var regKey = world.method_27983().method_29177();
            
            var dataId = "energy_" + regKey.method_12836() + "_" + regKey.method_12832();
            var result = world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, dataId);
            EnergyPipeBlock.ENERGY_PIPE_DATA.put(regKey, result);
            
            var fluidDataId = "fluid_" + regKey.method_12836() + "_" + regKey.method_12832();
            var fluidResult = world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, fluidDataId);
            FluidPipeBlock.FLUID_PIPE_DATA.put(regKey, fluidResult);
            
            var itemDataId = "item_" + regKey.method_12836() + "_" + regKey.method_12832();
            var itemResult = world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, itemDataId);
            ItemPipeBlock.ITEM_PIPE_DATA.put(regKey, itemResult);
            
            var superConductorDataId = "superconductor_" + regKey.method_12836() + "_" + regKey.method_12832();
            var superConductorResult = world.method_17983().method_17924(GenericPipeInterfaceEntity.PipeNetworkData.TYPE, superConductorDataId);
            SuperConductorBlock.SUPERCONDUCTOR_DATA.put(regKey, superConductorResult);
        });
    }
}