/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.pipes.item.ItemFilterBlock;
import rearth.oritech.client.ui.ItemFilterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;

public class ItemFilterBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
ExtendedMenuProvider {
    public final FilterBlockInventory inventory = new FilterBlockInventory(1, this::method_5431);
    @SyncField(value={SyncType.GUI_OPEN})
    protected FilterData filterSettings = new FilterData(false, true, false, new HashMap<Integer, class_1799>());

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10556("whitelist", this.filterSettings.useWhitelist);
        nbt.method_10556("useNbt", this.filterSettings.useNbt);
        nbt.method_10556("useComponents", this.filterSettings.useComponents);
        Collection<class_1799> filterItems = this.filterSettings.items.values();
        class_2499 itemsNbtList = new class_2499();
        for (class_1799 item : filterItems) {
            class_2520 data = item.method_57358(registryLookup);
            itemsNbtList.add((Object)data);
        }
        nbt.method_10566("filterItems", (class_2520)itemsNbtList);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        boolean whiteList = nbt.method_10577("whitelist");
        boolean useNbt = nbt.method_10577("useNbt");
        boolean useComponents = nbt.method_10577("useComponents");
        class_2499 list = nbt.method_10554("filterItems", 10);
        HashMap<Integer, class_1799> itemsList = new HashMap<Integer, class_1799>();
        for (int i = 0; i < list.size(); ++i) {
            class_2520 data = list.method_10534(i);
            class_1799 stack = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)data).orElse(class_1799.field_8037);
            itemsList.put(i, stack);
        }
        FilterData data = new FilterData(useNbt, whiteList, useComponents, itemsList);
        this.setFilterSettings(data);
    }

    public ItemFilterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ITEM_FILTER_ENTITY, pos, state);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ItemFilterScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.inventory.method_5442()) {
            return;
        }
        class_2350 targetDirection = (class_2350)this.method_11010().method_11654((class_2769)ItemFilterBlock.TARGET_DIR);
        class_2338 targetPos = pos.method_10081(targetDirection.method_10163());
        ItemApi.InventoryStorage targetInv = ItemApi.BLOCK.find(world, targetPos, targetDirection);
        if (targetInv == null) {
            return;
        }
        class_1799 firstItem = (class_1799)this.inventory.heldStacks.getFirst();
        int inserted = targetInv.insert(firstItem.method_7972(), false);
        firstItem.method_7934(inserted);
    }

    public FilterData getFilterSettings() {
        return this.filterSettings;
    }

    public void setFilterSettings(FilterData filterSettings) {
        this.filterSettings = filterSettings;
        this.method_5431();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.field_11867);
        }
    }

    public static void handleClientUpdate(ItemFilterPayload message, class_1657 player, class_5455 registryAccess) {
        Optional blockEntity = player.method_37908().method_35230(message.pos(), BlockEntitiesContent.ITEM_FILTER_ENTITY);
        if (blockEntity.isPresent()) {
            ((ItemFilterBlockEntity)blockEntity.get()).setFilterSettings(message.data);
        }
    }

    public class FilterBlockInventory
    extends SimpleInventoryStorage {
        public FilterBlockInventory(int size, Runnable onUpdate) {
            super(size, onUpdate);
        }

        public boolean canInsert(class_1799 stack) {
            boolean checkNbt = ItemFilterBlockEntity.this.filterSettings.useNbt;
            boolean checkComponents = ItemFilterBlockEntity.this.filterSettings.useComponents;
            boolean matchesFilterItems = false;
            for (class_1799 filterItem : ItemFilterBlockEntity.this.filterSettings.items.values()) {
                boolean componentsMatch;
                boolean matchesType = stack.method_7909().equals(filterItem.method_7909());
                if (!matchesType) continue;
                if (checkComponents && !(componentsMatch = stack.method_57380().equals((Object)filterItem.method_57380()))) break;
                if (checkNbt) {
                    if (stack.method_57826(class_9334.field_49628) && filterItem.method_57826(class_9334.field_49628)) {
                        boolean match = ((class_9279)stack.method_57824(class_9334.field_49628)).equals(filterItem.method_57824(class_9334.field_49628));
                        if (!match) continue;
                        matchesFilterItems = true;
                        break;
                    }
                    if (stack.method_57826(class_9334.field_49628) || filterItem.method_57826(class_9334.field_49628)) continue;
                    matchesFilterItems = true;
                    break;
                }
                matchesFilterItems = true;
                break;
            }
            if (ItemFilterBlockEntity.this.filterSettings.useWhitelist) {
                return matchesFilterItems;
            }
            return !matchesFilterItems;
        }

        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            if (!this.canInsert(addedStack)) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    }

    public record FilterData(boolean useNbt, boolean useWhitelist, boolean useComponents, Map<Integer, class_1799> items) {
        public static class_9139<class_9129, FilterData> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, FilterData::useNbt, (class_9139)class_9135.field_48547, FilterData::useWhitelist, (class_9139)class_9135.field_48547, FilterData::useComponents, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_49675, (class_9139)class_1799.field_48349), FilterData::items, FilterData::new);
    }

    public record ItemFilterPayload(class_2338 pos, FilterData data) implements class_8710
    {
        public static final class_8710.class_9154<ItemFilterPayload> FILTER_PACKET_ID = new class_8710.class_9154(Oritech.id("filter"));
        public static final class_9139<class_9129, ItemFilterPayload> PACKET_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, ItemFilterPayload::pos, FilterData.PACKET_CODEC, ItemFilterPayload::data, ItemFilterPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return FILTER_PACKET_ID;
        }
    }
}

