/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Insets;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.client.ui.UpgradableMachineScreen;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.ScreenProvider;

public class SteamEngineScreen
extends UpgradableMachineScreen<UpgradableMachineScreenHandler> {
    protected LabelComponent productionLabel;

    public SteamEngineScreen(UpgradableMachineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    public void addExtensionComponents(FlowLayout container) {
        super.addExtensionComponents(container);
        SteamEngineEntity steamEntity = (SteamEngineEntity)((UpgradableMachineScreenHandler)this.field_2797).blockEntity;
        SteamEngineEntity.SteamEngineSyncPacket data = steamEntity.clientStats;
        if (data == null) {
            return;
        }
        int workerCount = data.slaves();
        this.productionLabel = Components.label((class_2561)class_2561.method_43469((String)"title.oritech.steam_energy_production", (Object[])new Object[]{0}));
        container.child(this.productionLabel.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.steam_energy_production")).margins(Insets.of((int)3)));
        this.steamProductionLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.steam_consumption", (Object[])new Object[]{0}));
        this.steamProductionLabel.tooltip((class_2561)class_2561.method_43469((String)"tooltip.oritech.steam_consumption", (Object[])new Object[]{0}));
        if (workerCount > 0) {
            container.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.chambers", (Object[])new Object[]{workerCount})).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.steam_workers")).margins(Insets.of((int)3)));
        }
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.updateEnergyBar();
        SteamEngineEntity steamEntity = (SteamEngineEntity)((UpgradableMachineScreenHandler)this.field_2797).blockEntity;
        SteamEngineEntity.SteamEngineSyncPacket data = steamEntity.clientStats;
        if (data == null || this.productionLabel == null) {
            return;
        }
        long rfProduced = data.energyProduced();
        long steamUsed = data.steamConsumed();
        String speed = String.format("%.0f", Float.valueOf(data.speed() * 100.0f));
        String efficiency = String.format("%.0f", Float.valueOf(data.efficiency() * 100.0f));
        String totalSteamUsage = String.format("%.0f", Float.valueOf(steamUsed));
        this.speedLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.machine_speed", (Object[])new Object[]{speed}));
        this.efficiencyLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.machine_efficiency", (Object[])new Object[]{efficiency}));
        this.productionLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.machine_energy_production", (Object[])new Object[]{rfProduced}));
        this.steamProductionLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.steam_consumption", (Object[])new Object[]{totalSteamUsage}));
    }

    @Override
    public ScreenProvider.BarConfiguration getBoilerInConfig() {
        return ((UpgradableMachineScreenHandler)this.field_2797).screenData.getFluidConfiguration();
    }

    @Override
    public ScreenProvider.BarConfiguration getBoilerOutConfig() {
        ScreenProvider.BarConfiguration config = this.getBoilerInConfig();
        return new ScreenProvider.BarConfiguration(config.x() - config.width() - 8, config.y(), config.width(), config.height());
    }
}

