/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class FragmentForgeBlockEntity
extends MultiblockMachineEntity {
    @SyncField(value={SyncType.GUI_OPEN})
    private boolean hasByproductAddon;

    public FragmentForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FRAGMENT_FORGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.fragmentForgeData.energyPerTick());
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.fragmentForgeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.fragmentForgeData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.GRINDER;
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            this.hasByproductAddon = true;
        }
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        if ((double)this.field_11863.field_9229.method_43057() > 0.8) {
            return;
        }
        class_2350 facing = this.getFacing();
        class_243 offsetLocal = Geometry.rotatePosition(new class_243(0.4, 0.6, 0.5), facing);
        class_243 emitPosition = class_243.method_24953((class_2382)this.field_11867).method_1019(offsetLocal);
        ParticleContent.GRINDER_WORKING.spawn(this.field_11863, emitPosition, (Object)1);
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasByproductAddon = false;
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.hasByproductAddon = false;
        super.gatherAddonStats(addons);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("byproductAddon", this.hasByproductAddon);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.hasByproductAddon = nbt.method_10577("byproductAddon");
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        PulverizerBlockEntity.combineSmallDusts(outputInventory, this.field_11863);
    }

    @Override
    public List<class_1799> getCraftingResults(OritechRecipe activeRecipe) {
        if (this.hasByproductAddon) {
            ArrayList<class_1799> result = new ArrayList<class_1799>(activeRecipe.getResults().size());
            List<class_1799> source = activeRecipe.getResults();
            for (int i = 0; i < source.size(); ++i) {
                class_1799 item = source.get(i);
                if (i == 0) {
                    result.add(item);
                    continue;
                }
                int newCount = item.method_7947() * 2;
                class_1799 newItem = new class_1799((class_1935)item.method_7909(), newCount);
                result.add(newItem);
            }
            return result;
        }
        return super.getCraftingResults(activeRecipe);
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 3);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 20, true), new ScreenProvider.GuiSlot(2, 117, 38, true), new ScreenProvider.GuiSlot(3, 117, 56, true));
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.GRINDER_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {
        if (!this.hasByproductAddon) {
            return super.getExtraExtensionLabels();
        }
        return List.of(new class_3545((Object)class_2561.method_43470((String)"\ud83c\udf40: Enabled"), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.byproduct_bonus.tooltip")));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 1, 0), new class_2382(0, 0, 1), new class_2382(0, 1, 1), new class_2382(1, 0, 1), new class_2382(1, 1, 1), new class_2382(1, 0, 0), new class_2382(1, 1, 0));
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, 0, 2), new class_2382(1, 0, 2), new class_2382(2, 0, 0), new class_2382(1, 0, -1), new class_2382(-1, 0, 1));
    }
}

