/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DeepDrillEntity
extends NetworkedBlockEntity
implements EnergyApi.BlockProvider,
GeoBlockEntity,
ItemApi.BlockProvider,
MultiblockMachineController {
    private boolean initialized;
    private final List<class_2248> targetedOre = new ArrayList<class_2248>();
    private int progress;
    @SyncField
    private long lastWorkTime;
    private final int worktime;
    private final int energyPerStep;
    protected final DynamicEnergyStorage energyStorage;
    public final SimpleInventoryStorage inventory;
    private final ArrayList<class_2338> coreBlocksConnected;
    private float coreQuality;
    protected final AnimatableInstanceCache animatableInstanceCache;
    private final AnimationController<DeepDrillEntity> animationController;

    public DeepDrillEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.DEEP_DRILL_ENTITY, pos, state);
        this.worktime = Oritech.CONFIG.deepDrillConfig.stepsPerOre();
        this.energyPerStep = Oritech.CONFIG.deepDrillConfig.energyPerStep();
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.deepDrillConfig.energyCapacity(), 0L, 0L, this::method_5431);
        this.inventory = new SimpleInventoryStorage(1, this::method_5431);
        this.coreBlocksConnected = new ArrayList();
        this.coreQuality = 1.0f;
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.animationController = this.getAnimationController();
    }

    public boolean init(boolean manual) {
        this.initialized = true;
        this.targetedOre.clear();
        this.loadOreBlocks(manual);
        return !this.targetedOre.isEmpty();
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.isActive(state) && !this.initialized && (world.method_8510() + pos.method_10063()) % 60L == 0L) {
            this.init(false);
        }
        if (world.method_8608() || !this.initialized || this.targetedOre.isEmpty()) {
            return;
        }
        if (!this.inventory.method_5442() && ((class_1799)this.inventory.heldStacks.get(0)).method_7947() >= ((class_1799)this.inventory.heldStacks.get(0)).method_7914()) {
            return;
        }
        if (this.energyStorage.amount >= (long)this.energyPerStep) {
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
            this.lastWorkTime = world.method_8510();
            this.method_5431();
            class_2338 particlePos = this.getCenter(0);
            ParticleContent.FURNACE_BURNING.spawn(world, class_243.method_24954((class_2382)particlePos), (Object)1);
        }
        for (int i = 0; i < 5; ++i) {
            if (this.energyStorage.amount < (long)this.energyPerStep) continue;
            ++this.progress;
            this.energyStorage.amount -= (long)this.energyPerStep;
        }
        if (this.progress >= this.worktime) {
            this.craftResult(world, pos);
            this.progress -= this.worktime;
            this.method_5431();
        }
    }

    private class_2338 getCenter(int y) {
        class_2680 state = this.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return this.field_11867.method_10081(Geometry.rotatePosition(new class_2382(1, y, 0), facing));
    }

    private void loadOreBlocks(boolean manual) {
        class_2338 center = this.getCenter(-1);
        for (int x = -1; x <= 1; ++x) {
            block1: for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y >= -2; --y) {
                    class_2338 target = center.method_10069(x, y, z);
                    class_2680 targetState = this.field_11863.method_8320(target);
                    if (targetState.method_26164(TagContent.RESOURCE_NODES)) {
                        if (manual) {
                            ParticleContent.DEBUG_BLOCK.spawn(this.field_11863, class_243.method_24954((class_2382)target));
                        }
                        this.targetedOre.add(targetState.method_26204());
                        continue block1;
                    }
                    if (!targetState.method_26215()) continue block1;
                }
            }
        }
    }

    private void craftResult(class_1937 world, class_2338 pos) {
        class_2248 usedOre = this.targetedOre.get(world.field_9229.method_43051(0, this.targetedOre.size()));
        class_1792 nodeOreBlockItem = usedOre.method_8389();
        SimpleCraftingInventory sampleInv = new SimpleCraftingInventory(new class_1799((class_1935)nodeOreBlockItem, 1));
        Optional recipeCandidate = world.method_8433().method_8132((class_3956)RecipeContent.DEEP_DRILL, (class_9695)sampleInv, world);
        if (recipeCandidate.isEmpty()) {
            return;
        }
        class_1799 output = ((OritechRecipe)((class_8786)recipeCandidate.get()).comp_1933()).getResults().get(0);
        this.inventory.insert(output, false);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        this.addMultiblockToNbt(nbt);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 0, 1), new class_2382(0, 0, -1), new class_2382(-1, 0, 1), new class_2382(-1, 0, 0), new class_2382(-1, 0, -1), new class_2382(-2, 0, 1), new class_2382(-2, 0, 0), new class_2382(-2, 0, -1), new class_2382(0, 1, 1), new class_2382(0, 1, 0), new class_2382(0, 1, -1), new class_2382(-1, 1, 1), new class_2382(-1, 1, 0), new class_2382(-1, 1, -1), new class_2382(-2, 1, 1), new class_2382(-2, 1, 0), new class_2382(-2, 1, -1), new class_2382(0, 2, 1), new class_2382(0, 2, 0), new class_2382(0, 2, -1), new class_2382(-1, 2, 1), new class_2382(-1, 2, 0), new class_2382(-1, 2, -1), new class_2382(-2, 2, 1), new class_2382(-2, 2, 0), new class_2382(-2, 2, -1));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        class_2680 state = this.method_11010();
        return ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("base_controller", "setup");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<DeepDrillEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.method_11010())) {
                long idleTime = this.field_11863.method_8510() - this.lastWorkTime;
                if (idleTime < 60L) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()).triggerableAnim("setup", MachineBlockEntity.SETUP);
    }

    public void setLastWorkTime(long lastWorkTime) {
        this.lastWorkTime = lastWorkTime;
    }

    private boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
    }
}

