/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;

public abstract class NetworkedBlockEntity
extends class_2586
implements class_5558<NetworkedBlockEntity> {
    private boolean networkDirty = false;
    private boolean needsInitialUpdate = false;

    public NetworkedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (world.field_9236) {
            this.clientTick(world, pos, state, blockEntity);
            return;
        }
        this.serverTick(world, pos, state, blockEntity);
        if ((world.method_8510() + this.field_11867.method_10063()) % (long)this.getSparseUpdateInterval() == 0L) {
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
        if (this.networkDirty) {
            this.networkDirty = false;
            this.sendUpdate(SyncType.TICK);
        }
        if (this.needsInitialUpdate) {
            this.needsInitialUpdate = false;
            this.sendUpdate(SyncType.INITIAL);
        }
    }

    public abstract void serverTick(class_1937 var1, class_2338 var2, class_2680 var3, NetworkedBlockEntity var4);

    public void clientTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
    }

    public int getSparseUpdateInterval() {
        return 100;
    }

    public void method_5431() {
        this.markDirty(false);
    }

    public void markDirty(boolean updateComparator) {
        if (this.field_11863 != null) {
            NetworkedBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.field_11867, (class_2680)this.method_11010());
            if (updateComparator) {
                this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
            }
        }
        this.networkDirty = true;
    }

    public void preNetworkUpdate(SyncType type) {
    }

    public void sendUpdate(SyncType type) {
        if (this.field_11863 == null) {
            Oritech.LOGGER.warn("unable to send update: World is null.");
            return;
        }
        this.preNetworkUpdate(type);
        class_9129 usedBuf = new class_9129(Unpooled.buffer(), this.field_11863.method_30349());
        int fieldCount = NetworkManager.encodeFields((Object)this, type, (ByteBuf)usedBuf, this.field_11863);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(this.field_11867, class_7923.field_41181.method_10221((Object)this.method_11017()), type, usedBuf.array()));
    }

    public void sendUpdate(SyncType type, class_3222 player) {
        if (this.field_11863 == null) {
            Oritech.LOGGER.warn("unable to send player update: World is null.");
            return;
        }
        this.preNetworkUpdate(type);
        class_9129 usedBuf = new class_9129(Unpooled.buffer(), this.field_11863.method_30349());
        int fieldCount = NetworkManager.encodeFields((Object)this, type, (ByteBuf)usedBuf, this.field_11863);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendPlayerHandle(new NetworkManager.MessagePayload(this.field_11867, class_7923.field_41181.method_10221((Object)this.method_11017()), type, usedBuf.array()), player);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        this.needsInitialUpdate = true;
        return super.method_16887(registryLookup);
    }
}

