package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.core.*;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.DronePortEntity;

public class DroneScreen extends UpgradableMachineScreen<DroneScreenHandler> {
    
    public static final class_2960 CARD_SLOT = Oritech.id("textures/gui/modular/designator_arrow.png");
    private final DronePortEntity dronePort;
    
    private String lastMessage = "";

    public DroneScreen(DroneScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        dronePort = (DronePortEntity) handler.blockEntity;
    }
    
    @Override
    protected void build(FlowLayout rootComponent) {
        super.build(rootComponent);
        lastMessage = dronePort.getStatusMessage();
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        if (!dronePort.getStatusMessage().equals(lastMessage)) {
            var message = dronePort.getStatusMessage();
            lastMessage = message;
            
            var label = Components.label(class_2561.method_43471(message).method_27692(class_124.field_1074));
            label.horizontalTextAlignment(HorizontalAlignment.CENTER);
            label.verticalTextAlignment(VerticalAlignment.CENTER);
            label.margins(Insets.of(8));
            
            var container = Containers.verticalFlow(Sizing.content(10), Sizing.content(10));
            container.child(label);
            container.sizing(Sizing.content(10));
            container.surface(ORITECH_PANEL);
            container.positioning(Positioning.relative(50, 30));
            container.zIndex(7000);
            
            var messagePanel = Containers.overlay(container);
            root.child(messagePanel);
            
        }
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        overlay.child(BasicMachineScreen.getItemFrame(129, 26));
        overlay.child(BasicMachineScreen.getItemFrame(129, 62));
        overlay.child(Components.texture(CARD_SLOT, 0, 0, 18, 40, 18, 40).positioning(Positioning.absolute(128, 25)));
    }
}
