package rearth.oritech.block.entity.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.Unpooled;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

public class ReactorAbsorberPortEntity extends class_2586 implements ExtendedMenuProvider, ScreenProvider, ItemApi.BlockProvider {
    
    private final InOutInventoryStorage inventory = new InOutInventoryStorage(1, this::method_5431, new InventorySlotAssignment(0, 1, 1, 0));
    
    @SyncField(SyncType.GUI_TICK)
    public int availableFuel;
    @SyncField(SyncType.GUI_TICK)
    public int currentFuelOriginalCapacity;
    
    public ReactorAbsorberPortEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_ABSORBER_PORT_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        
        nbt.method_10569("available", availableFuel);
        nbt.method_10569("capacity", currentFuelOriginalCapacity);
        
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        
        availableFuel = nbt.method_10550("available");
        currentFuelOriginalCapacity = nbt.method_10550("capacity");
        
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
    }
    
    public int getAvailableFuel() {
        if (availableFuel > 0) {
            return availableFuel;
        }
        
        // try consume item
        var inputStack = inventory.method_5438(0);
        if (inputStack.method_7960()) return 0;
        
        if (inputStack.method_31573(TagContent.REACTOR_COOLANT)) {
            var capacity = 1000;
            currentFuelOriginalCapacity = capacity;
            availableFuel = capacity;
            inputStack.method_7934(1);
            onFuelConsumed();
        }
        
        return availableFuel;
    }
    
    public void consumeFuel(int amount) {
        if (availableFuel >= amount) {
            availableFuel -= amount;
            
            if (field_11863.method_8510() % 5 == 0)
                ParticleContent.COOLER_WORKING.spawn(field_11863, field_11867.method_46558().method_1031(0, 0.5, 0), 1);
        }
        
    }
    
    private void onFuelConsumed() {
        ParticleContent.COOLER_WORKING.spawn(field_11863, field_11867.method_46558().method_1031(0, 0.5, 0), 15);
    }
    
    public void updateNetwork() {
        var usedBuf = new class_9129(Unpooled.buffer(), field_11863.method_30349());
        var fieldCount = NetworkManager.encodeFields(this, SyncType.GUI_TICK, usedBuf, field_11863);
        if (fieldCount == 0) return;
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(field_11867, class_7923.field_41181.method_10221(method_11017()), SyncType.GUI_TICK, usedBuf.array()));
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 80, 35));
    }
    
    @Override
    public boolean showEnergy() {
        return false;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.FUEL_PORT_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public boolean showExpansionPanel() {
        return false;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
}
