package rearth.oritech.block.entity.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.*;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5558;
import net.minecraft.class_7225;

public class TreefellerBlockEntity extends NetworkedBlockEntity implements class_5558<NetworkedBlockEntity>, GeoBlockEntity, EnergyApi.BlockProvider, ItemApi.BlockProvider, ExtendedMenuProvider, ScreenProvider {
    
    private static final int LOG_COST = 100;
    private static final int LEAF_COST = 10;
    
    private final Deque<class_2338> pendingBlocks = new ArrayDeque<>();
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    
    private long lastWorkedAt = 0;
    
    @SyncField({SyncType.GUI_TICK, SyncType.GUI_OPEN})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000, 4000, 0, this::method_5431);
    
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(6, this::method_5431) {
        
        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    
    public TreefellerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.TREEFELLER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (energyStorage.amount >= LOG_COST) {
            if (pendingBlocks.isEmpty() && world.method_8510() % 20 == 0) {
                findTarget();
            }
            
            for (int i = 0; i < 6 && !pendingBlocks.isEmpty(); i++) {
                var candidate = pendingBlocks.peekLast();
                var candidateState = world.method_8320(candidate);
                var isLog = candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE);

                var energyCost = isLog ? LOG_COST : LEAF_COST;
                if (energyCost > energyStorage.amount) break;
                
                var actionResult = breakTreeBlock(candidateState, candidate);
                if (actionResult == class_1269.field_5814) break;
                pendingBlocks.pollLast();
                if (actionResult == class_1269.field_5811) continue;
                lastWorkedAt = world.method_8510();

                energyStorage.amount -= energyCost;
                method_5431();
                
                if (isLog) break; // only harvest 1 log, but multiple leaves
            }
        }
        
        if (world.method_8510() % 10 == 0) {
            var idleTicks = world.method_8510() - lastWorkedAt;
            var isWorking = idleTicks < 20;
            var animName = isWorking ? "work" : "idle";
            playWorkAnimation(animName);
        }
    }
    
    private class_1269 breakTreeBlock(class_2680 candidateState, class_2338 candidate) {
        if (!candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE) && !candidateState.method_26164(TagContent.CUTTER_LEAVES_MINEABLE)) return class_1269.field_5811;
        
        var dropped = net.minecraft.class_2248.method_9562(candidateState, (class_3218) field_11863, candidate, null);
        if (dropped.stream().anyMatch((itemStack) -> !(itemStack.method_7960() || canInsert(itemStack)))) return class_1269.field_5814;

        field_11863.method_31595(candidate, candidateState);
        if (field_11863.method_8510() % 2 == 0)
            field_11863.method_8396(null, candidate, candidateState.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1f);
        field_11863.method_8501(candidate, class_2246.field_10124.method_9564());
        
        dropped.forEach(stack -> inventory.insert(stack, false));
        return class_1269.field_5812;
    }

    private boolean canInsert(class_1799 stack) {
        return inventory.heldStacks.stream().anyMatch((itemStack) -> 
            itemStack.method_7960() || (class_1799.method_31577(itemStack, stack) && itemStack.method_7947() + stack.method_7947() <= itemStack.method_7914())
        );
     }
    
    public void findTarget() {
        
        var state = method_11010();
        var facing = state.method_11654(class_2741.field_12481);
        var offset = Geometry.rotatePosition(new class_2382(1, 0, 0), facing);
        var frontBlock = field_11867.method_10081(offset);
        
        var res = getTreeBlocks(frontBlock, field_11863);
        pendingBlocks.addAll(res);
        
    }
    
    public static Deque<class_2338> getTreeBlocks(class_2338 startPos, class_1937 world) {
        
        var startState = world.method_8320(startPos);
        if (!startState.method_26164(TagContent.CUTTER_LOGS_MINEABLE)) return new ArrayDeque<>();
        
        var checkedPositions = new HashSet<class_2338>();
        var foundPositions = new ArrayDeque<class_2338>();
        var foundLogs = new HashSet<class_2338>();
        var pendingPositions = new ArrayDeque<class_2338>();
        
        checkedPositions.add(startPos);
        foundPositions.add(startPos);
        pendingPositions.addAll(getNeighbors(startPos));
        foundLogs.add(startPos);
        
        while (!pendingPositions.isEmpty() && checkedPositions.size() < 8000) {
            // do logs first, if none available then leaves
            var candidate = pendingPositions.pollFirst();
            if (candidate.method_10264() < startPos.method_10264()) continue;
            
            if (checkedPositions.contains(candidate)) continue;
            
            var candidateState = world.method_8320(candidate);
            checkedPositions.add(candidate);
            
            var isLog = candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE);
            var isValidLeaf = candidateState.method_26164(TagContent.CUTTER_LEAVES_MINEABLE) && !candidateState.method_28500(class_2741.field_12514).orElse(false);
            
            if (!isLog && !isValidLeaf) continue;
            
            var isValid = false;
            if (isLog) {
                isValid = isInLogRange(candidate, foundLogs, 3);
            } else {
                // Give a default of 1 for "leaf" blocks without a DISTANCE_1_7 property (like shroomlights)
                var range = candidateState.method_28500(class_2741.field_12541).orElse(1);
                isValid = isInLogRange(candidate, foundLogs, range + 2);
            }
            
            if (!isValid) continue;
            
            if (isLog) {
                foundLogs.add(candidate);
            }
            
            foundPositions.add(candidate);
            pendingPositions.addAll(getNeighbors(candidate));
            
        }
        
        // when no leaves are found, return nothing to prevent accidentally destroying buildings
        if (foundLogs.size() == foundPositions.size()) return new ArrayDeque<>();
        
        return foundPositions;
    }
    
    private static boolean isInLogRange(class_2338 pos, Set<class_2338> logs, int maxDist) {
        return logs.stream().anyMatch(elem -> elem.method_19455(pos) <= maxDist);
    }
    
    private static List<class_2338> getNeighbors(class_2338 input) {
        List<class_2338> neighbors = new ArrayList<>();
        for (class_2338 pos : class_2338.method_25996(input, 1, 1, 1)) {
            // Without toImmutable, all of the elements in the collected list end up being the same BlockPos
            neighbors.add(pos.method_10062());
        }
        return neighbors;
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10544("energy_stored", energyStorage.amount);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        energyStorage.amount = nbt.method_10537("energy_stored");
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "machine", 5, state -> PlayState.CONTINUE)
                          .triggerableAnim("work", MachineBlockEntity.WORKING)
                          .triggerableAnim("idle", MachineBlockEntity.IDLE)
                          .setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        var list = new ArrayList<GuiSlot>();
        for (int i = 0; i < inventory.method_5439(); i++) {
            list.add(new GuiSlot(i, 40 + i * 19, 25, true));
        }
        return list;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return LOG_COST;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.TREEFELLER_SCREEN;
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }
    
    public void playWorkAnimation(String animName) {
        triggerAnim("machine", animName);
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
}
