package rearth.oritech.block.blocks.decorative;

import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.TagContent;

public class MetalBeamBlock extends class_2248 {
    
    // 0 = foot, 1 = inner, 2 = head
    private static final class_2758 BEAM_STATE = class_2758.method_11867("beam", 0, 2);
    
    private static final class_265 BEAM_SHAPE = class_2248.method_9541(4, 0, 4, 12, 16, 12);
    
    public MetalBeamBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(BEAM_STATE, 0));
    }
    
    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(BEAM_STATE);
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BEAM_SHAPE;
    }
    
    @Override
    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BEAM_SHAPE;
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var world = ctx.method_8045();
        var pos = ctx.method_8037();
        return getTargetState(world, pos);
    }
    
    private class_2680 getTargetState(class_1936 world, class_2338 pos) {
        var isFrameSupport = world.method_8320(pos).method_26164(TagContent.MACHINE_FRAME_SUPPORT);
        var blockBelow = world.method_8320(pos.method_10074()).method_26204();
        var beamBelow = blockBelow.equals(BlockContent.METAL_BEAM_BLOCK) || (isFrameSupport && blockBelow.equals(BlockContent.MACHINE_FRAME_BLOCK));
        var blockAbove = world.method_8320(pos.method_10084()).method_26204();
        var beamAbove = blockAbove.equals(BlockContent.METAL_BEAM_BLOCK) || (isFrameSupport && blockAbove.equals(BlockContent.MACHINE_FRAME_BLOCK));
        
        var state = method_9564();
        
        if (beamBelow && beamAbove)
            return state.method_11657(BEAM_STATE, 1);
        
        if (beamBelow)
            return state.method_11657(BEAM_STATE, 2);
        
        return state.method_11657(BEAM_STATE, 0);
    }
    
    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return getTargetState(world, pos);
    }
}
