package rearth.oritech.util;

import java.util.function.Consumer;
import net.minecraft.class_1799;

public class StackContext {
    
    private class_1799 value;
    private final Consumer<class_1799> updater;
    
    public StackContext(class_1799 value, Consumer<class_1799> updater) {
        this.value = value;
        this.updater = updater;
    }
    
    public class_1799 getValue() {
        return value;
    }
    
    // this is used to apply component changes (e.g. changes inside the itemstack, such as adding or removing components), or to
    // set entirely new itemstacks. New itemstacks need to be synced back to their contains via sync()
    public void setValue(class_1799 value) {
        this.value = value;
    }
    
    // syncs the current itemstack pointer to the context
    public void sync() {
        updater.accept(value);
    }
}
