package rearth.oritech.init.world.features.resourcenode;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3037;

public record ResourceNodeFeatureConfig(int nodeSize, int boulderRadius, List<class_2960> nodeOres, float nodeOreChance, List<class_2960> boulderOres, class_2960 overlayBlock, int overlayHeight) implements class_3037 {
    
    public static final Endec<ResourceNodeFeatureConfig> NODE_FEATURE_ENDEC = StructEndecBuilder.of(
      Endec.INT.fieldOf("nodeSize", ResourceNodeFeatureConfig::nodeSize),
      Endec.INT.fieldOf("boulderRadius", ResourceNodeFeatureConfig::boulderRadius),
      MinecraftEndecs.IDENTIFIER.listOf().fieldOf("nodeOres", ResourceNodeFeatureConfig::nodeOres),
      Endec.FLOAT.fieldOf("nodeOreChance", ResourceNodeFeatureConfig::nodeOreChance),
      MinecraftEndecs.IDENTIFIER.listOf().fieldOf("boulderOres", ResourceNodeFeatureConfig::boulderOres),
      MinecraftEndecs.IDENTIFIER.fieldOf("overlayBlock", ResourceNodeFeatureConfig::overlayBlock),
      Endec.INT.fieldOf("overlayHeight", ResourceNodeFeatureConfig::overlayHeight),
      ResourceNodeFeatureConfig::new
    );
}
