/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.generators.BioGeneratorEntity;
import rearth.oritech.block.entity.generators.FuelGeneratorEntity;
import rearth.oritech.block.entity.generators.LavaGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.AssemblerBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.processing.CoolerBlockEntity;
import rearth.oritech.block.entity.processing.FoundryBlockEntity;
import rearth.oritech.block.entity.processing.FragmentForgeBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.block.entity.processing.RefineryBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.ItemFilterScreen;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.compat.emi.EmiItemFilterDragDropHandler;
import rearth.oritech.init.compat.emi.EmiTransferHandler;
import rearth.oritech.init.compat.emi.OritechEMIParticleCollisionRecipe;
import rearth.oritech.init.compat.emi.OritechEMIRecipe;
import rearth.oritech.init.compat.emi.OritechEmiLaserRecipe;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

@EmiEntrypoint
public class OritechEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        class_1863 manager = registry.getRecipeManager();
        this.registerOritechCategory(registry, manager, RecipeContent.PULVERIZER, (class_1935)BlockContent.PULVERIZER_BLOCK, PulverizerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.GRINDER, (class_1935)BlockContent.FRAGMENT_FORGE_BLOCK, FragmentForgeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.ASSEMBLER, (class_1935)BlockContent.ASSEMBLER_BLOCK, AssemblerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.FOUNDRY, (class_1935)BlockContent.FOUNDRY_BLOCK, FoundryBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.COOLER, (class_1935)BlockContent.COOLER_BLOCK, CoolerBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.CENTRIFUGE, (class_1935)BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.CENTRIFUGE_FLUID, (class_1935)BlockContent.CENTRIFUGE_BLOCK, CentrifugeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.ATOMIC_FORGE, (class_1935)BlockContent.ATOMIC_FORGE_BLOCK, AtomicForgeBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.REFINERY, (class_1935)BlockContent.REFINERY_BLOCK, RefineryBlockEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.BIO_GENERATOR, (class_1935)BlockContent.BIO_GENERATOR_BLOCK, BioGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.FUEL_GENERATOR, (class_1935)BlockContent.FUEL_GENERATOR_BLOCK, FuelGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.LAVA_GENERATOR, (class_1935)BlockContent.LAVA_GENERATOR_BLOCK, LavaGeneratorEntity.class);
        this.registerOritechCategory(registry, manager, RecipeContent.STEAM_ENGINE, (class_1935)BlockContent.STEAM_ENGINE_BLOCK, SteamEngineEntity.class);
        this.registerCustom(registry, manager, RecipeContent.REACTOR, (class_1935)BlockContent.REACTOR_CONTROLLER, List.of(new ScreenProvider.GuiSlot(0, 55, 35)), new InventorySlotAssignment(0, 1, 1, 0));
        this.registerParticleAccelerator(registry, manager, RecipeContent.PARTICLE_COLLISION);
        this.registerLaser(registry, manager, RecipeContent.LASER);
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((class_1935)BlockContent.POWERED_FURNACE_BLOCK));
        registry.addRecipeHandler(ModScreens.ASSEMBLER_SCREEN, new EmiTransferHandler(RecipeContent.ASSEMBLER.getIdentifier()));
        registry.addRecipeHandler(ModScreens.FOUNDRY_SCREEN, new EmiTransferHandler(RecipeContent.FOUNDRY.getIdentifier()));
        registry.addRecipeHandler(ModScreens.ATOMIC_FORGE_SCREEN, new EmiTransferHandler(RecipeContent.ATOMIC_FORGE.getIdentifier()));
        registry.addDragDropHandler(ItemFilterScreen.class, (EmiDragDropHandler)new EmiItemFilterDragDropHandler());
    }

    private void registerOritechCategory(EmiRegistry registry, class_1863 manager, OritechRecipeType recipeType, class_1935 machine, Class<? extends MachineBlockEntity> screenProviderSource) {
        EmiStack icon = EmiStack.of((class_1935)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        class_2680 blockState = class_2246.field_10340.method_9564();
        if (machine instanceof class_2248) {
            class_2248 blockItem = (class_2248)machine;
            blockState = blockItem.method_9564();
        }
        class_2680 finalBlockState = blockState;
        manager.method_30027((class_3956)recipeType).stream().map(entry -> new OritechEMIRecipe((class_8786<OritechRecipe>)entry, category, screenProviderSource, finalBlockState)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerCustom(EmiRegistry registry, class_1863 manager, OritechRecipeType recipeType, class_1935 machine, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        EmiStack icon = EmiStack.of((class_1935)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.method_30027((class_3956)recipeType).stream().map(entry -> new OritechEMIRecipe((class_8786<OritechRecipe>)entry, category, true, slots, assignments)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerParticleAccelerator(EmiRegistry registry, class_1863 manager, OritechRecipeType recipeType) {
        class_2248 machine = BlockContent.ACCELERATOR_CONTROLLER;
        EmiStack icon = EmiStack.of((class_1935)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.method_30027((class_3956)recipeType).stream().map(entry -> new OritechEMIParticleCollisionRecipe((class_8786<OritechRecipe>)entry, category)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerLaser(EmiRegistry registry, class_1863 manager, OritechRecipeType recipeType) {
        class_2248 machine = BlockContent.LASER_ARM_BLOCK;
        EmiStack icon = EmiStack.of((class_1935)machine);
        EmiRecipeCategory category = new EmiRecipeCategory(recipeType.getIdentifier(), (EmiRenderable)icon);
        registry.addCategory(category);
        registry.addWorkstation(category, (EmiIngredient)icon);
        manager.method_30027((class_3956)recipeType).stream().map(entry -> new OritechEmiLaserRecipe((class_8786<OritechRecipe>)entry, category)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }
}

