/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.processing.RefineryBlockEntity;
import rearth.oritech.client.renderers.MachineModel;
import rearth.oritech.client.renderers.SmallTankRenderer;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class RefineryRenderer<T extends RefineryBlockEntity>
extends GeoBlockRenderer<T> {
    private final Map<T, VisualTankHeights> tankHeights = new HashMap<T, VisualTankHeights>();

    public RefineryRenderer(String model) {
        super(new MachineModel(model));
    }

    public class_238 getRenderBoundingBox(T blockEntity) {
        return class_238.method_30048((class_243)blockEntity.method_11016().method_46558(), (double)6.0, (double)6.0, (double)6.0);
    }

    public void postRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23583());
        VisualTankHeights lastHeight = this.tankHeights.computeIfAbsent(animatable, key -> new VisualTankHeights());
        FluidStack inputStack = ((RefineryBlockEntity)animatable).ownStorage.getInStack();
        if (!inputStack.isEmpty()) {
            RefineryRenderer.renderFluidCube(new class_243(-1.5, 0.1875, 0.6875), new Vector3f(0.75f, 1.5625f, 1.75f), inputStack, ((RefineryBlockEntity)animatable).ownStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, -1, lastHeight);
        }
        int moduleCount = ((RefineryBlockEntity)animatable).getModuleCount();
        for (int i = 0; i <= moduleCount; ++i) {
            FluidApi.SingleSlotStorage outputStorage = ((RefineryBlockEntity)animatable).getOutputStorage(i);
            FluidStack renderedStack = outputStorage.getStack();
            if (renderedStack.isEmpty()) continue;
            class_3545<class_243, Vector3f> tankPosition = RefineryRenderer.getTankCoordinates(i);
            RefineryRenderer.renderFluidCube((class_243)tankPosition.method_15442(), (Vector3f)tankPosition.method_15441(), renderedStack, outputStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, i, lastHeight);
        }
    }

    private static class_3545<class_243, Vector3f> getTankCoordinates(int i) {
        return switch (i) {
            case 0 -> new class_3545((Object)new class_243(-1.375, 0.5625, -0.3125), (Object)new Vector3f(0.4375f, 0.9375f, 0.625f));
            case 1 -> new class_3545((Object)new class_243(-1.3125, 2.0, -0.3125), (Object)new Vector3f(1.625f, 0.875f, 1.625f));
            case 2 -> new class_3545((Object)new class_243(-1.3125, 3.0, -0.3125), (Object)new Vector3f(1.625f, 0.875f, 1.625f));
            default -> throw new IllegalStateException("Tried to access invalid tank for renderer: " + i);
        };
    }

    private static void renderFluidCube(class_243 min, Vector3f size, FluidStack drawnStack, Long tankCapacity, class_4588 consumer, class_4587 matrices, int light, int overlay, int index, VisualTankHeights lastHeight) {
        class_3611 fluid = drawnStack.getFluid();
        float fill = (float)drawnStack.getAmount() / (float)tankCapacity.longValue();
        float lastFill = index == -1 ? lastHeight.input : lastHeight.outputs[index];
        float newFill = class_3532.method_16439((float)0.003f, (float)lastFill, (float)fill);
        if (index == -1) {
            lastHeight.input = newFill;
        } else {
            lastHeight.outputs[index] = newFill;
        }
        class_1058 sprite = FluidStackHooks.getStillTexture((class_3611)fluid);
        int spriteColor = FluidStackHooks.getColor((class_3611)fluid);
        Color parsedColor = Color.ofArgb((int)spriteColor);
        Color opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1.0f);
        spriteColor = opaqueColor.argb();
        matrices.method_22903();
        matrices.method_22904(min.field_1352 + (double)0.01f, min.field_1351 + (double)0.01f, min.field_1350 + (double)0.01f);
        matrices.method_22905(size.x - 0.02f, size.y * newFill - 0.03f, size.z - 0.02f);
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f modelMatrix = entry.method_23761();
        for (class_2350 direction : class_2350.values()) {
            if (direction.equals((Object)class_2350.field_11033)) continue;
            SmallTankRenderer.drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        matrices.method_22909();
    }

    private static class VisualTankHeights {
        private float input = 0.0f;
        private final float[] outputs = new float[3];

        private VisualTankHeights() {
        }
    }
}

