package rearth.oritech.util.fabric;

import java.util.Map;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;

import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;

// inspired by Fabric's FakePlayer and Neoforge's FakePlayerFactory

// the only difference between this and the Neoforge Impl is the platform's version of FakePlayer that is being extended.
public class FakeMachinePlayerImpl extends FakePlayer {
    private static final Map<FakeMachinePlayerKey, FakePlayer> FAKE_MACHINE_PLAYERS = new MapMaker().weakValues().makeMap();
    private record FakeMachinePlayerKey (class_3218 world, GameProfile profile) {}
    
    private final SimpleInventoryStorage inventory;

    private FakeMachinePlayerImpl(class_3218 world, GameProfile profile, SimpleInventoryStorage inventory) {
        super(world, profile);
        this.inventory = inventory;
    }

    public static class_3222 create(class_3218 world, GameProfile profile, SimpleInventoryStorage inventory) {
        FakeMachinePlayerKey key = new FakeMachinePlayerKey(world, profile);
        return FAKE_MACHINE_PLAYERS.computeIfAbsent(key, k -> new FakeMachinePlayerImpl(k.world(), k.profile(), inventory));
	}

    @Override
    public boolean method_7270(class_1799 itemStack) {
        this.inventory.insert(itemStack, false);
        return true;
    }
}
