package rearth.oritech.init.recipes;

import dev.architectury.fluid.FluidStack;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.EndecRecipeSerializer;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.util.FluidIngredient;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class OritechRecipeType extends EndecRecipeSerializer<OritechRecipe> implements class_3956<OritechRecipe> {
    
    public static final Endec<FluidStack> FLUID_STACK_ENDEC = StructEndecBuilder.of(
        MinecraftEndecs.ofRegistry(class_7923.field_41173).fieldOf("fluid", FluidStack::getFluid),
        Endec.LONG.optionalFieldOf("amount", FluidStack::getAmount, FluidStack.bucketAmount()),
        FluidStack::create);
    
    public static final Endec<OritechRecipe> ORI_RECIPE_ENDEC = StructEndecBuilder.of(
      Endec.INT.optionalFieldOf("time", OritechRecipe::getTime, 60),
      CodecUtils.toEndec(class_1856.field_46096).listOf().fieldOf("ingredients", OritechRecipe::getInputs),
      MinecraftEndecs.ITEM_STACK.listOf().fieldOf("results", OritechRecipe::getResults),
      MinecraftEndecs.IDENTIFIER.xmap(identifier1 -> (OritechRecipeType) class_7923.field_41188.method_10223(identifier1), OritechRecipeType::getIdentifier).fieldOf("type", OritechRecipe::getOriType),
      FluidIngredient.FLUID_INGREDIENT_ENDEC.optionalFieldOf("fluidInput", OritechRecipe::getFluidInput, FluidIngredient.EMPTY),
      FLUID_STACK_ENDEC.listOf().optionalFieldOf("fluidOutputs", OritechRecipe::getFluidOutputs, List.of()),
      OritechRecipe::new
    );
    
    public static final class_9139<class_9129, OritechRecipe> PACKET_CODEC = class_9139.method_58025(
      class_9135.field_49675, OritechRecipe::getTime,
      class_1856.field_48355.method_56433(class_9135.method_56363()), OritechRecipe::getInputs,
      class_1799.field_49269, OritechRecipe::getResults,
      class_2960.field_48267.method_56432(identifier1 -> (OritechRecipeType) class_7923.field_41188.method_10223(identifier1), OritechRecipeType::getIdentifier), OritechRecipe::getOriType,
      FluidIngredient.PACKET_CODEC, OritechRecipe::getFluidInput,
      NetworkManager.FLUID_STACK_STREAM_CODEC.method_56433(class_9135.method_56363()), OritechRecipe::getFluidOutputs,
      OritechRecipe::new
    );
    
    private final class_2960 identifier;
    
    public class_2960 getIdentifier() {
        return identifier;
    }
    
    public OritechRecipeType(class_2960 identifier) {
        super((StructEndec<OritechRecipe>) ORI_RECIPE_ENDEC);
        this.identifier = identifier;
    }
    
    @Override
    public String toString() {
        return "OritechRecipeType{" +
                 "identifier=" + identifier +
                 '}';
    }
}
