package rearth.oritech.block.blocks.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;

import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class ReactorControllerBlock extends BaseReactorBlock implements class_2343 {
    public ReactorControllerBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12481);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ReactorControllerBlockEntity(pos, state);
    }
    
    @Override
    public boolean validForWalls() {
        return true;
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236 && world.method_8321(pos) instanceof ReactorControllerBlockEntity reactorController) {
            reactorController.init(player);
            
            if (world.method_8510() < reactorController.disabledUntil) {
                player.method_43496(class_2561.method_43471("text.oritech.reactor.cooldown"));
                return class_1269.field_5812;
            }
            
            if (reactorController.active) {
                var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
            }
        }
        
        return class_1269.field_5812;
    }
}
