package rearth.oritech.api.recipe;

import dev.architectury.fluid.FluidStack;
import rearth.oritech.Oritech;
import rearth.oritech.api.recipe.util.MetalProcessingChainBuilder;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;
import rearth.oritech.init.*;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_3489;
import net.minecraft.class_3612;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_5134;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

import static rearth.oritech.api.recipe.util.RecipeHelpers.*;
import static rearth.oritech.util.TagUtils.*;

public class OritechRecipeGenerator extends class_2446 {
    
    public OritechRecipeGenerator(class_7784 output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }
    
    @Override
    public void method_10419(class_8790 exporter) {
        
        addDeepDrillOres(exporter);
        addFuels(exporter);
        addFluidProcessing(exporter);
        addBiomass(exporter);
        addEquipment(exporter);
        addMachines(exporter);
        addComponents(exporter);
        addOreChains(exporter);
        addAlloys(exporter);
        addParticleCollisions(exporter);
        addDusts(exporter);
        addDecorative(exporter);
        addVanillaAdditions(exporter);
        addDyes(exporter);
        addCompactingRecipes(exporter);
        addReactorFuels(exporter);
        addLaserTransformations(exporter);
        addUraniumProcessing(exporter);
        addReactorBlocks(exporter);
        addAugmentRecipes(exporter);
    }
    
    private void addVanillaAdditions(class_8790 exporter) {
        
        // slimeball from honey and biomass
        AssemblerRecipeBuilder.build().input(class_1802.field_20414).input(TagContent.BIOMASS).input(TagContent.BIOMASS).input(TagContent.BIOMASS).result(class_1802.field_8777).timeMultiplier(0.8f).export(exporter, "slime");
        // fireball in assembler (gunpowder, blaze powder + coal) = 5 charges
        AssemblerRecipeBuilder.build().input(class_1802.field_8054).input(class_1802.field_8183).input(class_3489.field_17487).input(class_3489.field_17487).result(class_1802.field_8814, 4).timeMultiplier(0.8f).export(exporter, "fireball");
        // blaze rod (4 powder in assembler)
        AssemblerRecipeBuilder.build().input(class_1802.field_8183).input(class_1802.field_8183).input(class_1802.field_8183).input(class_1802.field_8183).result(class_1802.field_8894).timeMultiplier(0.8f).export(exporter, "blazerod");
        // enderic compound from sculk
        CentrifugeRecipeBuilder.build().input(class_1802.field_37523).result(ItemContent.ENDERIC_COMPOUND).timeMultiplier(4f).export(exporter, "endericsculk");
        // budding amethyst (amethyst shard x2, enderic compound, overcharged crystal)
        AssemblerRecipeBuilder.build().input(cItemTag("gems/amethyst")).input(cItemTag("gems/amethyst")).input(ItemContent.ENDERIC_COMPOUND).input(ItemContent.OVERCHARGED_CRYSTAL).result(class_1802.field_27065).time(160).export(exporter, "amethystbud");
        // netherite alloying (yes this is pretty OP)
        FoundryRecipeBuilder.build().input(cItemTag("ingots/gold")).input(class_1802.field_22021).result(class_1802.field_22020).export(exporter, "netherite");
        // books
        AssemblerRecipeBuilder.build().input(class_1802.field_8407).input(class_1802.field_8407).input(class_1802.field_8407).input(cItemTag("leathers")).result(class_1802.field_8529, 2).timeMultiplier(0.8f).export(exporter, "book");
        // reinforced deepslate
        AtomicForgeRecipeBuilder.build().input(class_1802.field_28866).input(ItemContent.DURATIUM_INGOT).input(ItemContent.DURATIUM_INGOT).result(class_1802.field_38418).time(100).export(exporter, "reinfdeepslate");
        // cobblestone to gravel
        PulverizerRecipeBuilder.build().input(cItemTag("cobblestones")).result(class_1802.field_8110).addToGrinder().export(exporter, "gravel");
        // gravel to sand
        PulverizerRecipeBuilder.build().input(class_1802.field_8110).result(class_1802.field_8858).addToGrinder().export(exporter, "sand");
        // sandstone to sand
        PulverizerRecipeBuilder.build().input(cItemTag("sandstone/blocks")).result(class_1802.field_8858).addToGrinder().export(exporter, "sand_from_sandstone");
        // red sandstone to red sand
        PulverizerRecipeBuilder.build().input(cItemTag("sandstone/red_blocks")).result(class_1802.field_8200).addToGrinder().export(exporter, "red_sand");
        // centrifuge dirt into clay
        CentrifugeFluidRecipeBuilder.build().input(class_3489.field_36269).result(class_1802.field_19060).fluidInput(class_3612.field_15910, 0.25f).export(exporter, "clay");
        // create dirt from sand + biomass
        class_2447.method_10436(class_7800.field_40642, class_1802.field_8831, 2).method_10433('s', class_3489.field_15532).method_10433('b', TagContent.BIOMASS).method_10439("sb").method_10439("bs").method_10429("has_biomass", method_10420(TagContent.BIOMASS)).method_17972(exporter, Oritech.id("dirt_from_sand_and_biomass"));
        // dripstone from dripstone block
        PulverizerRecipeBuilder.build().input(class_1802.field_28043).result(class_1802.field_28042, 4).addToGrinder().export(exporter, "dripstone");
        // shroomlight from logs and 3 glowstone
        AssemblerRecipeBuilder.build().input(class_3489.field_15539).input(class_1802.field_8801).input(class_1802.field_8801).input(class_1802.field_8801).result(class_1802.field_22017).timeMultiplier(0.8f).export(exporter, "shroomlight");
        // prismarine shards to crystals
        PulverizerRecipeBuilder.build().input(class_1802.field_8662).result(class_1802.field_8434, 2).addToGrinder().export(exporter, "prismarine");
        
        // recyclables
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_NETHERITE_SCRAP).result(class_1802.field_22021).addToGrinder().export(exporter, "recycle/netherite_scrap");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_DIAMOND).result(class_1802.field_8477).addToGrinder().export(exporter, "recycle/diamond");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_IRON_DUST).result(ItemContent.IRON_DUST).addToGrinder().export(exporter, "recycle/iron_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_IRON_DUST).result(ItemContent.SMALL_IRON_DUST).export(exporter, "recycle/small_iron_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_GOLD_DUST).result(ItemContent.GOLD_DUST).export(exporter, "recycle/gold_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_GOLD_DUST).result(ItemContent.SMALL_GOLD_DUST).export(exporter, "recycle/small_gold_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_COPPER_DUST).result(ItemContent.COPPER_DUST).export(exporter, "recycle/copper_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_COPPER_DUST).result(ItemContent.SMALL_COPPER_DUST).export(exporter, "recycle/small_copper_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_2_QUARTZ_DUST).result(ItemContent.QUARTZ_DUST, 2).export(exporter, "recycle/2_quartz_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_4_QUARTZ_DUST).result(ItemContent.QUARTZ_DUST, 4).export(exporter, "recycle/4_quartz_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_REDSTONE_DUST).result(class_1802.field_8725).export(exporter, "recycle/redstone_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_GRAVEL).result(class_1802.field_8110).export(exporter, "recycle/gravel");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SAND).result(class_1802.field_8858).export(exporter, "recycle/sand");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_RED_SAND).result(class_1802.field_8200).export(exporter, "recycle/red_sand");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_STRING).result(class_1802.field_8276, 3).export(exporter, "recycle/string");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_BIOMASS).result(ItemContent.BIOMASS).export(exporter, "recycle/biomass");
    }
    
    private void addDyes(class_8790 exporter) {
        PulverizerRecipeBuilder.build().input(TagContent.RAW_WHITE_DYE).result(class_1802.field_8446).addToGrinder().export(exporter, "dyes/white");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_LIGHT_GRAY_DYE).result(class_1802.field_8851).addToGrinder().export(exporter, "dyes/light_gray");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_BLACK_DYE).result(class_1802.field_8226).addToGrinder().export(exporter, "dyes/black");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_RED_DYE).result(class_1802.field_8264).addToGrinder().export(exporter, "dyes/red");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_ORANGE_DYE).result(class_1802.field_8492).addToGrinder().export(exporter, "dyes/orange");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_YELLOW_DYE).result(class_1802.field_8192).addToGrinder().export(exporter, "dyes/yellow");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_CYAN_DYE).result(class_1802.field_8632).addToGrinder().export(exporter, "dyes/cyan");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_BLUE_DYE).result(class_1802.field_8345).addToGrinder().export(exporter, "dyes/blue");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_MAGENTA_DYE).result(class_1802.field_8669).addToGrinder().export(exporter, "dyes/magenta");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_PINK_DYE).result(class_1802.field_8330).addToGrinder().export(exporter, "dyes/pink");
    }
    
    private void addDeepDrillOres(class_8790 exporter) {
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_REDSTONE).result(class_1802.field_8725).export(exporter, "redstone");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_LAPIS).result(class_1802.field_8759).export(exporter, "lapis");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_IRON).result(class_1802.field_33400).export(exporter, "iron");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_COAL).result(class_1802.field_8713).export(exporter, "coal");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_COPPER).result(class_1802.field_33401).export(exporter, "copper");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_GOLD).result(class_1802.field_33402).export(exporter, "gold");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_EMERALD).result(class_1802.field_8687).export(exporter, "emerald");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_DIAMOND).result(class_1802.field_8477).export(exporter, "diamond");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_NICKEL).result(ItemContent.RAW_NICKEL).export(exporter, "nickel");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_PLATINUM).result(ItemContent.RAW_PLATINUM).export(exporter, "platinum");
        DeepDrillRecipeBuilder.build().input(BlockContent.RESOURCE_NODE_URANIUM).result(ItemContent.RAW_URANIUM).export(exporter, "uranium");
    }
    
    private void addFuels(class_8790 exporter) {
        
        // bio
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMATTER).timeInSeconds(15).export(exporter, "rawbio");
        BioGeneratorRecipeBuilder.build().input(ItemContent.PACKED_WHEAT).timeInSeconds(200).export(exporter, "packedwheat");
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMASS).timeInSeconds(25).export(exporter, "biomass");
        BioGeneratorRecipeBuilder.build().input(ItemContent.SOLID_BIOFUEL).timeInSeconds(160).export(exporter, "solidbiomass");
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMASS_BLOCK).timeInSeconds(270).export(exporter, "biomassblock");
        BioGeneratorRecipeBuilder.build().input(ItemContent.RAW_BIOPOLYMER).timeInSeconds(300).export(exporter, "polymer");
        BioGeneratorRecipeBuilder.build().input(ItemContent.UNHOLY_INTELLIGENCE).timeInSeconds(3000).export(exporter, "vex");
        // lava
        LavaGeneratorRecipeBuilder.build().fluidInput(class_3612.field_15908, 0.1f).timeInSeconds(6).export(exporter, "lava");
        LavaGeneratorRecipeBuilder.build().fluidInput(FluidContent.STILL_SHEOL_FIRE.get(), 0.1f).timeInSeconds(40).export(exporter, "sheolfire");
        // fuel
        FuelGeneratorRecipeBuilder.build().fluidInput(cFluidTag("oil"), 0.1f).timeInSeconds(1).export(exporter, "crude");
        FuelGeneratorRecipeBuilder.build().fluidInput(FluidContent.STILL_HEAVY_OIL.get(), 0.1f).timeInSeconds(2).export(exporter, "heavyoil");
        FuelGeneratorRecipeBuilder.build().fluidInput(FluidContent.STILL_DIESEL.get(), 0.1f).timeInSeconds(4).export(exporter, "diesel");
        FuelGeneratorRecipeBuilder.build().fluidInput(FluidContent.STILL_NAPHTHA.get(), 0.1f).timeInSeconds(2).export(exporter, "naptha");
        FuelGeneratorRecipeBuilder.build().fluidInput(TagContent.TURBOFUEL, 0.1f).timeInSeconds(16).export(exporter, "fuel");
        //steam
        // 32 fabric droplets / 32 neoforge mb (yes this will works, as we produce 2 millis per RF in the generator boilers, and then consume it at a 1:1 ratio)
        SteamGeneratorRecipeBuilder.build().specificFluidInput(FluidContent.STILL_STEAM.get(), 32).time(1).export(exporter, "steameng");
    }
    
    private void addFluidProcessing(class_8790 exporter) {
        
        // crude oil processing
        RefineryRecipeBuilder.build()
          .fluidInput(cFluidTag("oil"))
          .fluidOutput(FluidContent.STILL_HEAVY_OIL.get(), 0.5f)
          .fluidOutput(FluidContent.STILL_NAPHTHA.get(), 0.25f)
          .fluidOutput(FluidContent.STILL_SULFURIC_ACID.get(), 0.25f)
          .export(exporter, "oilbase");
        
        RefineryRecipeBuilder.build()
          .input(ItemContent.CLAY_CATALYST_BEADS)
          .fluidInput(cFluidTag("oil"))
          .fluidOutput(FluidContent.STILL_DIESEL.get(), 0.5f)
          .fluidOutput(FluidContent.STILL_NAPHTHA.get(), 0.5f)
          .fluidOutput(FluidContent.STILL_SULFURIC_ACID.get(), 0.5f)
          .timeMultiplier(1.6f)
          .export(exporter, "oilalt");
        
        // heavy oil
        RefineryRecipeBuilder.build()
          .input(class_3489.field_15532)
          .fluidInput(FluidContent.STILL_HEAVY_OIL.get())
          .fluidOutput(FluidContent.STILL_DIESEL.get(), 1f)
          .fluidOutput(FluidContent.STILL_NAPHTHA.get(), 0.25f)
          .fluidOutput(FluidContent.STILL_SULFURIC_ACID.get(), 0.25f)
          .export(exporter, "heavyoil");
        
        // lava
        RefineryRecipeBuilder.build()
          .fluidInput(class_3612.field_15908)
          .fluidOutput(FluidStack.create(FluidContent.STILL_STEAM.get(), 32_000))
          .fluidOutput(FluidContent.STILL_SULFURIC_ACID.get(), 0.1f)
          .fluidOutput(FluidContent.STILL_SHEOL_FIRE.get(), 0.2f)
          .export(exporter, "lava");
        
        RefineryRecipeBuilder.build()
          .input(ItemContent.ENDERIC_COMPOUND)
          .fluidInput(class_3612.field_15908)
          .fluidOutput(FluidContent.STILL_SULFURIC_ACID.get(), 1f)
          .fluidOutput(FluidContent.STILL_SHEOL_FIRE.get(), 0.5f)
          .fluidOutput(FluidContent.STILL_STRANGE_MATTER.get(), 0.2f)
          .timeMultiplier(1.6f)
          .export(exporter, "lavaalt");
        
        // biodiesel
        RefineryRecipeBuilder.build()
          .input(ItemContent.CLAY_CATALYST_BEADS)
          .fluidInput(FluidContent.STILL_BIOFUEL.get())
          .fluidOutput(FluidContent.STILL_DIESEL.get(), 0.5f)
          .fluidOutput(FluidContent.STILL_NAPHTHA.get(), 0.2f)
          .export(exporter, "biodiesel");
        
        // centrifuge turbofuel
        CentrifugeFluidRecipeBuilder
          .build()
          .input(ItemContent.FLUXITE)
          .fluidInput(FluidContent.STILL_DIESEL.get())
          .fluidOutput(FluidContent.STILL_FUEL.get())
          .export(exporter, "fuel");
        
        // centrifuge biofuel
        CentrifugeFluidRecipeBuilder
          .build()
          .input(TagContent.BIOMASS)
          .fluidInput(class_3612.field_15910, 0.25f)
          .fluidOutput(FluidContent.STILL_BIOFUEL.get(), 0.1f)
          .timeMultiplier(0.2f)
          .export(exporter, "biofuel");
        
        // silicon wash from naphtha in centrifuge
        CentrifugeFluidRecipeBuilder.build()
          .input(TagContent.QUARTZ_DUSTS)
          .fluidInput(FluidContent.STILL_NAPHTHA.get())
          .fluidOutput(FluidContent.STILL_SILICON_WASH.get(), 1f)
          .export(exporter, "siliconwash");
        
        CentrifugeFluidRecipeBuilder.build()
          .input(class_1802.field_8110)
          .fluidInput(FluidContent.STILL_NAPHTHA.get())
          .fluidOutput(FluidContent.STILL_SILICON_WASH.get(), 0.05f)
          .timeMultiplier(1.6f)
          .export(exporter, "siliconwashbad");
        
        // polymer resin from naphtha (manual)
        offerManualFluidApplication(exporter, ItemContent.POLYMER_RESIN, of(FluidContent.STILL_NAPHTHA_BUCKET.get()), of(class_3489.field_15532), "manualresin");
        
        // polymer resin from naphtha in centrifuge
        CentrifugeFluidRecipeBuilder.build()
          .input(class_3489.field_15532)
          .fluidInput(FluidContent.STILL_NAPHTHA.get(), 0.1f)
          .result(ItemContent.POLYMER_RESIN, 2)
          .export(exporter, "naptharesin");
        
        // basic battery in centrifuge with sulfuric acid
        CentrifugeFluidRecipeBuilder.build()
          .input(TagContent.STEEL_INGOTS)
          .fluidInput(FluidContent.STILL_SULFURIC_ACID.get())
          .result(ItemContent.BASIC_BATTERY, 2)
          .export(exporter, "batteryacid");
        
        // adv battery in centrifuge with sulfuric acid
        CentrifugeFluidRecipeBuilder.build()
          .input(ItemContent.DUBIOS_CONTAINER)
          .fluidInput(FluidContent.STILL_SULFURIC_ACID.get())
          .result(ItemContent.ADVANCED_BATTERY, 8)
          .timeMultiplier(2f)
          .export(exporter, "advbatteryacid");
        
        // silicon from silicon wash + sand in refinery
        RefineryRecipeBuilder.build()
          .input(class_3489.field_15532)
          .fluidInput(FluidContent.STILL_SILICON_WASH.get())
          .result(ItemContent.SILICON, 4)
          .timeMultiplier(2f)
          .export(exporter, "siliconwashing");
        
        // silicon wafer in centrifuge
        CentrifugeFluidRecipeBuilder.build()
          .input(ItemContent.CARBON_FIBRE_STRANDS)
          .fluidInput(FluidContent.STILL_SILICON_WASH.get())
          .result(ItemContent.SILICON_WAFER, 4)
          .timeMultiplier(2f)
          .export(exporter, "siliconwafers");
        
        // quartz from mineral wash in refinery
        RefineryRecipeBuilder.build()
          .input(ItemContent.CLAY_CATALYST_BEADS)
          .fluidInput(FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f)
          .result(class_1802.field_8155)
          .timeMultiplier(2f)
          .export(exporter, "quartz");
        
        // reinforced carbon sheeting
        RefineryRecipeBuilder.build()
          .input(ItemContent.CARBON_FIBRE_STRANDS)
          .fluidInput(FluidContent.STILL_NAPHTHA.get(), 0.5f)
          .result(ItemContent.REINFORCED_CARBON_SHEET)
          .timeMultiplier(3f)
          .export(exporter, "carbonsheet");
        
        // dubious container and strange matter in centrifuge
        CentrifugeFluidRecipeBuilder.build()
          .input(ItemContent.DUBIOS_CONTAINER)
          .fluidInput(FluidContent.STILL_STRANGE_MATTER.get())
          .result(ItemContent.UNHOLY_INTELLIGENCE, 1)
          .timeMultiplier(8f)
          .export(exporter, "unholyai");
    }
    
    private void addBiomass(class_8790 exporter) {
        // biomass
        PulverizerRecipeBuilder.build().input(TagContent.BIOMATTER).result(ItemContent.BIOMASS).addToGrinder().export(exporter, "biobasic");
        PulverizerRecipeBuilder.build().input(ItemContent.PACKED_WHEAT).result(ItemContent.BIOMASS, 16).addToGrinder().export(exporter, "packagedwheatbio");
        PulverizerRecipeBuilder.build().input(cItemTag("storage_blocks/wheat")).result(ItemContent.BIOMASS, 16).addToGrinder().export(exporter, "hay_block");
        AssemblerRecipeBuilder.build().input(TagContent.BIOMASS).input(TagContent.BIOMASS).input(TagContent.BIOMASS).input(class_3489.field_15537).result(ItemContent.SOLID_BIOFUEL).timeMultiplier(0.8f).export(exporter, "solidbiofuel");
    }
    
    private void addEquipment(class_8790 exporter) {
        offerDrillRecipe(exporter, ToolsContent.HAND_DRILL, of(TagContent.STEEL_INGOTS), of(ItemContent.MOTOR), of(ItemContent.ENDERIC_COMPOUND), of(ItemContent.ADAMANT_INGOT), "handdrill");
        offerChainsawRecipe(exporter, ToolsContent.CHAINSAW, of(TagContent.STEEL_INGOTS), of(ItemContent.MOTOR), of(ItemContent.ENDERIC_COMPOUND), of(ItemContent.ADAMANT_INGOT), "chainsaw");
        offerAxeRecipe(exporter, ToolsContent.PROMETHIUM_AXE, of(ItemContent.PROMETHEUM_INGOT), of(BlockContent.DESTROYER_BLOCK.method_8389()), "promaxe");
        offerPickaxeRecipe(exporter, ToolsContent.PROMETHIUM_PICKAXE, of(ItemContent.PROMETHEUM_INGOT), of(BlockContent.DESTROYER_BLOCK.method_8389()), "prompick");
        
        // enderic laser / portable laser
        offerChainsawRecipe(exporter, ToolsContent.PORTABLE_LASER, of(ItemContent.ADVANCED_BATTERY), of(BlockContent.ACCELERATOR_MOTOR), of(ItemContent.ADAMANT_INGOT), of(BlockContent.LASER_ARM_BLOCK), "portablelaser");
        
        // electric mace
        offerDrillRecipe(exporter, ToolsContent.ELECTRIC_MACE, of(ItemContent.ADVANCED_BATTERY), of(ItemContent.CARBON_FIBRE_STRANDS), of(ItemContent.ADAMANT_INGOT), of(class_1802.field_49813), "_emace");
        
        // designator
        offerDrillRecipe(exporter, ItemContent.TARGET_DESIGNATOR, of(TagContent.STEEL_INGOTS), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.PROCESSING_UNIT), of(TagContent.PLASTIC_PLATES), "designator");
        // weed killer
        offerDrillRecipe(exporter, ItemContent.WEED_KILLER, of(cItemTag("foods/food_poisoning")), of(cItemTag("foods/food_poisoning")), of(ItemContent.RAW_BIOPOLYMER), of(class_1802.field_8469), "weedex");
        // wrench
        offerWrenchRecipe(exporter, ItemContent.WRENCH, of(TagContent.STEEL_INGOTS), of(TagContent.NICKEL_INGOTS), "wrench");
        
        // helmet (enderic lens + machine plating)
        offerHelmetRecipe(exporter, ToolsContent.EXO_HELMET, of(TagContent.MACHINE_PLATING), of(ItemContent.ENDERIC_LENS), "exohelm");
        // chestplate (advanced battery + machine plating)
        offerChestplateRecipe(exporter, ToolsContent.EXO_CHESTPLATE, of(TagContent.MACHINE_PLATING), of(ItemContent.ADVANCED_BATTERY), "exochest");
        // legs (motor + plating)
        offerLegsRecipe(exporter, ToolsContent.EXO_LEGGINGS, of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), "exolegs");
        // feet (silicon + plating)
        offerFeetRecipe(exporter, ToolsContent.EXO_BOOTS, of(TagContent.MACHINE_PLATING), of(TagContent.SILICON), "exoboots");
        
        // basic jetpack main
        offerParticleMotorRecipe(exporter, ToolsContent.JETPACK, of(TagContent.STEEL_INGOTS), of(cItemTag("leathers")), of(ItemContent.ADVANCED_BATTERY), of(class_1802.field_8054), "basicjetpack");
        // jetpack alt
        offerParticleMotorRecipe(exporter, ToolsContent.JETPACK, of(TagContent.STEEL_INGOTS), of(cItemTag("leathers")), of(class_1802.field_8793), of(class_1802.field_8183), "basicjetpackalt");
        // exo jetpack
        offerGeneratorRecipe(exporter, ToolsContent.EXO_JETPACK, of(ToolsContent.JETPACK), of(BlockContent.SMALL_TANK_BLOCK), of(ToolsContent.EXO_CHESTPLATE), of(ItemContent.ION_THRUSTER), "exojetpack");
        // boosted elytra
        offerGeneratorRecipe(exporter, ToolsContent.JETPACK_ELYTRA, of(class_1802.field_8833), of(ItemContent.PROCESSING_UNIT), of(ToolsContent.JETPACK), of(class_1802.field_8054), "boostedelytra");
        // exo elytra (exo jetpack + elytra)
        offerGeneratorRecipe(exporter, ToolsContent.JETPACK_EXO_ELYTRA, of(ToolsContent.EXO_JETPACK), of(ItemContent.PROCESSING_UNIT), of(class_1802.field_8833), of(class_1802.field_8054), "exoboostedelytra");
        // exo elytra (boosted elytra + exo chestplate)
        offerGeneratorRecipe(exporter, ToolsContent.JETPACK_EXO_ELYTRA, of(ToolsContent.EXO_CHESTPLATE), of(BlockContent.SMALL_TANK_BLOCK), of(ToolsContent.JETPACK_ELYTRA), of(ItemContent.ION_THRUSTER), "exoboostedelytraalt");
        
    }
    
    private void addDecorative(class_8790 exporter) {
        // ceiling light
        offerInsulatedCableRecipe(exporter, new class_1799(BlockContent.CEILING_LIGHT.method_8389(), 6), of(class_1802.field_8601), of(TagContent.STEEL_INGOTS), "ceilightlight");
        // hanging light
        offerTwoComponentRecipe(exporter, BlockContent.CEILING_LIGHT_HANGING.method_8389(), of(cItemTag("chains")), of(BlockContent.CEILING_LIGHT.method_8389()), "hanginglight");
        // tech button
        offerLeverRecipe(exporter, BlockContent.TECH_BUTTON.method_8389(), of(cItemTag("ingots/copper")), of(TagContent.STEEL_INGOTS), "techbutton");
        // tech lever
        offerLeverRecipe(exporter, BlockContent.TECH_LEVER.method_8389(), of(TagContent.CARBON_FIBRE), of(TagContent.STEEL_INGOTS), "techlever");
        // tech door
        offerDoorRecipe(exporter, BlockContent.TECH_DOOR.method_8389(), of(TagContent.STEEL_INGOTS), "techdoor");
        // metal beam
        offerRotatedCableRecipe(exporter, new class_1799(BlockContent.METAL_BEAM_BLOCK.method_8389(), 6), of(TagContent.CARBON_FIBRE), of(TagContent.STEEL_INGOTS), "metalbeams");
        // metal girder
        offerInsulatedCableRecipe(exporter, new class_1799(BlockContent.METAL_GIRDER_BLOCK.method_8389(), 6), of(TagContent.CARBON_FIBRE), of(TagContent.STEEL_INGOTS), "metalgirder");
        // tech glass
        offerMachinePlatingRecipe(exporter, BlockContent.INDUSTRIAL_GLASS_BLOCK.method_8389(), of(TagContent.STEEL_INGOTS), of(cItemTag("glass_blocks")), of(TagContent.MACHINE_PLATING), 4, "industrialglass");
        // machine plated stairs, slabs, pressure plates
        offerSlabRecipe(exporter, BlockContent.MACHINE_PLATING_SLAB.method_8389(), of(BlockContent.MACHINE_PLATING_BLOCK.method_8389()), "machine");
        offerStairsRecipe(exporter, BlockContent.MACHINE_PLATING_STAIRS.method_8389(), of(BlockContent.MACHINE_PLATING_BLOCK.method_8389()), "machine");
        offerPressurePlateRecipe(exporter, BlockContent.MACHINE_PLATING_PRESSURE_PLATE.method_8389(), of(BlockContent.MACHINE_PLATING_BLOCK.method_8389()), "machine");
        // iron plated stairs, slabs, pressure plates
        offerSlabRecipe(exporter, BlockContent.IRON_PLATING_SLAB.method_8389(), of(BlockContent.IRON_PLATING_BLOCK.method_8389()), "iron");
        offerStairsRecipe(exporter, BlockContent.IRON_PLATING_STAIRS.method_8389(), of(BlockContent.IRON_PLATING_BLOCK.method_8389()), "iron");
        offerPressurePlateRecipe(exporter, BlockContent.IRON_PLATING_PRESSURE_PLATE.method_8389(), of(BlockContent.IRON_PLATING_BLOCK.method_8389()), "iron");
        // nickel plated stairs, slabs, pressure plates
        offerSlabRecipe(exporter, BlockContent.NICKEL_PLATING_SLAB.method_8389(), of(BlockContent.NICKEL_PLATING_BLOCK.method_8389()), "nickel");
        offerStairsRecipe(exporter, BlockContent.NICKEL_PLATING_STAIRS.method_8389(), of(BlockContent.NICKEL_PLATING_BLOCK.method_8389()), "nickel");
        offerPressurePlateRecipe(exporter, BlockContent.NICKEL_PLATING_PRESSURE_PLATE.method_8389(), of(BlockContent.NICKEL_PLATING_BLOCK.method_8389()), "nickel");
    }
    
    private void addMachines(class_8790 exporter) {
        // basic generator
        offerGeneratorRecipe(exporter, BlockContent.BASIC_GENERATOR_BLOCK.method_8389(), of(cItemTag("player_workstations/furnaces")), of(ItemContent.MAGNETIC_COIL), of(cItemTag("ingots/copper")), of(TagContent.NICKEL_INGOTS), "basicgen");
        // pulverizer
        offerGeneratorRecipe(exporter, BlockContent.PULVERIZER_BLOCK.method_8389(), of(cItemTag("storage_blocks/copper")), of(ItemContent.MOTOR), of(TagContent.NICKEL_INGOTS), of(TagContent.STEEL_INGOTS), "pulverizer");
        offerGeneratorRecipe(exporter, BlockContent.PULVERIZER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(TagContent.NICKEL_INGOTS), of(TagContent.STEEL_INGOTS), "pulverizeralt");
        // electric furnace
        offerFurnaceRecipe(exporter, BlockContent.POWERED_FURNACE_BLOCK.method_8389(), of(cItemTag("player_workstations/furnaces")), of(ItemContent.MAGNETIC_COIL), of(TagContent.SILICON), of(TagContent.ELECTRUM_INGOTS), of(cItemTag("ingots/copper")), "electricfurnace");
        offerFurnaceRecipe(exporter, BlockContent.POWERED_FURNACE_BLOCK.method_8389(), of(cItemTag("player_workstations/furnaces")), of(ItemContent.MAGNETIC_COIL), of(TagContent.PLATINUM_INGOTS), of(TagContent.ELECTRUM_INGOTS), of(cItemTag("ingots/copper")), "electricfurnacealt");
        // assembler
        offerFurnaceRecipe(exporter, BlockContent.ASSEMBLER_BLOCK.method_8389(), of(class_2246.field_16333.method_8389()), of(ItemContent.MOTOR), of(class_1802.field_46791), of(ItemContent.ADAMANT_INGOT), of(cItemTag("ingots/copper")), "assembler");
        offerFurnaceRecipe(exporter, BlockContent.ASSEMBLER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(class_1802.field_46791), of(ItemContent.ADAMANT_INGOT), of(cItemTag("ingots/copper")), "assembleralt");
        // foundry
        offerGeneratorRecipe(exporter, BlockContent.FOUNDRY_BLOCK.method_8389(), of(class_2246.field_10593.method_8389()), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.MOTOR), of(cItemTag("ingots/copper")), "foundry");
        // refinery
        offerParticleMotorRecipe(exporter, BlockContent.REFINERY_BLOCK.method_8389(), of(BlockContent.REFINERY_MODULE_BLOCK.method_8389()), of(ItemContent.MOTOR), of(class_1802.field_8638), of(cItemTag("ingots/steel")), "refinery");
        // refinery module
        offerGeneratorRecipe(exporter, BlockContent.REFINERY_MODULE_BLOCK.method_8389(), of(BlockContent.SMALL_TANK_BLOCK.method_8389()), of(class_1802.field_8777), of(BlockContent.METAL_BEAM_BLOCK), of(cItemTag("ingots/copper")), "refinerymodule");
        offerGeneratorRecipe(exporter, BlockContent.REFINERY_MODULE_BLOCK.method_8389(), of(BlockContent.SMALL_TANK_BLOCK.method_8389()), of(ItemContent.SILICON), of(BlockContent.METAL_BEAM_BLOCK), of(cItemTag("ingots/copper")), "refinerymodulealt");
        // cooler
        offerGeneratorRecipe(exporter, BlockContent.COOLER_BLOCK.method_8389(), of(class_2246.field_10593.method_8389()), of(class_2246.field_10295.method_8389()), of(ItemContent.MOTOR), of(cItemTag("ingots/iron")), "cooler");
        // centrifuge
        offerFurnaceRecipe(exporter, BlockContent.CENTRIFUGE_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.PROCESSING_UNIT), of(ItemContent.MOTOR), of(TagContent.STEEL_INGOTS), of(class_1802.field_8469), "centrifuge");
        offerFurnaceRecipe(exporter, BlockContent.CENTRIFUGE_BLOCK.method_8389(), of(ItemContent.MOTOR), of(cItemTag("storage_blocks/iron")), of(cItemTag("ingots/copper")), of(ItemContent.MOTOR), of(class_1802.field_8469), "centrifugealt");
        // laser arm
        offerAtomicForgeRecipe(exporter, BlockContent.LASER_ARM_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.ENDERIC_LENS), of(TagContent.CARBON_FIBRE), "laserarm");
        // crusher
        offerGeneratorRecipe(exporter, BlockContent.FRAGMENT_FORGE_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(ItemContent.FLUX_GATE), of(TagContent.PLASTIC_PLATES), "crusher");
        // atomic forge
        offerAtomicForgeRecipe(exporter, BlockContent.ATOMIC_FORGE_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.PLASTIC_PLATES), of(ItemContent.ENDERIC_COMPOUND), of(ItemContent.DURATIUM_INGOT), of(ItemContent.FLUX_GATE), "atomicforge");
        
        // biofuel generator
        offerGeneratorRecipe(exporter, BlockContent.BIO_GENERATOR_BLOCK.method_8389(), of(BlockContent.BASIC_GENERATOR_BLOCK.method_8389()), of(ItemContent.MAGNETIC_COIL), of(ItemContent.FLUX_GATE), of(ItemContent.BIOSTEEL_INGOT), "biogen");
        // lava generator
        offerGeneratorRecipe(exporter, BlockContent.LAVA_GENERATOR_BLOCK.method_8389(), of(BlockContent.BASIC_GENERATOR_BLOCK.method_8389()), of(TagContent.MACHINE_PLATING), of(ItemContent.MAGNETIC_COIL), of(TagContent.ELECTRUM_INGOTS), "lavagen");
        // steam engine
        offerGeneratorRecipe(exporter, BlockContent.STEAM_ENGINE_BLOCK.method_8389(), of(BlockContent.BASIC_GENERATOR_BLOCK.method_8389()), of(cItemTag("ingots/copper")), of(ItemContent.MAGNETIC_COIL), of(TagContent.ELECTRUM_INGOTS), "steamgen");
        // diesel generator
        offerGeneratorRecipe(exporter, BlockContent.FUEL_GENERATOR_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(BlockContent.BASIC_GENERATOR_BLOCK), of(ItemContent.ENDERIC_LENS), of(TagContent.STEEL_INGOTS), "fuelgen");
        // large solar
        offerGeneratorRecipe(exporter, BlockContent.BIG_SOLAR_PANEL_BLOCK.method_8389(), of(BlockContent.BASIC_GENERATOR_BLOCK.method_8389()), of(ItemContent.FLUX_GATE), of(ItemContent.ADVANCED_BATTERY), of(ItemContent.FLUXITE), "solar");
        
        // charger
        offerAtomicForgeRecipe(exporter, BlockContent.CHARGER_BLOCK.method_8389(), of(cItemTag("chests/wooden")), of(BlockContent.ENERGY_PIPE), of(cItemTag("storage_blocks/redstone")), of(class_1802.field_8357), of(TagContent.STEEL_INGOTS), "charger");
        offerAtomicForgeRecipe(exporter, BlockContent.CHARGER_BLOCK.method_8389(), of(cItemTag("chests/wooden")), of(BlockContent.ENERGY_PIPE), of(ItemContent.PROCESSING_UNIT), of(class_1802.field_8357), of(TagContent.STEEL_INGOTS), "chargeralt");
        
        // small storage
        offerAtomicForgeRecipe(exporter, BlockContent.SMALL_STORAGE_BLOCK.method_8389(), of(ItemContent.BASIC_BATTERY), of(TagContent.SILICON), of(ItemContent.MAGNETIC_COIL), of(TagContent.NICKEL_INGOTS), of(TagContent.NICKEL_INGOTS), "smallstorage");
        // large storage
        offerAtomicForgeRecipe(exporter, BlockContent.LARGE_STORAGE_BLOCK.method_8389(), of(ItemContent.ADVANCED_BATTERY), of(TagContent.STEEL_INGOTS), of(ItemContent.DUBIOS_CONTAINER), of(ItemContent.FLUX_GATE), of(ItemContent.MAGNETIC_COIL), "bigstorage");
        // unstable container
        offerAtomicForgeRecipe(exporter, ItemContent.UNSTABLE_CONTAINER, of(ItemContent.FLUXITE), of(ItemContent.DURATIUM_INGOT), of(BlockContent.LARGE_STORAGE_BLOCK), of(ItemContent.FLUX_GATE), of(ItemContent.SUPER_AI_CHIP), "unstablecontainer");
        
        // fluid tank
        offerTankRecipe(exporter, BlockContent.SMALL_TANK_BLOCK.method_8389(), of(cItemTag("ingots/copper")), of(cItemTag("glass_blocks")), of(BlockContent.FLUID_PIPE.method_8389()), "stank");
        // pump
        offerGeneratorRecipe(exporter, BlockContent.PUMP_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.SILICON), of(ItemContent.MOTOR), of(cItemTag("ingots/copper")), "pump");
        // block placer
        offerFurnaceRecipe(exporter, BlockContent.PLACER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(ItemContent.PROCESSING_UNIT), of(BlockContent.MACHINE_FRAME_BLOCK.method_8389()), of(cItemTag("ingots/copper")), "placer");
        // block destroyer
        offerAtomicForgeRecipe(exporter, BlockContent.DESTROYER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(BlockContent.PULVERIZER_BLOCK), of(BlockContent.LASER_ARM_BLOCK), of(ItemContent.MOTOR), "destroyer");
        // fertilizer
        offerFurnaceRecipe(exporter, BlockContent.FERTILIZER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(TagContent.SILICON), of(ItemContent.PROCESSING_UNIT), of(cItemTag("ingots/copper")), "fertilizer");
        // tree feller
        offerGeneratorRecipe(exporter, BlockContent.TREEFELLER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(class_1802.field_8475), of(ItemContent.MOTOR), of(TagContent.ELECTRUM_INGOTS), "treefeller");
        // pipe booster
        offerTankRecipe(exporter, BlockContent.PIPE_BOOSTER_BLOCK.method_8389(), of(BlockContent.ITEM_PIPE), of(ItemContent.MOTOR), of(BlockContent.FLUID_PIPE), "booster");
        
        // machine frame
        offerMachineFrameRecipe(exporter, BlockContent.MACHINE_FRAME_BLOCK.method_8389(), of(class_1802.field_8076), of(TagContent.NICKEL_INGOTS), 16, "frame");
        // energy pipe
        offerCableRecipe(exporter, new class_1799(BlockContent.ENERGY_PIPE.method_8389(), 6), of(TagContent.ELECTRUM_INGOTS), "energy");
        // item pipe
        offerInsulatedCableRecipe(exporter, new class_1799(BlockContent.ITEM_PIPE.method_8389(), 6), of(TagContent.NICKEL_INGOTS), of(class_3489.field_15537), "item");
        // item filter
        offerGeneratorRecipe(exporter, BlockContent.ITEM_FILTER_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(class_3489.field_15537), of(ItemContent.PROCESSING_UNIT), of(class_3489.field_15537), "itemfilter");
        // fluid pipe
        offerInsulatedCableRecipe(exporter, new class_1799(BlockContent.FLUID_PIPE.method_8389(), 6), of(TagContent.SILICON), of(cItemTag("ingots/copper")), "fluidpipe");
        
        // framed energy pipe
        offerFramedCableRecipe(exporter, new class_1799(BlockContent.FRAMED_ENERGY_PIPE, 8), of(BlockContent.ENERGY_PIPE), "energy");
        offerCableFromFrameRecipe(exporter, new class_1799(BlockContent.ENERGY_PIPE, 1), of(BlockContent.FRAMED_ENERGY_PIPE), "energy");
        // framed superconductor
        offerFramedCableRecipe(exporter, new class_1799(BlockContent.FRAMED_SUPERCONDUCTOR, 8), of(BlockContent.SUPERCONDUCTOR.method_8389()), "superconductor");
        offerCableFromFrameRecipe(exporter, new class_1799(BlockContent.SUPERCONDUCTOR.method_8389(), 1), of(BlockContent.FRAMED_SUPERCONDUCTOR), "superconductor");
        // framed fluid pipe
        offerFramedCableRecipe(exporter, new class_1799(BlockContent.FRAMED_FLUID_PIPE, 8), of(BlockContent.FLUID_PIPE), "fluid");
        offerCableFromFrameRecipe(exporter, new class_1799(BlockContent.FLUID_PIPE, 1), of(BlockContent.FRAMED_FLUID_PIPE), "fluid");
        // framed item pipe
        offerFramedCableRecipe(exporter, new class_1799(BlockContent.FRAMED_ITEM_PIPE, 8), of(BlockContent.ITEM_PIPE), "item");
        offerCableFromFrameRecipe(exporter, new class_1799(BlockContent.ITEM_PIPE, 1), of(BlockContent.FRAMED_ITEM_PIPE), "item");
        
        // transparent pipe
        offerTankRecipe(exporter, BlockContent.TRANSPARENT_ITEM_PIPE.method_8389(), 6, of(class_3489.field_15537), of(TagContent.NICKEL_INGOTS), of(cItemTag("glass_blocks")), "transparentitem");
        offerMachineCoreRecipe(exporter, BlockContent.TRANSPARENT_ITEM_PIPE.method_8389(), 8, of(BlockContent.ITEM_PIPE), of(cItemTag("glass_blocks")), "totransparent");
        offerMachineCoreRecipe(exporter, BlockContent.ITEM_PIPE.method_8389(), 8, of(BlockContent.TRANSPARENT_ITEM_PIPE), of(class_3489.field_15537), "fromtransparent");
        
        // energy pipe duct
        offerCableDuctRecipe(exporter, new class_1799(BlockContent.ENERGY_PIPE_DUCT_BLOCK, 4), of(BlockContent.ENERGY_PIPE), "energy");
        offerCableFromDuctRecipe(exporter, new class_1799(BlockContent.ENERGY_PIPE, 1), of(BlockContent.ENERGY_PIPE_DUCT_BLOCK), "energy");
        // superconductor duct
        offerCableDuctRecipe(exporter, new class_1799(BlockContent.SUPERCONDUCTOR_DUCT_BLOCK, 4), of(BlockContent.SUPERCONDUCTOR.method_8389()), "superconductor");
        offerCableFromDuctRecipe(exporter, new class_1799(BlockContent.SUPERCONDUCTOR.method_8389(), 1), of(BlockContent.SUPERCONDUCTOR_DUCT_BLOCK), "superconductor");
        // fluid pipe duct
        offerCableDuctRecipe(exporter, new class_1799(BlockContent.FLUID_PIPE_DUCT_BLOCK, 4), of(BlockContent.FLUID_PIPE), "fluid");
        offerCableFromDuctRecipe(exporter, new class_1799(BlockContent.FLUID_PIPE, 1), of(BlockContent.FLUID_PIPE_DUCT_BLOCK), "fluid");
        // item pipe duct
        offerCableDuctRecipe(exporter, new class_1799(BlockContent.ITEM_PIPE_DUCT_BLOCK, 4), of(BlockContent.ITEM_PIPE), "item");
        offerCableFromDuctRecipe(exporter, new class_1799(BlockContent.ITEM_PIPE, 1), of(BlockContent.ITEM_PIPE_DUCT_BLOCK), "item");
        
        // deep drill
        offerAtomicForgeRecipe(exporter, BlockContent.DEEP_DRILL_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(ItemContent.HEISENBERG_COMPENSATOR), of(ItemContent.OVERCHARGED_CRYSTAL), of(ItemContent.DURATIUM_INGOT), "deepdrill");
        // drone port
        offerAtomicForgeRecipe(exporter, BlockContent.DRONE_PORT_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(BlockContent.SUPERCONDUCTOR.method_8389()), of(ItemContent.UNHOLY_INTELLIGENCE), of(ItemContent.ADVANCED_COMPUTING_ENGINE), "droneport");
        offerAtomicForgeRecipe(exporter, BlockContent.DRONE_PORT_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(BlockContent.SUPERCONDUCTOR.method_8389()), of(ItemContent.SUPER_AI_CHIP), of(ItemContent.ADVANCED_COMPUTING_ENGINE), "droneportalt");
        
        // arcane catalyst
        offerFurnaceRecipe(exporter, BlockContent.ENCHANTMENT_CATALYST_BLOCK.method_8389(), of(class_1802.field_8657), of(ItemContent.ADAMANT_INGOT), of(cItemTag("obsidians/normal")), of(ItemContent.UNHOLY_INTELLIGENCE), of(ItemContent.FLUXITE), "catalyst");
        offerFurnaceRecipe(exporter, BlockContent.ENCHANTMENT_CATALYST_BLOCK.method_8389(), of(class_1802.field_8657), of(ItemContent.ADAMANT_INGOT), of(cItemTag("obsidians/normal")), of(ItemContent.SUPER_AI_CHIP), of(ItemContent.FLUXITE), "catalyst_alt");
        // enchanter
        offerGeneratorRecipe(exporter, BlockContent.ENCHANTER_BLOCK.method_8389(), of(ItemContent.DURATIUM_INGOT), of(ItemContent.ENERGITE_INGOT), of(BlockContent.ENCHANTMENT_CATALYST_BLOCK.method_8389()), of(class_1802.field_8529), "enchanter");
        // spawner
        offerTankRecipe(exporter, BlockContent.SPAWNER_CONTROLLER_BLOCK.method_8389(), of(BlockContent.SPAWNER_CAGE_BLOCK), of(class_2246.field_23152), of(BlockContent.ENCHANTMENT_CATALYST_BLOCK), "spawner");
        // spawner cage
        offerInsulatedCableRecipe(exporter, new class_1799(BlockContent.SPAWNER_CAGE_BLOCK, 2), of(TagContent.PLASTIC_PLATES), of(class_1802.field_8076), "cage");
        // withered rose
        offerMachineFrameRecipe(exporter, BlockContent.WITHER_CROP_BLOCK.method_8389(), of(class_1802.field_17515), of(class_3489.field_20344), 1, "witherrose");
        
        // particle accelerator
        // motor
        offerParticleMotorRecipe(exporter, BlockContent.ACCELERATOR_MOTOR.method_8389(), of(TagContent.ELECTRUM_INGOTS), of(BlockContent.SUPERCONDUCTOR.method_8389()), of(ItemContent.DURATIUM_INGOT), of(ItemContent.ION_THRUSTER), "particlemotor");
        // ring
        offerDrillRecipe(exporter, BlockContent.ACCELERATOR_RING.method_8389(), of(BlockContent.INDUSTRIAL_GLASS_BLOCK.method_8389()), of(BlockContent.SUPERCONDUCTOR.method_8389()), of(TagContent.STEEL_INGOTS), of(class_1802.field_8530), "acceleratorring");
        // controller
        offerGeneratorRecipe(exporter, BlockContent.ACCELERATOR_CONTROLLER.method_8389(), of(BlockContent.ACCELERATOR_MOTOR.method_8389()), of(ItemContent.FLUX_GATE), of(class_1802.field_8878), of(ItemContent.DURATIUM_INGOT), "particlecontroller");
        // sensor
        offerTwoComponentRecipe(exporter, BlockContent.ACCELERATOR_SENSOR.method_8389(), of(BlockContent.ACCELERATOR_RING.method_8389()), of(class_1802.field_8537), "particlesensor");
        // collector
        offerTankRecipe(exporter, BlockContent.PARTICLE_COLLECTOR_BLOCK.method_8389(), of(BlockContent.SUPERCONDUCTOR.method_8389()), of(BlockContent.BIG_SOLAR_PANEL_BLOCK.method_8389()), of(ItemContent.HEISENBERG_COMPENSATOR), "particlecollector");
        
        // addons
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_SPEED_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MAGNETIC_COIL), of(TagContent.STEEL_INGOTS), of(TagContent.PLASTIC_PLATES), "addon/speed");
        offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_PROCESSING_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.SUPER_AI_CHIP), of(ItemContent.FLUX_GATE), of(TagContent.PLATINUM_INGOTS), of(ItemContent.MOTOR), "addon/processing");
        offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_PROCESSING_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.UNHOLY_INTELLIGENCE), of(class_1802.field_8857), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.MOTOR), "addon/processingalt");
        offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_ULTIMATE_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.HEISENBERG_COMPENSATOR), of(BlockContent.MACHINE_SPEED_ADDON), of(BlockContent.MACHINE_EFFICIENCY_ADDON), of(ItemContent.OVERCHARGED_CRYSTAL), "addon/ultimate");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_EFFICIENCY_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.CARBON_FIBRE), of(TagContent.ELECTRUM_INGOTS), of(TagContent.PLASTIC_PLATES), "addon/eff");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_CAPACITOR_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.ENERGITE_INGOT), of(ItemContent.MAGNETIC_COIL), of(TagContent.PLASTIC_PLATES), "addon/capacitor");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_ACCEPTOR_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.ENERGITE_INGOT), of(TagContent.PLASTIC_PLATES), "addon/acceptor");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_YIELD_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.ELECTRUM_INGOTS), of(ItemContent.ENDERIC_LENS), of(TagContent.PLASTIC_PLATES), "addon/yield");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_FLUID_ADDON.method_8389(), of(TagContent.SILICON), of(TagContent.ELECTRUM_INGOTS), of(BlockContent.FLUID_PIPE), of(TagContent.CARBON_FIBRE), "addon/fluid");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_INVENTORY_PROXY_ADDON.method_8389(), of(ItemContent.MOTOR), of(cItemTag("chests")), of(ItemContent.PROCESSING_UNIT), of(TagContent.CARBON_FIBRE), "addon/invproxy");
        offerGeneratorRecipe(exporter, BlockContent.CROP_FILTER_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(ItemContent.PROCESSING_UNIT), of(TagContent.CARBON_FIBRE), "addon/cropfilter");
        offerGeneratorRecipe(exporter, BlockContent.QUARRY_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(class_1802.field_8377), of(TagContent.PLASTIC_PLATES), "addon/quarry");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_HUNTER_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(class_1802.field_8371), of(TagContent.PLASTIC_PLATES), "_hunter");
        offerGeneratorRecipe(exporter, BlockContent.STEAM_BOILER_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.ADAMANT_INGOT), of(cItemTag("ingots/copper")), of(BlockContent.FLUID_PIPE), "addon/steamboiler");
        offerGeneratorRecipe(exporter, BlockContent.STEAM_BOILER_ADDON.method_8389(), of(TagContent.SILICON), of(ItemContent.ADAMANT_INGOT), of(BlockContent.FLUID_PIPE), of(TagContent.COAL_DUSTS), "addon/steamboileralt");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_REDSTONE_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(class_1802.field_8619), of(class_1802.field_8857), of(cItemTag("dusts/redstone")), "addon/redstone");
        offerGeneratorRecipe(exporter, BlockContent.MACHINE_SILK_TOUCH_ADDON.method_8389(), of(TagContent.MACHINE_PLATING), of(class_3489.field_15544), of(class_1802.field_8377), of(TagContent.PLASTIC_PLATES), "addon/silktouch");
        offerTwoComponentRecipe(exporter, BlockContent.CAPACITOR_ADDON_EXTENDER.method_8389(), of(BlockContent.MACHINE_EXTENDER.method_8389()), of(BlockContent.MACHINE_CAPACITOR_ADDON), "addon/capextender");
        
        // cores
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_1.method_8389(), of(class_3489.field_15537), of(class_1802.field_8465), "core1");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_2.method_8389(), of(cItemTag("ingots/copper")), of(cItemTag("gems/lapis")), "core2");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_2.method_8389(), of(cItemTag("ingots/iron")), of(cItemTag("gems/lapis")), "core2alt");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_3.method_8389(), of(TagContent.CARBON_FIBRE), of(cItemTag("dusts/redstone")), "core3");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_3.method_8389(), of(TagContent.NICKEL_INGOTS), of(cItemTag("dusts/redstone")), "core3alt");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_4.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.ENDERIC_COMPOUND), "core4");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_5.method_8389(), of(ItemContent.ADAMANT_INGOT), of(ItemContent.ADVANCED_COMPUTING_ENGINE), "core5");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_6.method_8389(), of(ItemContent.DURATIUM_INGOT), of(ItemContent.DUBIOS_CONTAINER), "core6");
        offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_7.method_8389(), of(ItemContent.PROMETHEUM_INGOT), of(BlockContent.SUPERCONDUCTOR.method_8389()), "core7");
        
        // machine extender
        offerMachinePlatingRecipe(exporter, BlockContent.MACHINE_EXTENDER.method_8389(), of(TagContent.MACHINE_PLATING), of(BlockContent.MACHINE_CORE_2.method_8389()), of(ItemContent.DURATIUM_INGOT), 1, "extender");
        
        // augmenter
        // machine itself
        offerAtomicForgeRecipe(exporter, BlockContent.AUGMENT_APPLICATION_BLOCK.method_8389(), of(TagContent.MACHINE_PLATING), of(ItemContent.MOTOR), of(class_1802.field_8106), of(TagContent.CARBON_FIBRE), of(ItemContent.DUBIOS_CONTAINER), "augment/applicator");
        // basic station
        offerGeneratorRecipe(exporter, BlockContent.SIMPLE_AUGMENT_STATION.method_8389(), of(class_1802.field_8740), of(TagContent.MACHINE_PLATING), of(cItemTag("storage_blocks/redstone")), of(TagContent.ELECTRUM_INGOTS), "augment/basic");
        // adv station
        offerGeneratorRecipe(exporter, BlockContent.ADVANCED_AUGMENT_STATION.method_8389(), of(BlockContent.CENTRIFUGE_BLOCK), of(TagContent.MACHINE_PLATING), of(ItemContent.FLUX_GATE), of(ItemContent.DURATIUM_INGOT), "augment/advanced");
        // arcane station
        offerGeneratorRecipe(exporter, BlockContent.ARCANE_AUGMENT_STATION.method_8389(), of(class_1802.field_8449), of(TagContent.MACHINE_PLATING), of(ItemContent.ENDERIC_LENS), of(ItemContent.OVERCHARGED_CRYSTAL), "augment/arcane");
        
    }
    
    private void addComponents(class_8790 exporter) {
        // coal stuff (including basic steel)
        CentrifugeRecipeBuilder.build().input(TagContent.COAL_DUSTS).result(ItemContent.CARBON_FIBRE_STRANDS).timeMultiplier(0.5f).export(exporter, "carbon");
        offerManualAlloyRecipe(exporter, ItemContent.STEEL_INGOT, of(cItemTag("ingots/iron")), of(class_3489.field_17487), "steel");
        
        // manual alloys
        offerManualAlloyRecipe(exporter, ItemContent.ELECTRUM_INGOT, of(cItemTag("ingots/gold")), of(cItemTag("dusts/redstone")), "electrum");
        offerManualAlloyRecipe(exporter, ItemContent.ADAMANT_INGOT, of(TagContent.NICKEL_INGOTS), of(cItemTag("gems/diamond")), "adamant");
        
        // enderic entry
        PulverizerRecipeBuilder.build().input(cItemTag("ender_pearls")).result(ItemContent.ENDERIC_COMPOUND, 8).export(exporter, "pearl_enderic");
        GrinderRecipeBuilder.build().input(cItemTag("ender_pearls")).result(ItemContent.ENDERIC_COMPOUND, 12).export(exporter, "pearl_enderic");
        GrinderRecipeBuilder.build().input(class_2246.field_10471).result(ItemContent.ENDERIC_COMPOUND).export(exporter, "stone_enderic");
        
        // clay beads
        offerBeadsRecipe(exporter,ItemContent.CLAY_CATALYST_BEADS, 8, of(class_1802.field_8696), of(class_3489.field_15532), of(class_1802.field_8725), "claybeads");
        AssemblerRecipeBuilder.build().input(class_1802.field_8696).input(class_1802.field_8696).input(class_3489.field_15532).input(class_1802.field_8725).result(ItemContent.CLAY_CATALYST_BEADS, 32).timeMultiplier(1f).export(exporter, "claybeads");
        
        // magnetic coils
        offerInsulatedCableRecipe(exporter, new class_1799(ItemContent.MAGNETIC_COIL, 4), of(TagContent.STEEL_INGOTS), of(TagContent.NICKEL_INGOTS), "magnet");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(cItemTag("ingots/copper")).result(ItemContent.MAGNETIC_COIL, 6).timeMultiplier(0.4f).export(exporter, "magnet");
        
        // motor
        offerMotorRecipe(exporter, ItemContent.MOTOR, of(TagContent.NICKEL_INGOTS), of(ItemContent.MAGNETIC_COIL), of(TagContent.STEEL_INGOTS), "motorcraft");
        AssemblerRecipeBuilder.build().input(TagContent.NICKEL_INGOTS).input(TagContent.STEEL_INGOTS).input(ItemContent.MAGNETIC_COIL).input(ItemContent.MAGNETIC_COIL).result(ItemContent.MOTOR, 2).timeMultiplier(0.4f).export(exporter, "motor");
        
        // machine plating variants
        offerMachinePlatingRecipe(exporter, BlockContent.MACHINE_PLATING_BLOCK.method_8389(), of(TagContent.STEEL_INGOTS), of(class_2246.field_10340.method_8389()), of(cItemTag("ingots/copper")), 2, "plating");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(cItemTag("ingots/copper")).input(TagContent.PLASTIC_PLATES).result(BlockContent.MACHINE_PLATING_BLOCK.method_8389(), 8).timeMultiplier(0.8f).export(exporter, "plating");
        offerMachinePlatingRecipe(exporter, BlockContent.IRON_PLATING_BLOCK.method_8389(), of(TagContent.STEEL_INGOTS), of(class_2246.field_10340.method_8389()), of(cItemTag("ingots/iron")), 2, "iron");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(cItemTag("ingots/iron")).input(TagContent.PLASTIC_PLATES).result(BlockContent.IRON_PLATING_BLOCK.method_8389(), 8).timeMultiplier(0.8f).export(exporter, "platingiron");
        offerMachinePlatingRecipe(exporter, BlockContent.NICKEL_PLATING_BLOCK.method_8389(), of(TagContent.STEEL_INGOTS), of(class_2246.field_10340.method_8389()), of(TagContent.NICKEL_INGOTS), 2, "nickel");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(TagContent.PLASTIC_PLATES).result(BlockContent.NICKEL_PLATING_BLOCK.method_8389(), 8).timeMultiplier(0.8f).export(exporter, "platingnickel");
        offerMachinePlatingRecipe(exporter, BlockContent.CARBON_PLATING_BLOCK.method_8389(), of(TagContent.STEEL_INGOTS), of(class_2246.field_10340.method_8389()), of(ItemContent.REINFORCED_CARBON_SHEET), 2, "carbon");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(ItemContent.REINFORCED_CARBON_SHEET).input(TagContent.PLASTIC_PLATES).result(BlockContent.CARBON_PLATING_BLOCK.method_8389(), 8).timeMultiplier(0.8f).export(exporter, "platingcarbon");
        
        // basic battery
        offerMotorRecipe(exporter, ItemContent.BASIC_BATTERY, of(TagContent.STEEL_INGOTS), of(TagContent.ELECTRUM_INGOTS), of(TagContent.PLASTIC_PLATES), "manualbattery");
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input(TagContent.ELECTRUM_INGOTS).input(TagContent.ELECTRUM_INGOTS).input(TagContent.STEEL_INGOTS).result(ItemContent.BASIC_BATTERY).timeMultiplier(0.4f).export(exporter, "battery");
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input(ItemContent.FLUXITE).input(ItemContent.FLUXITE).input(TagContent.STEEL_INGOTS).result(ItemContent.BASIC_BATTERY, 2).timeMultiplier(0.8f).export(exporter, "batterybetter");
        
        // silicon
        offerManualAlloyRecipe(exporter, ItemContent.RAW_SILICON, of(TagContent.QUARTZ_DUSTS), of(class_3489.field_15532), 3, "rawsilicon");
        method_36233(exporter, List.of(ItemContent.RAW_SILICON), class_7800.field_40642, ItemContent.SILICON, 0.5f, 60, "siliconfurnace");
        
        // plastic
        method_46209(exporter, class_7800.field_40642, ItemContent.PACKED_WHEAT, class_1802.field_8861);
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.PACKED_WHEAT).result(ItemContent.RAW_BIOPOLYMER).fluidInput(class_3612.field_15910, 0.25f).export(exporter, "biopolymer");
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.SOLID_BIOFUEL).result(ItemContent.RAW_BIOPOLYMER).fluidInput(class_3612.field_15910, 0.25f).export(exporter, "biopolymer_biomass");
        CentrifugeFluidRecipeBuilder.build().input(TagContent.BIOMASS_BLOCK).result(ItemContent.RAW_BIOPOLYMER).fluidInput(class_3612.field_15910, 0.25f).export(exporter, "biopolymer_bioblock");
        CentrifugeFluidRecipeBuilder.build().input(class_3489.field_15532).result(ItemContent.POLYMER_RESIN).fluidInput(cFluidTag("biodiesel"), 0.1f).time(100).export(exporter, "polymerresin");
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.RAW_BIOPOLYMER).result(ItemContent.PLASTIC_SHEET, 1).fluidInput(class_3612.field_15910, 0.5f).time(120).export(exporter, "plasticoil");
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.RAW_BIOPOLYMER).result(ItemContent.PLASTIC_SHEET, 2).fluidInput(FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).time(120).export(exporter, "plasticoilbetter");
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.POLYMER_RESIN).result(ItemContent.PLASTIC_SHEET, 2).fluidInput(class_3612.field_15910, 0.5f).time(40).export(exporter, "plasticbio");
        CentrifugeFluidRecipeBuilder.build().input(ItemContent.POLYMER_RESIN).result(ItemContent.PLASTIC_SHEET, 4).fluidInput(FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).time(40).export(exporter, "plasticbiobetter");
        method_36233(exporter, List.of(ItemContent.POLYMER_RESIN), class_7800.field_40642, ItemContent.PLASTIC_SHEET, 0.5f, 10, "plastic_manual");
        method_36234(exporter, List.of(ItemContent.POLYMER_RESIN), class_7800.field_40642, ItemContent.PLASTIC_SHEET, 0.5f, 10, "plastic_manual_blast");
        
        // processing unit
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input(TagContent.CARBON_FIBRE).input(TagContent.ELECTRUM_INGOTS).input(cItemTag("dusts/redstone")).result(ItemContent.PROCESSING_UNIT).timeMultiplier(0.8f).export(exporter, "processingunit");
        // enderic lens
        AssemblerRecipeBuilder.build().input(ItemContent.ADAMANT_INGOT).input(TagContent.CARBON_FIBRE).input(ItemContent.ENDERIC_COMPOUND).input(ItemContent.ENDERIC_COMPOUND).result(ItemContent.ENDERIC_LENS).timeMultiplier(1.2f).export(exporter, "enderlens");
        // flux gate
        AssemblerRecipeBuilder.build().input(ItemContent.PROCESSING_UNIT).input(ItemContent.FLUXITE).input(ItemContent.FLUXITE).input(TagContent.PLATINUM_INGOTS).result(ItemContent.FLUX_GATE).timeMultiplier(1.2f).export(exporter, "fluxgate");
        
        // ai processor tree
        AtomicForgeRecipeBuilder.build().input(TagContent.CARBON_FIBRE).input(TagContent.SILICON).input(TagContent.SILICON).result(ItemContent.SILICON_WAFER).time(5).export(exporter, "wafer");
        AtomicForgeRecipeBuilder.build().input(ItemContent.PROCESSING_UNIT).input(ItemContent.SILICON_WAFER).input(ItemContent.SILICON_WAFER).result(ItemContent.ADVANCED_COMPUTING_ENGINE).time(5).export(exporter, "advcomputer");
        AtomicForgeRecipeBuilder.build().input(ItemContent.DURATIUM_INGOT).input(ItemContent.ADVANCED_COMPUTING_ENGINE).input(ItemContent.ADVANCED_COMPUTING_ENGINE).result(ItemContent.SUPER_AI_CHIP).time(50).export(exporter, "aicomputer");
        
        // dubios container
        offerMotorRecipe(exporter, ItemContent.DUBIOS_CONTAINER, of(TagContent.PLASTIC_PLATES), of(ItemContent.ADAMANT_INGOT), of(ItemContent.ENDERIC_COMPOUND), "dubios");
        // adv battery
        offerMotorRecipe(exporter, ItemContent.ADVANCED_BATTERY, of(TagContent.ELECTRUM_INGOTS), of(ItemContent.ENERGITE_INGOT), of(TagContent.STEEL_INGOTS), "advbattery");
        
        // ion thruster
        AssemblerRecipeBuilder.build().input(ItemContent.REINFORCED_CARBON_SHEET).input(ItemContent.REINFORCED_CARBON_SHEET).input(ItemContent.ADVANCED_BATTERY).input(ItemContent.FLUX_GATE).result(ItemContent.ION_THRUSTER, 2).timeMultiplier(2f).export(exporter, "ionthruster");
        
        // biosteel
        FoundryRecipeBuilder.build().input(ItemContent.RAW_BIOPOLYMER).input(cItemTag("ingots/iron")).result(ItemContent.BIOSTEEL_INGOT).export(exporter, "biosteel");
        
        // endgame components
        AtomicForgeRecipeBuilder.build().input(ItemContent.SUPER_AI_CHIP).input(ItemContent.ADAMANT_INGOT).input(ItemContent.ADAMANT_INGOT).result(ItemContent.HEISENBERG_COMPENSATOR).time(60).export(exporter, "compensator");
        AtomicForgeRecipeBuilder.build().input(ItemContent.UNHOLY_INTELLIGENCE).input(ItemContent.ADAMANT_INGOT).input(ItemContent.ADAMANT_INGOT).result(ItemContent.HEISENBERG_COMPENSATOR).time(60).export(exporter, "compensatoralt");
        offerMotorRecipe(exporter, ItemContent.OVERCHARGED_CRYSTAL, of(class_1802.field_27064), of(ItemContent.ADVANCED_BATTERY), of(BlockContent.SUPERCONDUCTOR.method_8389()), "overchargedcrystal");
        AssemblerRecipeBuilder.build().input(ItemContent.FLUX_GATE).input(TagContent.ELECTRUM_INGOTS).input(ItemContent.DUBIOS_CONTAINER).input(ItemContent.ENERGITE_INGOT).result(BlockContent.SUPERCONDUCTOR.method_8389(), 4).timeMultiplier(1.6f).export(exporter, "superconductor");
        AtomicForgeRecipeBuilder.build().input(ItemContent.HEISENBERG_COMPENSATOR).input(ItemContent.OVERCHARGED_CRYSTAL).input(ItemContent.OVERCHARGED_CRYSTAL).result(ItemContent.PROMETHEUM_INGOT).time(240).export(exporter, "prometheum");
        
        // ice in cooler
        CoolerRecipeBuilder.build().fluidInput(class_3612.field_15910).result(class_1802.field_8426, 3).export(exporter, "ice");
        
        // snow from steam in cooler
        CoolerRecipeBuilder.build().fluidInput(FluidContent.STILL_STEAM.get()).result(class_1802.field_8246, 3).export(exporter, "snow");
        
        // obsidian from lava
        CoolerRecipeBuilder.build().fluidInput(class_3612.field_15908).result(class_1802.field_8281, 2).export(exporter, "obsidian");
    }
    
    private void addCompactingRecipes(class_8790 exporter) {
        addCompactingRecipe(exporter, BlockContent.STEEL_BLOCK, ItemContent.STEEL_INGOT, of(TagContent.STEEL_INGOTS), of(getStorageBlockTag("steel")));
        addCompactingRecipe(exporter, BlockContent.ENERGITE_BLOCK, ItemContent.ENERGITE_INGOT, of(getIngotTag("energite")), of(getStorageBlockTag("energite")));
        addCompactingRecipe(exporter, BlockContent.NICKEL_BLOCK, ItemContent.NICKEL_INGOT, of(getIngotTag("nickel")), of(getStorageBlockTag("nickel")));
        addCompactingRecipe(exporter, BlockContent.BIOSTEEL_BLOCK, ItemContent.BIOSTEEL_INGOT, of(ItemContent.BIOSTEEL_INGOT), of(getStorageBlockTag("biosteel")));
        addCompactingRecipe(exporter, BlockContent.PLATINUM_BLOCK, ItemContent.PLATINUM_INGOT, of(getIngotTag("platinum")), of(getStorageBlockTag("platinum")));
        addCompactingRecipe(exporter, BlockContent.ADAMANT_BLOCK, ItemContent.ADAMANT_INGOT, of(getIngotTag("adamant")), of(getStorageBlockTag("adamant")));
        addCompactingRecipe(exporter, BlockContent.ELECTRUM_BLOCK, ItemContent.ELECTRUM_INGOT, of(getIngotTag("electrum")), of(getStorageBlockTag("electrum")));
        addCompactingRecipe(exporter, BlockContent.DURATIUM_BLOCK, ItemContent.DURATIUM_INGOT, of(getIngotTag("duratium")), of(getStorageBlockTag("duratium")));
        addCompactingRecipe(exporter, BlockContent.BIOMASS_BLOCK, ItemContent.BIOMASS, of(ItemContent.BIOMASS), of(getStorageBlockTag("biomass")));
        addCompactingRecipe(exporter, BlockContent.PLASTIC_BLOCK, ItemContent.PLASTIC_SHEET, of(TagContent.PLASTIC_PLATES), of(getStorageBlockTag("plastic")));
        addCompactingRecipe(exporter, BlockContent.FLUXITE_BLOCK, ItemContent.FLUXITE, of(ItemContent.FLUXITE), of(getStorageBlockTag("fluxite")));
        addCompactingRecipe(exporter, BlockContent.SILICON_BLOCK, ItemContent.SILICON, of(TagContent.SILICON), of(getStorageBlockTag("silicon")));
        addCompactingRecipe(exporter, BlockContent.RAW_NICKEL_BLOCK, ItemContent.RAW_NICKEL, of(TagContent.NICKEL_RAW_MATERIALS), of(getStorageBlockTag("raw_nickel")));
        addCompactingRecipe(exporter, BlockContent.RAW_PLATINUM_BLOCK, ItemContent.RAW_PLATINUM, of(TagContent.PLATINUM_RAW_MATERIALS), of(getStorageBlockTag("raw_platinum")));
        
    }

    // offerSmelting, offerBlasting, and offerMultipleOptions copied from RecipeProvider, and altered to force Oritech id onto recipes
    // I don't really like this, but any other way I found to get these recipes to have the oritech namespace in Neoforge wasn't working.
    public static void method_36233(class_8790 exporter, List<class_1935> inputs, class_7800 category, class_1935 output, float experience, int cookingTime, String group) {
      method_36232(exporter, class_1865.field_9042, class_3861::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
    }

    public static void method_36234(class_8790 exporter, List<class_1935> inputs, class_7800 category, class_1935 output, float experience, int cookingTime, String group) {
      method_36232(exporter, class_1865.field_17084, class_3859::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
    }

    public static <T extends class_1874> void method_36232(class_8790 exporter, class_1865<T> serializer, class_1874.class_3958<T> recipeFactory, List<class_1935> inputs, class_7800 category, class_1935 output, float experience, int cookingTime, String group, String suffix) {
        
        for (var itemConvertible : inputs) {
            class_2454.method_17801(class_1856.method_8091(itemConvertible), category, output, experience, cookingTime, serializer, recipeFactory).method_35917(group).method_10469(method_32807(itemConvertible), method_10426(itemConvertible)).method_17972(exporter, Oritech.id(method_33716(output) + suffix + "_" + method_33716(itemConvertible)));
        }
    }
    
    private void addOreChains(class_8790 exporter) {
        
        // basic smelting for nickel + platinum
        method_36233(exporter, List.of(ItemContent.RAW_NICKEL), class_7800.field_40642, ItemContent.NICKEL_INGOT, 1f, 200, "nickelsmelting");
        method_36233(exporter, List.of(ItemContent.RAW_PLATINUM), class_7800.field_40642, ItemContent.PLATINUM_INGOT, 1f, 200, "platinumsmelting");
        method_36234(exporter, List.of(ItemContent.RAW_NICKEL), class_7800.field_40642, ItemContent.NICKEL_INGOT, 1f, 100, "nickelblasting");
        method_36234(exporter, List.of(ItemContent.RAW_PLATINUM), class_7800.field_40642, ItemContent.PLATINUM_INGOT, 1f, 100, "platinumblasting");
        
        // iron chain
        MetalProcessingChainBuilder.build("iron")
          .ore(class_3489.field_28994)
          .rawOre(cItemTag("raw_materials/iron"), class_1802.field_33400)
          .rawOreByproduct(ItemContent.RAW_NICKEL)
          .ingot(cItemTag("ingots/iron"), class_1802.field_8620).nugget(cItemTag("nuggets/iron"), class_1802.field_8675)
          .clump(TagContent.IRON_CLUMPS, ItemContent.IRON_CLUMP).smallClump(ItemContent.SMALL_IRON_CLUMP).clumpByproduct(ItemContent.SMALL_NICKEL_CLUMP)
          .dust(ItemContent.IRON_DUST).smallDust(ItemContent.SMALL_IRON_DUST).dustByproduct(ItemContent.SMALL_NICKEL_DUST)
          .gem(ItemContent.IRON_GEM).gemCatalyst(ItemContent.FLUXITE)
          .vanillaProcessing()
          .skipCompacting()
          .export(exporter);
        // copper chain
        MetalProcessingChainBuilder.build("copper")
          .ore(class_3489.field_29199)
          .rawOre(cItemTag("raw_materials/copper"), class_1802.field_33401).rawOreByproduct(class_1802.field_33402)
          .ingot(cItemTag("ingots/copper"), class_1802.field_27022).nugget(TagContent.COPPER_NUGGETS, ItemContent.COPPER_NUGGET)
          .clump(TagContent.COPPER_CLUMPS, ItemContent.COPPER_CLUMP).smallClump(ItemContent.SMALL_COPPER_CLUMP).clumpByproduct(ItemContent.SMALL_GOLD_CLUMP)
          .dust(ItemContent.COPPER_DUST).smallDust(ItemContent.SMALL_COPPER_DUST).dustByproduct(ItemContent.SMALL_GOLD_DUST)
          .gem(ItemContent.COPPER_GEM).gemCatalyst(ItemContent.FLUXITE)
          .vanillaProcessing()
          .skipCompacting()
          .export(exporter);
        // gold chain
        MetalProcessingChainBuilder.build("gold")
          .ore(class_3489.field_23065)
          .rawOre(cItemTag("raw_materials/gold"), class_1802.field_33402).rawOreByproduct(class_1802.field_33401)
          .ingot(cItemTag("ingots/gold"), class_1802.field_8695).nugget(cItemTag("nuggets/gold"), class_1802.field_8397)
          .clump(TagContent.GOLD_CLUMPS, ItemContent.GOLD_CLUMP).smallClump(ItemContent.SMALL_GOLD_CLUMP).clumpByproduct(ItemContent.SMALL_COPPER_CLUMP)
          .dust(ItemContent.GOLD_DUST).smallDust(ItemContent.SMALL_GOLD_DUST).dustByproduct(ItemContent.SMALL_COPPER_DUST)
          .gem(ItemContent.GOLD_GEM).gemCatalyst(ItemContent.FLUXITE)
          .vanillaProcessing()
          .skipCompacting()
          .export(exporter);
        // nickel chain
        MetalProcessingChainBuilder.build("nickel")
          .ore(TagContent.NICKEL_ORES)
          .rawOre(TagContent.NICKEL_RAW_MATERIALS, ItemContent.RAW_NICKEL).rawOreByproduct(ItemContent.RAW_PLATINUM)
          .ingot(TagContent.NICKEL_INGOTS, ItemContent.NICKEL_INGOT).nugget(TagContent.NICKEL_NUGGETS, ItemContent.NICKEL_NUGGET)
          .clump(TagContent.NICKEL_CLUMPS, ItemContent.NICKEL_CLUMP).smallClump(ItemContent.SMALL_NICKEL_CLUMP).clumpByproduct(ItemContent.SMALL_PLATINUM_CLUMP)
          .dust(ItemContent.NICKEL_DUST).smallDust(ItemContent.SMALL_NICKEL_DUST).dustByproduct(ItemContent.SMALL_PLATINUM_DUST)
          .byproductAmount(2)
          .gem(ItemContent.NICKEL_GEM).gemCatalyst(ItemContent.FLUXITE)
          .vanillaProcessing()
          .export(exporter);
        // platinum chain
        MetalProcessingChainBuilder.build("platinum")
          .ore(TagContent.PLATINUM_ORES)
          .rawOre(TagContent.PLATINUM_RAW_MATERIALS, ItemContent.RAW_PLATINUM).rawOreByproduct(ItemContent.FLUXITE)
          .ingot(TagContent.PLATINUM_INGOTS, ItemContent.PLATINUM_INGOT).nugget(TagContent.PLATINUM_NUGGETS, ItemContent.PLATINUM_NUGGET)
          .clump(TagContent.PLATINUM_CLUMPS, ItemContent.PLATINUM_CLUMP).smallClump(ItemContent.SMALL_PLATINUM_CLUMP).clumpByproduct(ItemContent.FLUXITE)
          .dust(ItemContent.PLATINUM_DUST).smallDust(ItemContent.SMALL_PLATINUM_DUST).dustByproduct(ItemContent.FLUXITE)
          .byproductAmount(1)
          .gem(ItemContent.PLATINUM_GEM).gemCatalyst(ItemContent.FLUXITE)
          .timeMultiplier(1.5f)
          .vanillaProcessing()
          .export(exporter);
    }
    
    private void addAlloys(class_8790 exporter) {
        FoundryRecipeBuilder.build().input(TagContent.PLATINUM_INGOTS).input(cItemTag("ingots/netherite")).result(ItemContent.DURATIUM_INGOT).export(exporter, "duratium");
        FoundryRecipeBuilder.build().input(cItemTag("ingots/gold")).input(cItemTag("dusts/redstone")).result(ItemContent.ELECTRUM_INGOT).export(exporter, "electrum");
        FoundryRecipeBuilder.build().input(cItemTag("gems/diamond")).input(TagContent.NICKEL_INGOTS).result(ItemContent.ADAMANT_INGOT).export(exporter, "adamant");
        FoundryRecipeBuilder.build().input(TagContent.NICKEL_INGOTS).input(ItemContent.FLUXITE).result(ItemContent.ENERGITE_INGOT).export(exporter, "energite");
        FoundryRecipeBuilder.build().input(cItemTag("ingots/iron")).input(TagContent.COAL_DUSTS).result(ItemContent.STEEL_INGOT).timeMultiplier(0.3333f).export(exporter, "steel");
        AtomicForgeRecipeBuilder.build().input(TagContent.PLATINUM_INGOTS).input(ItemContent.REINFORCED_CARBON_SHEET).input(ItemContent.REINFORCED_CARBON_SHEET).result(ItemContent.DURATIUM_INGOT).export(exporter, "duratium");
    }
    
    private void addParticleCollisions(class_8790 exporter) {
        // diamond from coal dust
        ParticleCollisionRecipeBuilder.build().input(TagContent.COAL_DUSTS).input(TagContent.COAL_DUSTS).result(class_1802.field_8477).time(500).export(exporter, "diamond");
        // overcharged crystal from fluxite and energite dust
        ParticleCollisionRecipeBuilder.build().input(ItemContent.FLUXITE).input(ItemContent.ENERGITE_DUST).result(ItemContent.OVERCHARGED_CRYSTAL).time(5000).export(exporter, "overcharged_crystal");
        // platinum from gold dust
        ParticleCollisionRecipeBuilder.build().input(TagContent.GOLD_DUSTS).input(TagContent.GOLD_DUSTS).result(ItemContent.PLATINUM_DUST).time(500).export(exporter, "platinum_dust");
        // enderic compound from redstone and flesh
        ParticleCollisionRecipeBuilder.build().input(cItemTag("dusts/redstone")).input(class_1802.field_8511).result(ItemContent.ENDERIC_COMPOUND).time(500).export(exporter, "enderic_compound");
        // fluxite from electrum dust and redstone
        ParticleCollisionRecipeBuilder.build().input(TagContent.ELECTRUM_DUSTS).input(cItemTag("dusts/redstone")).result(ItemContent.FLUXITE).time(1000).export(exporter, "fluxite");
        // netherite scrap from adamant dust and netherrack
        ParticleCollisionRecipeBuilder.build().input(ItemContent.ADAMANT_DUST).input(class_1802.field_8328).result(class_1802.field_22021).time(2500).export(exporter, "netherite");
        // elytra from feather and saddle
        ParticleCollisionRecipeBuilder.build().input(cItemTag("feathers")).input(class_1802.field_8175).result(class_1802.field_8833).time(10000).export(exporter, "elytra");
        // nether star from overcharged crystal and netherite
        ParticleCollisionRecipeBuilder.build().input(ItemContent.OVERCHARGED_CRYSTAL).input(cItemTag("ingots/netherite")).result(class_1802.field_8137).time(15000).export(exporter, "nether_star");
        // echo shard from ender pearl and amethyst shard
        ParticleCollisionRecipeBuilder.build().input(cItemTag("ender_pearls")).input(cItemTag("gems/amethyst")).result(class_1802.field_38746).time(1000).export(exporter, "echo_shard");
        // heavy core from reinforced deepslate block and duration dust
        ParticleCollisionRecipeBuilder.build().input(class_1802.field_38418).input(ItemContent.DURATIUM_DUST).result(class_1802.field_49813).time(8000).export(exporter, "heavy_core");
    }
    
    private void addDusts(class_8790 exporter) {
        addDustRecipe(exporter, of(ItemContent.BIOSTEEL_INGOT), ItemContent.BIOSTEEL_DUST, ItemContent.BIOSTEEL_INGOT, "biosteel");
        addDustRecipe(exporter, of(ItemContent.DURATIUM_INGOT), ItemContent.DURATIUM_DUST, ItemContent.DURATIUM_INGOT, "duratium");
        addDustRecipe(exporter, of(TagContent.ELECTRUM_INGOTS), ItemContent.ELECTRUM_DUST, ItemContent.ELECTRUM_INGOT, "electrum");
        addDustRecipe(exporter, of(ItemContent.ADAMANT_INGOT), ItemContent.ADAMANT_DUST, ItemContent.ADAMANT_INGOT, "adamant");
        addDustRecipe(exporter, of(ItemContent.ENERGITE_INGOT), ItemContent.ENERGITE_DUST, ItemContent.ENERGITE_INGOT, "energite");
        addDustRecipe(exporter, of(TagContent.STEEL_INGOTS), ItemContent.STEEL_DUST, ItemContent.STEEL_INGOT, "steel");
        addDustRecipe(exporter, of(class_3489.field_17487), ItemContent.COAL_DUST, "coal");
        addDustRecipe(exporter, of(cItemTag("gems/quartz")), ItemContent.QUARTZ_DUST, "quartz");
        
        // raw ores without processing chains
        // coal
        GrinderRecipeBuilder.build().input(class_3489.field_29197).result(class_1802.field_8713, 3).export(exporter, "coalore");
        PulverizerRecipeBuilder.build().input(class_3489.field_29197).result(class_1802.field_8713, 2).export(exporter, "coalore");
        // redstone
        GrinderRecipeBuilder.build().input(class_3489.field_28996).result(class_1802.field_8725, 12).export(exporter, "redstoneore");
        PulverizerRecipeBuilder.build().input(class_3489.field_28996).result(class_1802.field_8725, 8).export(exporter, "redstoneore");
        // diamond
        GrinderRecipeBuilder.build().input(class_3489.field_28995).result(class_1802.field_8477, 2).export(exporter, "diamondore");
        PulverizerRecipeBuilder.build().input(class_3489.field_28995).result(class_1802.field_8477).export(exporter, "diamondore");
        // quartz
        GrinderRecipeBuilder.build().input(class_2246.field_10213).result(class_1802.field_8155, 3).export(exporter, "quartzore");
        PulverizerRecipeBuilder.build().input(class_2246.field_10213).result(class_1802.field_8155, 2).export(exporter, "quartzore");
        // glowstone
        GrinderRecipeBuilder.build().input(class_2246.field_10171).result(class_1802.field_8601, 4).export(exporter, "glowstoneore");
        PulverizerRecipeBuilder.build().input(class_2246.field_10171).result(class_1802.field_8601, 3).export(exporter, "glowstoneore");
        // lapis
        GrinderRecipeBuilder.build().input(class_3489.field_28997).result(class_1802.field_8759, 8).export(exporter, "lapisore");
        PulverizerRecipeBuilder.build().input(class_3489.field_28997).result(class_1802.field_8759, 6).export(exporter, "lapisore");
        // bone
        GrinderRecipeBuilder.build().input(class_1802.field_8606).result(class_1802.field_8324, 8).export(exporter, "bone");
        PulverizerRecipeBuilder.build().input(class_1802.field_8606).result(class_1802.field_8324, 6).export(exporter, "bone");
        // blaze powder
        GrinderRecipeBuilder.build().input(class_1802.field_8894).result(class_1802.field_8183, 4).export(exporter, "blaze");
        PulverizerRecipeBuilder.build().input(class_1802.field_8894).result(class_1802.field_8183, 3).export(exporter, "blaze");
        // wool
        GrinderRecipeBuilder.build().input(class_3489.field_15544).result(class_1802.field_8276, 4).export(exporter, "string");
        PulverizerRecipeBuilder.build().input(class_3489.field_15544).result(class_1802.field_8276, 3).export(exporter, "string");
        // ancient debris
        GrinderRecipeBuilder.build().input(class_1802.field_22019).result(class_1802.field_22021, 2).export(exporter, "netheritescrap");
    }
    
    private void addUraniumProcessing(class_8790 exporter) {
        // uranium order is:
        // raw ore -> dust/gem, dust -> gem, gem -> pellets
        
        // plutonium can be made via either ender laser on crystals (manually, usually low amount)
        // or via the particle accelerator
        
        // small uranium dust from redstone
        CentrifugeRecipeBuilder.build().input(cItemTag("dusts/redstone")).result(ItemContent.SMALL_URANIUM_DUST).export(exporter, "redstoneuran");
        
        // uranium ore blocks
        GrinderRecipeBuilder.build().input(BlockContent.DEEPSLATE_URANIUM_ORE).result(ItemContent.RAW_URANIUM, 3).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uraniumore");
        PulverizerRecipeBuilder.build().input(BlockContent.DEEPSLATE_URANIUM_ORE).result(ItemContent.RAW_URANIUM, 2).export(exporter, "uraniumore");
        
        // uranium crystal blocks
        GrinderRecipeBuilder.build().input(BlockContent.URANIUM_CRYSTAL).result(ItemContent.RAW_URANIUM, 5).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uraniumcrystal");
        PulverizerRecipeBuilder.build().input(BlockContent.URANIUM_CRYSTAL).result(ItemContent.RAW_URANIUM, 4).export(exporter, "uraniumcrystal");
        
        // raw uranium in grinder
        GrinderRecipeBuilder.build().input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_DUST, 2).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uranium");
        PulverizerRecipeBuilder.build().input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_DUST, 2).export(exporter, "uranium");
        
        // uranium gem from raw uranium / uranium dust in atomic forge
        AtomicForgeRecipeBuilder.build().input(TagContent.COPPER_DUSTS).input(TagContent.URANIUM_RAW_MATERIALS).input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_GEM).time(5).export(exporter, "urandust");
        AtomicForgeRecipeBuilder.build().input(TagContent.COPPER_DUSTS).input(TagContent.URANIUM_DUSTS).input(TagContent.URANIUM_DUSTS).result(ItemContent.URANIUM_GEM).time(5).export(exporter, "urandustgem");
        
        // uranium pellets in assembler
        AssemblerRecipeBuilder.build().input(ItemContent.URANIUM_GEM).input(ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input(TagContent.NICKEL_INGOTS).result(ItemContent.URANIUM_PELLET, 2).timeMultiplier(0.8f).export(exporter, "uranpelletbasic");
        AssemblerRecipeBuilder.build().input(ItemContent.URANIUM_GEM).input(ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input(ItemContent.ADAMANT_INGOT).result(ItemContent.URANIUM_PELLET, 3).timeMultiplier(0.8f).export(exporter, "uranpelletbetter");
        AssemblerRecipeBuilder.build().input(ItemContent.URANIUM_GEM).input(ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input(ItemContent.DURATIUM_INGOT).result(ItemContent.URANIUM_PELLET, 4).timeMultiplier(0.8f).export(exporter, "uranpelletult");
        
        // plutonium pellets in assembler
        AssemblerRecipeBuilder.build().input(ItemContent.PLUTONIUM_DUST).input(ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input(TagContent.NICKEL_INGOTS).result(ItemContent.PLUTONIUM_PELLET, 2).timeMultiplier(0.8f).export(exporter, "plutoniumpelletbasic");
        AssemblerRecipeBuilder.build().input(ItemContent.PLUTONIUM_DUST).input(ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input(ItemContent.ADAMANT_INGOT).result(ItemContent.PLUTONIUM_PELLET, 3).timeMultiplier(0.8f).export(exporter, "plutoniumpelletbetter");
        AssemblerRecipeBuilder.build().input(ItemContent.PLUTONIUM_DUST).input(ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input(ItemContent.DURATIUM_INGOT).result(ItemContent.PLUTONIUM_PELLET, 4).timeMultiplier(0.8f).export(exporter, "plutoniumpelletult");
        
        // dust compacting
        addCompactingRecipe(exporter, ItemContent.URANIUM_DUST, ItemContent.SMALL_URANIUM_DUST, of(ItemContent.SMALL_URANIUM_DUST), of(TagContent.URANIUM_DUSTS));
        addCompactingRecipe(exporter, ItemContent.PLUTONIUM_DUST, ItemContent.SMALL_PLUTONIUM_DUST, of(ItemContent.SMALL_PLUTONIUM_DUST), of(TagContent.PLUTONIUM_DUSTS));
        
        // uranium to plutonium
        ParticleCollisionRecipeBuilder.build().input(TagContent.URANIUM_DUSTS).input(ItemContent.FLUXITE).result(ItemContent.PLUTONIUM_DUST).time(2500).export(exporter, "plutonium");
        
        // pellet compacting
        addCompactingRecipe(exporter, ItemContent.URANIUM_PELLET, ItemContent.SMALL_URANIUM_PELLET, of(ItemContent.SMALL_URANIUM_PELLET), of(ItemContent.URANIUM_PELLET));
        addCompactingRecipe(exporter, ItemContent.PLUTONIUM_PELLET, ItemContent.SMALL_PLUTONIUM_PELLET, of(ItemContent.SMALL_PLUTONIUM_PELLET), of(ItemContent.PLUTONIUM_PELLET));
    }
    
    private void addAugmentRecipes(class_8790 exporter) {
        
        var SIMPLE_AUGMENT_STATION_ID = class_7923.field_41175.method_10221(BlockContent.SIMPLE_AUGMENT_STATION);
        var ADVANCED_AUGMENT_STATION_ID = class_7923.field_41175.method_10221(BlockContent.ADVANCED_AUGMENT_STATION);
        var ARCANE_AUGMENT_STATION_ID = class_7923.field_41175.method_10221(BlockContent.ARCANE_AUGMENT_STATION);
        
        AugmentRecipeBuilder.build()
          .researchCost(TagContent.MACHINE_PLATING, 64)
          .researchCost(TagContent.COAL_DUSTS, 32)
          .researchCost(ItemContent.BIOSTEEL_INGOT, 8)
          .applyCost(TagContent.STEEL_INGOTS, 8)
          .applyCost(cItemTag("ingots/iron"), 16)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(5).uiY(70).time(400).rfCost(10_000_000)
          .modifierDefinition(class_5134.field_23716, 6, class_1322.class_1323.field_6328)
          .export(exporter, "hpboost");
        
        AugmentRecipeBuilder.build()
          .researchCost(TagContent.CARBON_FIBRE, 32)
          .researchCost(ItemContent.BIOSTEEL_INGOT, 16)
          .researchCost(cItemTag("gems/diamond"), 4)
          .applyCost(TagContent.CARBON_FIBRE, 8)
          .applyCost(ItemContent.DURATIUM_INGOT, 4)
          .requirement(Oritech.id("augment/armor"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(80).uiY(70).time(800).rfCost(50_000_000)
          .modifierDefinition(class_5134.field_23716, 4, class_1322.class_1323.field_6328)
          .export(exporter, "hpboostmore");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENERGITE_INGOT, 64)
          .researchCost(ItemContent.REINFORCED_CARBON_SHEET, 32)
          .researchCost(class_1802.field_8137)
          .applyCost(ItemContent.DURATIUM_DUST, 64)
          .applyCost(cItemTag("storage_blocks/redstone"), 64)
          .requirement(Oritech.id("augment/ultimatearmor"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(165).uiY(70).time(1600).rfCost(200_000_000)
          .modifierDefinition(class_5134.field_23716, 10, class_1322.class_1323.field_6328)
          .export(exporter, "hpboostultra");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ADAMANT_INGOT, 64)
          .researchCost(class_1802.field_8137, 8)
          .researchCost(ItemContent.URANIUM_PELLET, 64)
          .researchCost(BlockContent.FLUXITE_BLOCK, 64)
          .applyCost(ItemContent.ADAMANT_INGOT, 32)
          .applyCost(ItemContent.OVERCHARGED_CRYSTAL)
          .applyCost(ItemContent.FLUXITE, 64)
          .requirement(Oritech.id("augment/hpboostultra"))
          .requirement(Oritech.id("augment/gravity"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(205).uiY(40).time(2400).rfCost(500_000_000)
          .modifierDefinition(class_5134.field_23716, 10, class_1322.class_1323.field_6328)
          .export(exporter, "hpboostultimate");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MOTOR, 32)
          .researchCost(ItemContent.BIOSTEEL_INGOT, 64)
          .researchCost(cItemTag("dusts/redstone"), 32)
          .applyCost(ItemContent.MOTOR, 16)
          .applyCost(cItemTag("ingots/iron"), 32)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(5).uiY(30).time(600).rfCost(30_000_000)
          .modifierDefinition(class_5134.field_23719, 0.25f, class_1322.class_1323.field_6330)
          .export(exporter, "speedboost");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENERGITE_INGOT, 64)
          .researchCost(ItemContent.ION_THRUSTER, 32)
          .researchCost(ItemContent.FLUX_GATE, 16)
          .applyCost(ItemContent.MAGNETIC_COIL, 32)
          .applyCost(ItemContent.OVERCHARGED_CRYSTAL)
          .applyCost(TagContent.ELECTRUM_DUSTS, 64)
          .requirement(Oritech.id("augment/speedboost"))
          .requirement(Oritech.id("augment/armor"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(55).uiY(50).time(1800).rfCost(350_000_000)
          .modifierDefinition(class_5134.field_23719, 0.25f, class_1322.class_1323.field_6328)
          .toggleable(true)
          .export(exporter, "superspeedboost");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MOTOR, 32)
          .researchCost(TagContent.STEEL_INGOTS, 64)
          .researchCost(cItemTag("storage_blocks/iron"), 16)
          .applyCost(ItemContent.MOTOR, 16)
          .applyCost(cItemTag("ingots/iron"), 64)
          .requirement(Oritech.id("augment/superspeedboost"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(80).uiY(50).time(800).rfCost(75_000_000)
          .modifierDefinition(class_5134.field_47761, 0.6f, class_1322.class_1323.field_6328)
          .toggleable()
          .export(exporter, "stepassist");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.SILICON_WAFER, 64)
          .researchCost(ItemContent.PROCESSING_UNIT, 32)
          .researchCost(cItemTag("storage_blocks/gold"), 16)
          .applyCost(TagContent.SILICON, 32)
          .applyCost(cItemTag("storage_blocks/redstone"), 32)
          .requirement(Oritech.id("augment/hpboost"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(30).uiY(90).time(400).rfCost(50_000_000)
          .modifierDefinition(class_5134.field_47760, -0.5f, class_1322.class_1323.field_6330)
          .toggleable()
          .export(exporter, "dwarf");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.RAW_BIOPOLYMER, 64)
          .researchCost(ItemContent.SMALL_URANIUM_DUST, 4)
          .researchCost(TagContent.BIOMATTER, 64)
          .applyCost(ItemContent.RAW_BIOPOLYMER, 32)
          .applyCost(cItemTag("ingots/iron"), 64)
          .requirement(Oritech.id("augment/dwarf"))
          .requirement(Oritech.id("augment/armor"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(55).uiY(90).time(1600).rfCost(300_000_000)
          .modifierDefinition(class_5134.field_47760, 1f, class_1322.class_1323.field_6330)
          .toggleable()
          .export(exporter, "giant");
        
        AugmentRecipeBuilder.build()
          .researchCost(TagContent.STEEL_INGOTS, 64)
          .researchCost(ItemContent.DURATIUM_INGOT, 8)
          .researchCost(cItemTag("gems/diamond"), 16)
          .applyCost(ItemContent.DURATIUM_INGOT, 4)
          .applyCost(cItemTag("ingots/iron"), 32)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(30).uiY(50).time(800).rfCost(80_000_000)
          .modifierDefinition(class_5134.field_23724, 4, class_1322.class_1323.field_6328)
          .export(exporter, "armor");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENERGITE_INGOT, 64)
          .researchCost(ItemContent.MAGNETIC_COIL, 32)
          .researchCost(cItemTag("gems/diamond"), 32)
          .applyCost(ItemContent.MAGNETIC_COIL, 16)
          .applyCost(ItemContent.OVERCHARGED_CRYSTAL)
          .applyCost(ItemContent.DURATIUM_INGOT, 8)
          .requirement(Oritech.id("augment/autofeeder"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(105).uiY(50).time(1600).rfCost(280_000_000)
          .modifierDefinition(class_5134.field_23724, 6, class_1322.class_1323.field_6328)
          .export(exporter, "betterarmor");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.FLUXITE, 64)
          .researchCost(ItemContent.HEISENBERG_COMPENSATOR, 32)
          .researchCost(ItemContent.PLUTONIUM_PELLET, 64)
          .researchCost(class_1802.field_8137, 8)
          .applyCost(BlockContent.FLUXITE_BLOCK, 32)
          .applyCost(ItemContent.OVERCHARGED_CRYSTAL)
          .applyCost(cItemTag("obsidians/normal"), 16)
          .requirement(Oritech.id("augment/betterarmor"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(155).uiY(50).time(2400).rfCost(500_000_000)
          .modifierDefinition(class_5134.field_23724, 8, class_1322.class_1323.field_6328)
          .export(exporter, "ultimatearmor");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MAGNETIC_COIL, 64)
          .researchCost(TagContent.ELECTRUM_INGOTS, 48)
          .researchCost(cItemTag("storage_blocks/redstone"), 32)
          .applyCost(ItemContent.MAGNETIC_COIL, 32)
          .applyCost(cItemTag("storage_blocks/iron"), 64)
          .requirement(Oritech.id("augment/blockreach"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(140).uiY(70).time(1600).rfCost(150_000_000)
          .modifierDefinition(class_5134.field_47759, 0.3f, class_1322.class_1323.field_6330)
          .export(exporter, "weaponreach");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MOTOR, 64)
          .researchCost(TagContent.STEEL_INGOTS, 48)
          .researchCost(cItemTag("storage_blocks/copper"), 32)
          .applyCost(ItemContent.MOTOR, 32)
          .applyCost(cItemTag("ingots/copper"), 64)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(115).uiY(90).time(900).rfCost(100_000_000)
          .modifierDefinition(class_5134.field_47758, 0.3f, class_1322.class_1323.field_6330)
          .export(exporter, "blockreach");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENDERIC_LENS, 64)
          .researchCost(cItemTag("ender_pearls"), 16)
          .researchCost(cItemTag("storage_blocks/diamond"), 16)
          .applyCost(ItemContent.ENDERIC_LENS, 32)
          .applyCost(cItemTag("obsidians/normal"), 64)
          .requirement(Oritech.id("augment/blockreach"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(140).uiY(90).time(800).rfCost(200_000_000)
          .modifierDefinition(class_5134.field_47758, 1, class_1322.class_1323.field_6331)
          .toggleable()
          .export(exporter, "farblockreach");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MAGNETIC_COIL, 48)
          .researchCost(class_1802.field_20402, 64)
          .researchCost(ItemContent.BASIC_BATTERY, 32)
          .applyCost(class_1802.field_20402, 16)
          .applyCost(cItemTag("ingots/iron"), 32)
          .requirement(Oritech.id("augment/attackdamage"))
          .requirement(Oritech.id("augment/speedboost"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(30).uiY(10).time(1200).rfCost(100_000_000)
          .modifierDefinition(class_5134.field_49076, 1, class_1322.class_1323.field_6331)
          .export(exporter, "miningspeed");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENERGITE_INGOT, 64)
          .researchCost(ItemContent.FLUX_GATE, 48)
          .researchCost(ItemContent.DURATIUM_INGOT, 64)
          .applyCost(ItemContent.ENERGITE_INGOT, 32)
          .applyCost(cItemTag("storage_blocks/redstone"), 64)
          .requirement(Oritech.id("augment/miningspeed"))
          .requirement(Oritech.id("augment/superspeedboost"))
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(80).uiY(10).time(2400).rfCost(450_000_000)
          .modifierDefinition(class_5134.field_49076, 1, class_1322.class_1323.field_6331)
          .toggleable()
          .export(exporter, "superminingspeed");
        
        AugmentRecipeBuilder.build()
          .researchCost(TagContent.STEEL_INGOTS, 64)
          .researchCost(cItemTag("gems/diamond"), 48)
          .researchCost(ItemContent.FLUXITE, 32)
          .applyCost(TagContent.STEEL_INGOTS, 16)
          .applyCost(ItemContent.DURATIUM_INGOT, 4)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(5).uiY(10).time(1600).rfCost(150_000_000)
          .modifierDefinition(class_5134.field_23721, 4, class_1322.class_1323.field_6328)
          .export(exporter, "attackdamage");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENDERIC_COMPOUND, 64)
          .researchCost(ItemContent.FLUXITE, 64)
          .researchCost(cItemTag("rods/blaze"), 32)
          .applyCost(ItemContent.ENDERIC_COMPOUND, 32)
          .applyCost(cItemTag("storage_blocks/gold"), 32)
          .requirement(Oritech.id("augment/hpboostultra"))
          .requirement(Oritech.id("augment/ultimatearmor"))
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(180).uiY(50).time(2800).rfCost(500_000_000)
          .modifierDefinition(class_5134.field_23721, 6, class_1322.class_1323.field_6328)
          .export(exporter, "superattackdamage");
        
        AugmentRecipeBuilder.build()
          .researchCost(TagContent.ELECTRUM_INGOTS, 64)
          .researchCost(cItemTag("storage_blocks/lapis"), 32)
          .researchCost(cItemTag("storage_blocks/gold"), 24)
          .applyCost(cItemTag("storage_blocks/lapis"), 24)
          .applyCost(cItemTag("storage_blocks/redstone"), 24)
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(55).uiY(30).time(1800).rfCost(200_000_000)
          .modifierDefinition(class_5134.field_23726, 5, class_1322.class_1323.field_6328)
          .export(exporter, "luck");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MAGNETIC_COIL, 64)
          .researchCost(ItemContent.FLUXITE, 48)
          .researchCost(class_1802.field_8614, 8)
          .applyCost(ItemContent.MAGNETIC_COIL, 32)
          .applyCost(cItemTag("storage_blocks/iron"), 16)
          .requirement(Oritech.id("augment/flight"))
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(180).uiY(10).time(2200).rfCost(400_000_000)
          .modifierDefinition(class_5134.field_49078, -0.5f, class_1322.class_1323.field_6330)
          .toggleable()
          .export(exporter, "gravity");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ION_THRUSTER, 64)
          .researchCost(class_1802.field_49098, 16)
          .researchCost(ItemContent.PROMETHEUM_INGOT, 16)
          .researchCost(ItemContent.PLUTONIUM_PELLET, 32)
          .applyCost(ItemContent.FLUX_GATE, 32)
          .applyCost(ItemContent.PLUTONIUM_PELLET, 8)
          .requirement(Oritech.id("augment/betterarmor"))
          .requirement(Oritech.id("augment/portal"))
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(155).uiY(30).time(3600).rfCost(500_000_000)
          .customAugmentDefinition(CustomAugmentsCollection.flight.id)
          .toggleable()
          .export(exporter, "flight");
        
        AugmentRecipeBuilder.build()
          .researchCost(class_1802.field_8449, 32)
          .researchCost(ItemContent.ENDERIC_LENS, 8)
          .researchCost(cItemTag("gems/diamond"), 8)
          .applyCost(ItemContent.ENDERIC_LENS, 32)
          .applyCost(class_1802.field_8801, 64)
          .requirement(Oritech.id("augment/orefinder"))
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(155).uiY(10).time(3200).rfCost(100_000_000)
          .effectDefinition(class_1294.field_5905, 0)
          .toggleable()
          .export(exporter, "cloak");
        
        AugmentRecipeBuilder.build()
          .researchCost(cItemTag("ender_pearls"), 16)
          .researchCost(cItemTag("obsidians/normal"), 48)
          .researchCost(ItemContent.UNHOLY_INTELLIGENCE)
          .researchCost(ItemContent.ADAMANT_INGOT, 32)
          .applyCost(cItemTag("ender_pearls"), 8)
          .applyCost(cItemTag("obsidians/crying"), 32)
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(130).uiY(30).time(3000).rfCost(250_000_000)
          .customAugmentDefinition(CustomAugmentsCollection.portal.id)
          .toggleable()
          .export(exporter, "portal");
        
        AugmentRecipeBuilder.build()
          .researchCost(cItemTag("ingots/gold"), 64)
          .researchCost(ItemContent.ENDERIC_LENS, 48)
          .researchCost(class_1802.field_8801, 64)
          .applyCost(ItemContent.ENDERIC_LENS, 4)
          .applyCost(class_1802.field_8801, 8)
          .applyCost(class_1802.field_8230, 8)
          .requiredStation(ADVANCED_AUGMENT_STATION_ID)
          .uiX(105).uiY(30).time(2400).rfCost(50_000_000)
          .effectDefinition(class_1294.field_5925, 0)
          .toggleable()
          .export(exporter, "nightvision");
        
        AugmentRecipeBuilder.build()
          .researchCost(class_1802.field_8434, 64)
          .researchCost(ItemContent.BIOSTEEL_INGOT, 48)
          .researchCost(class_1802.field_8207)
          .applyCost(ItemContent.BIOSTEEL_INGOT, 32)
          .applyCost(class_3489.field_15527)
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(5).uiY(90).time(800).rfCost(50_000_000)
          .effectDefinition(class_1294.field_5923, 0)
          .export(exporter, "waterbreath");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.PROCESSING_UNIT, 64)
          .researchCost(TagContent.BIOMATTER, 48)
          .researchCost(class_1802.field_8071, 64)
          .applyCost(TagContent.BIOMATTER, 32)
          .applyCost(BlockContent.ITEM_PIPE, 64)
          .applyCost(class_1802.field_8239, 8)
          .requirement(Oritech.id("augment/armor"))
          .requirement(Oritech.id("augment/hpboostmore"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(90).uiY(90).time(500).rfCost(30_000_000)
          .customAugmentDefinition(CustomAugmentsCollection.feeder.id)
          .toggleable()
          .export(exporter, "autofeeder");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.MAGNETIC_COIL, 64)
          .researchCost(ItemContent.ENERGITE_INGOT, 48)
          .researchCost(class_1802.field_23256, 2)
          .applyCost(ItemContent.MAGNETIC_COIL, 32)
          .applyCost(cItemTag("ingots/copper"), 64)
          .requirement(Oritech.id("augment/superminingspeed"))
          .requiredStation(SIMPLE_AUGMENT_STATION_ID)
          .uiX(105).uiY(10).time(2400).rfCost(400_000_000)
          .customAugmentDefinition(CustomAugmentsCollection.magnet.id)
          .toggleable()
          .export(exporter, "magnet");
        
        AugmentRecipeBuilder.build()
          .researchCost(ItemContent.ENDERIC_LENS, 32)
          .researchCost(class_1802.field_27070, 1)
          .researchCost(ItemContent.OVERCHARGED_CRYSTAL)
          .researchCost(ItemContent.PROMETHEUM_INGOT, 2)
          .researchCost(class_1802.field_28101, 1)
          .applyCost(ItemContent.ENDERIC_LENS, 32)
          .applyCost(class_1802.field_8530, 64)
          .requirement(Oritech.id("augment/nightvision"))
          .requirement(Oritech.id("augment/magnet"))
          .requiredStation(ARCANE_AUGMENT_STATION_ID)
          .uiX(130).uiY(10).time(3200).rfCost(200_000_000)
          .customAugmentDefinition(CustomAugmentsCollection.oreFinder.id)
          .toggleable()
          .export(exporter, "orefinder");
    }
    
    private void addReactorBlocks(class_8790 exporter) {
        
        // single rod
        offerRodRecipe(exporter, BlockContent.REACTOR_ROD.method_8389(), of(TagContent.PLASTIC_PLATES), of(ItemContent.ENERGITE_INGOT), "singlerod");
        // dual rod
        offerRodCombinationRecipe(exporter, BlockContent.REACTOR_DOUBLE_ROD.method_8389(), of(BlockContent.REACTOR_REFLECTOR), of(BlockContent.REACTOR_ROD), "doublerod");
        // quad rod
        offerRodCombinationRecipe(exporter, BlockContent.REACTOR_QUAD_ROD.method_8389(), of(BlockContent.REACTOR_REFLECTOR), of(BlockContent.REACTOR_DOUBLE_ROD), "quadrod");
        
        // reactor plating: steel and machine plating in crafting table / assembler
        offerMachinePlatingRecipe(exporter, BlockContent.REACTOR_WALL.method_8389(), of(TagContent.MACHINE_PLATING), of(TagContent.STEEL_INGOTS), of(TagContent.NICKEL_INGOTS), 4, "reactorplatingcrafting");
        AssemblerRecipeBuilder.build().input(TagContent.MACHINE_PLATING).input(TagContent.MACHINE_PLATING).input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).result(BlockContent.REACTOR_WALL.method_8389(), 3).timeMultiplier(0.8f).export(exporter, "reactorplatingalt");
        
        // neutron reflectors: expensive, needs duratium core, adamant frame and reactor walls
        offerMachinePlatingRecipe(exporter, BlockContent.REACTOR_REFLECTOR.method_8389(), of(BlockContent.REACTOR_WALL), of(ItemContent.ADAMANT_INGOT), of(ItemContent.DURATIUM_INGOT), 1, "reflector");
        
        // reactor controller: reactor wall, processing unit
        offerRodCombinationRecipe(exporter, BlockContent.REACTOR_CONTROLLER.method_8389(), of(BlockContent.REACTOR_WALL), of(ItemContent.PROCESSING_UNIT), "controller");
        
        // reactor energy port: reactor wall, storage unit, electrum
        offerParticleMotorRecipe(exporter, BlockContent.REACTOR_ENERGY_PORT.method_8389(), of(TagContent.ELECTRUM_INGOTS), of(BlockContent.ENERGY_PIPE), of(BlockContent.REACTOR_WALL), of(cItemTag("ingots/iron")), "energyport");
        
        // reactor redstone port: wall, processing unit, repeater, torch
        offerParticleMotorRecipe(exporter, BlockContent.REACTOR_REDSTONE_PORT.method_8389(), of(ItemContent.PROCESSING_UNIT), of(class_1802.field_8619), of(BlockContent.REACTOR_WALL), of(class_1802.field_8530), "redstoneport");
        
        // reactor fuel port: wall, hopper, motor, item pipe
        offerParticleMotorRecipe(exporter, BlockContent.REACTOR_FUEL_PORT.method_8389(), of(BlockContent.ITEM_PIPE), of(class_1802.field_8239), of(BlockContent.REACTOR_WALL), of(cItemTag("chests")), "fuelport");
        
        // reactor absorber port: wall, ice, motor, item pipe
        offerParticleMotorRecipe(exporter, BlockContent.REACTOR_ABSORBER_PORT.method_8389(), of(BlockContent.ITEM_PIPE), of(class_1802.field_8239), of(BlockContent.REACTOR_WALL), of(class_2246.field_10295), "absorberport");
        
        // reactor absorber : wall, steel, ice
        offerBatteryRecipe(exporter, BlockContent.REACTOR_CONDENSER.method_8389(), of(class_1802.field_8426), of(cItemTag("glass_blocks")), of(TagContent.STEEL_INGOTS), "condenser");
        
        // reactor vent: motor, carbon fibre
        offerStarRecipe(exporter, BlockContent.REACTOR_VENT.method_8389(), of(ItemContent.MOTOR), of(TagContent.CARBON_FIBRE), "reactorvent");
        
        // reactor heat pipe: electrum, gold
        offerStarRecipe(exporter, BlockContent.REACTOR_HEAT_PIPE.method_8389(), of(TagContent.ELECTRUM_INGOTS), of(cItemTag("ingots/gold")), "reactorheatpipe");
        
        // explosives
        offerMachinePlatingRecipe(exporter, BlockContent.LOW_YIELD_NUKE.method_8389(), of(ItemContent.DUBIOS_CONTAINER), of(ItemContent.URANIUM_PELLET), of(class_1802.field_8626), 1, "nuke");
        offerMachinePlatingRecipe(exporter, BlockContent.NUKE.method_8389(), of(ItemContent.HEISENBERG_COMPENSATOR), of(ItemContent.PLUTONIUM_PELLET), of(class_1802.field_8626), 1, "nukebetter");
    }
    
    private void addReactorFuels(class_8790 exporter) {
        ReactorGeneratorRecipeBuilder.build().input(ItemContent.SMALL_URANIUM_PELLET).time(400).export(exporter, "smallpellet");
        ReactorGeneratorRecipeBuilder.build().input(ItemContent.URANIUM_PELLET).time(4000).export(exporter, "pellet");
        ReactorGeneratorRecipeBuilder.build().input(ItemContent.SMALL_PLUTONIUM_PELLET).time(4000).export(exporter, "smallplutoniumpellet");
        ReactorGeneratorRecipeBuilder.build().input(ItemContent.PLUTONIUM_PELLET).time(40000).export(exporter, "plutoniumpellet");
    }
    
    private void addLaserTransformations(class_8790 exporter) {
        LaserRecipeBuilder.build().input(class_1802.field_27069).result(ItemContent.FLUXITE).export(exporter, "fluxite");
        LaserRecipeBuilder.build().input(BlockContent.URANIUM_CRYSTAL).result(ItemContent.PLUTONIUM_DUST).export(exporter, "plutoniumdust");
    }
    
    private void addCompactingRecipe(class_8790 exporter, class_1935 resBlock, class_1935 resItem, class_1856 itemIng, class_1856 blockIng) {
        class_2450
          .method_10448(class_7800.field_40642, resItem, 9)
          .method_10451(blockIng)
          .method_10442(method_32807(resBlock), method_10426(resBlock))
          .method_17972(exporter, Oritech.id(class_2446.method_36450(resBlock) + "blockinv"));
        class_2447
          .method_10437(class_7800.field_40642, resBlock)
          .method_10428('#', itemIng)
          .method_10439("###")
          .method_10439("###")
          .method_10439("###")
          .method_10429(method_32807(resItem), method_10426(resItem))
          .method_17972(exporter, Oritech.id(class_2446.method_36450(resBlock) + "block"));
    }
    
    // crafting shapes
    public void offerCableRecipe(class_8790 exporter, class_1799 output, class_1856 input, String suffix) {
        var item = output.method_7909();
        createCableRecipe(class_7800.field_40642, output.method_7909(), output.method_7947(), input).method_33530(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerInsulatedCableRecipe(class_8790 exporter, class_1799 output, class_1856 input, class_1856 insulation, String suffix) {
        var item = output.method_7909();
        createInsulatedCableRecipe(class_7800.field_40642, output.method_7909(), output.method_7947(), input, insulation).method_33530(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerRotatedCableRecipe(class_8790 exporter, class_1799 output, class_1856 input, class_1856 insulation, String suffix) {
        var item = output.method_7909();
        createRotatedCableRecipe(class_7800.field_40642, output.method_7909(), output.method_7947(), input, insulation).method_33530(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerFramedCableRecipe(class_8790 exporter, class_1799 output, class_1856 input, String suffix) {
        var item = output.method_7909();
        createFramedCableRecipe(class_7800.field_40642, output.method_7909(), output.method_7947(), input).method_33530(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/frame_" + suffix));
    }
    
    public void offerCableFromFrameRecipe(class_8790 exporter, class_1799 output, class_1856 frame, String suffix) {
        var item = output.method_7909();
        class_2450.method_10448(class_7800.field_40642, item, output.method_7947()).method_10451(frame).method_10442(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/unframe_" + suffix));
    }
    
    public void offerCableDuctRecipe(class_8790 exporter, class_1799 output, class_1856 input, String suffix) {
        var item = output.method_7909();
        createCableDuctRecipe(class_7800.field_40642, item, output.method_7947(), input).method_33530(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/duct_" + suffix));
    }
    
    public void offerCableFromDuctRecipe(class_8790 exporter, class_1799 output, class_1856 duct, String suffix) {
        var item = output.method_7909();
        class_2450.method_10448(class_7800.field_40642, item, output.method_7947()).method_10451(duct).method_10442(method_32807(item), method_10426(item)).method_17972(exporter, Oritech.id("crafting/unduct_" + suffix));
    }
    
    public class_5797 createCableRecipe(class_7800 category, class_1792 output, int count, class_1856 input) {
        return class_2447.method_10436(category, output, count).method_10428('#', input).method_10439("   ").method_10439("###");
    }
    
    public class_5797 createFramedCableRecipe(class_7800 category, class_1792 output, int count, class_1856 input) {
        return class_2447.method_10436(category, output, count).method_10428('c', input).method_10428('p', class_1856.method_8106(TagContent.MACHINE_PLATING)).method_10439("ccc").method_10439("cpc").method_10439("ccc");
    }
    
    public class_5797 createCableDuctRecipe(class_7800 category, class_1792 output, int count, class_1856 input) {
        return class_2447.method_10436(category, output, count).method_10428('c', input).method_10428('p', class_1856.method_8106(TagContent.MACHINE_PLATING)).method_10428('s', of(class_2246.field_10340)).method_10439("csc").method_10439("sps").method_10439("csc");
    }
    
    public void offerMotorRecipe(class_8790 exporter, class_1792 output, class_1856 shaft, class_1856 core, class_1856 wall, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', shaft).method_10428('c', core).method_10428('w', wall).method_10439(" s ").method_10439("wcw").method_10439("wcw");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("motor/" + suffix));
    }
    
    public void offerManualAlloyRecipe(class_8790 exporter, class_1792 output, class_1856 A, class_1856 B, String suffix) {
        offerManualAlloyRecipe(exporter, output, A, B, 1, suffix);
    }
    
    public void offerManualAlloyRecipe(class_8790 exporter, class_1792 output, class_1856 A, class_1856 B, int count, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('a', A).method_10428('b', B).method_10439("aa ").method_10439("bb ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/alloy/" + suffix));
    }
    
    public void offerGeneratorRecipe(class_8790 exporter, class_1792 output, class_1856 base, class_1856 sides, class_1856 core, class_1856 frame, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', sides).method_10428('c', core).method_10428('f', frame).method_10428('b', base)
                        .method_10439("fff")
                        .method_10439("fcf")
                        .method_10439("sbs");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerFurnaceRecipe(class_8790 exporter, class_1792 output, class_1856 bottom, class_1856 botSides, class_1856 middleSides, class_1856 core, class_1856 top, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', botSides).method_10428('c', core).method_10428('f', top).method_10428('b', bottom).method_10428('m', middleSides)
                        .method_10439("fff")
                        .method_10439("mcm")
                        .method_10439("sbs");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerAtomicForgeRecipe(class_8790 exporter, class_1792 output, class_1856 base, class_1856 middleSides, class_1856 core, class_1856 top, class_1856 frame, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', top).method_10428('c', core).method_10428('f', frame).method_10428('b', base).method_10428('m', middleSides)
                        .method_10439("fsf")
                        .method_10439("mcm")
                        .method_10439("bbb");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerBatteryRecipe(class_8790 exporter, class_1792 output, class_1856 inner, class_1856 sides, class_1856 top, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('t', top).method_10428('c', inner).method_10428('f', sides)
                        .method_10439(" t ")
                        .method_10439("fcf")
                        .method_10439("fcf");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerMachineFrameRecipe(class_8790 exporter, class_1792 output, class_1856 base, class_1856 alt, int count, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('s', base).method_10428('c', alt)
                        .method_10439(" s ")
                        .method_10439("csc")
                        .method_10439(" s ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerMachineCoreRecipe(class_8790 exporter, class_1792 output, class_1856 base, class_1856 alt, String suffix) {
        offerMachineCoreRecipe(exporter, output, 1, base, alt, suffix);
    }
    
    public void offerMachineCoreRecipe(class_8790 exporter, class_1792 output, int count, class_1856 base, class_1856 alt, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('s', base).method_10428('c', alt)
                        .method_10439("sss")
                        .method_10439("scs")
                        .method_10439("sss");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerManualFluidApplication(class_8790 exporter, class_1792 output, class_1856 fluid, class_1856 base, String suffix) {
        offerManualFluidApplication(exporter, output, 1, fluid, base, suffix);
    }
    
    public void offerManualFluidApplication(class_8790 exporter, class_1792 output, int count, class_1856 fluid, class_1856 base, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('f', fluid).method_10428('b', base)
                        .method_10439("bb ")
                        .method_10439("bf ")
                        .method_10439("   ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerBeadsRecipe(class_8790 exporter, class_1792 output, int count, class_1856 fluid, class_1856 base, class_1856 catalyst, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('f', fluid).method_10428('b', base).method_10428('c', catalyst)
                        .method_10439("bb ")
                        .method_10439("cf ")
                        .method_10439("   ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerDrillRecipe(class_8790 exporter, class_1792 output, class_1856 doubleBase, class_1856 motor, class_1856 outer, class_1856 head, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', doubleBase).method_10428('m', motor).method_10428('a', outer).method_10428('e', head)
                        .method_10439(" a ")
                        .method_10439("aea")
                        .method_10439("mss");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerWrenchRecipe(class_8790 exporter, class_1792 output, class_1856 A, class_1856 B, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('a', A).method_10428('b', B)
                        .method_10439(" a ")
                        .method_10439(" ba")
                        .method_10439("a  ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerChainsawRecipe(class_8790 exporter, class_1792 output, class_1856 core, class_1856 motor, class_1856 center, class_1856 head, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('s', core).method_10428('m', motor).method_10428('a', center).method_10428('e', head)
                        .method_10439("aa ")
                        .method_10439("ae ")
                        .method_10439("mss");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerAxeRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("pp ")
                        .method_10439("pc ")
                        .method_10439(" c ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerPickaxeRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("ppp")
                        .method_10439(" c ")
                        .method_10439(" c ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerHelmetRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("ppp")
                        .method_10439("pcp")
                        .method_10439("   ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerChestplateRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("p p")
                        .method_10439("ppp")
                        .method_10439("pcp");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerLegsRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("ppp")
                        .method_10439("pcp")
                        .method_10439("p p");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerFeetRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('p', plating).method_10428('c', core)
                        .method_10439("   ")
                        .method_10439("p p")
                        .method_10439("c c");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerRodRecipe(class_8790 exporter, class_1792 output, class_1856 cap, class_1856 rod, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('c', cap).method_10428('r', rod)
                        .method_10439(" c ")
                        .method_10439(" r ")
                        .method_10439(" r ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerRodCombinationRecipe(class_8790 exporter, class_1792 output, class_1856 cap, class_1856 rod, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('c', cap).method_10428('r', rod)
                        .method_10439("   ")
                        .method_10439("rcr")
                        .method_10439("   ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerStarRecipe(class_8790 exporter, class_1792 output, class_1856 inner, class_1856 outer, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('c', inner).method_10428('o', outer)
                        .method_10439(" o ")
                        .method_10439("oco")
                        .method_10439(" o ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerTankRecipe(class_8790 exporter, class_1792 output, class_1856 plating, class_1856 core, class_1856 sides, String suffix) {
        offerTankRecipe(exporter, output, 1, plating, core, sides, suffix);
    }
    
    public void offerTankRecipe(class_8790 exporter, class_1792 output, int count, class_1856 plating, class_1856 core, class_1856 sides, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, count).method_10428('p', plating).method_10428('s', sides).method_10428('c', core)
                        .method_10439("ppp")
                        .method_10439("scs")
                        .method_10439("ppp");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerTwoComponentRecipe(class_8790 exporter, class_1792 output, class_1856 A, class_1856 B, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('a', A).method_10428('b', B)
                        .method_10439("ab ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerLeverRecipe(class_8790 exporter, class_1792 output, class_1856 A, class_1856 B, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('a', A).method_10428('b', B)
                        .method_10439("a  ")
                        .method_10439("b  ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerParticleMotorRecipe(class_8790 exporter, class_1792 output, class_1856 rail, class_1856 top, class_1856 baseInner, class_1856 baseOuter, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40642, output, 1).method_10428('r', rail).method_10428('t', top).method_10428('i', baseInner).method_10428('o', baseOuter)
                        .method_10439(" t ")
                        .method_10439("rrr")
                        .method_10439("oio");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerMachinePlatingRecipe(class_8790 exporter, class_1792 output, class_1856 side, class_1856 edge, class_1856 core, int count, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40636, output, count).method_10428('a', side).method_10428('e', edge).method_10428('c', core)
                        .method_10439("eae")
                        .method_10439("aca")
                        .method_10439("eae");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerDoorRecipe(class_8790 exporter, class_1792 output, class_1856 A, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40636, output, 1).method_10428('a', A)
                        .method_10439("aa ")
                        .method_10439("aa ")
                        .method_10439("aa ");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/" + suffix));
    }
    
    public void offerSlabRecipe(class_8790 exporter, class_1792 output, class_1856 A, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40634, output, 6).method_10428('a', A)
                        .method_10439("aaa");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/slab/" + suffix));
    }
    
    public void offerStairsRecipe(class_8790 exporter, class_1792 output, class_1856 A, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40634, output, 4).method_10428('a', A)
                        .method_10439("a  ")
                        .method_10439("aa ")
                        .method_10439("aaa");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/stairs/" + suffix));
    }
    
    public void offerPressurePlateRecipe(class_8790 exporter, class_1792 output, class_1856 A, String suffix) {
        var builder = class_2447.method_10436(class_7800.field_40636, output, 1).method_10428('a', A)
                        .method_10439("aa");
        builder.method_10429(method_32807(output), method_10426(output)).method_17972(exporter, Oritech.id("crafting/pressureplate/" + suffix));
    }
}
