package rearth.oritech;

import com.mojang.authlib.GameProfile;
import org.apache.logging.log4j.util.TriConsumer;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;

import java.util.ServiceLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface OritechPlatform {
    
    OritechPlatform INSTANCE = ServiceLoader.load(OritechPlatform.class)
        .findFirst()
        .orElseThrow(() -> new IllegalStateException("Failed to load platform service."));

    // Network
    void sendBlockHandle(class_2586 blockEntity, class_8710 message);

    void sendPlayerHandle(class_8710 message, class_3222 player);

    void sendToServer(class_8710 message);

    <T extends class_8710> void registerToClient(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1937, class_5455> consumer);

    <T extends class_8710> void registerToServer(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1657, class_5455> consumer);
    
    // Attachment
    <T> void register(Attachment<T> attachment);

    <T> boolean hasAttachment(class_1309 entity, Attachment<T> attachment);

    <T> T getAttachmentValue(class_1309 entity, Attachment<T> attachment);

    <T> void setAttachment(class_1309 entity, Attachment<T> attachment, T value);

    <T> void removeAttachment(class_1309 entity, Attachment<T> attachment);

    // FakeMachinePlayer
    class_3222 create(class_3218 world, GameProfile profile, SimpleInventoryStorage inventory);
    
    void resetCapabilities(class_3218 world, class_2338 pos);
}
