/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechEMIRecipe
extends BasicEmiRecipe {
    private final Boolean isGenerator;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    private final OritechRecipe recipe;
    private final ScreenProvider.ArrowConfiguration indicatorConfig;

    public OritechEMIRecipe(RecipeHolder<OritechRecipe> entry, EmiRecipeCategory category, Class<? extends MachineBlockEntity> screenProviderSource, BlockState machineState) {
        super(category, entry.id(), 150, 69);
        this.recipe = (OritechRecipe)entry.value();
        this.recipe.getInputs().forEach(ingredient -> this.inputs.add(EmiIngredient.of((Ingredient)ingredient)));
        this.recipe.getResults().forEach(stack -> this.outputs.add(EmiStack.of((ItemStack)stack)));
        if (this.recipe.getFluidInput() != null && this.recipe.getFluidInput().amount() > 0L) {
            long inputAmount = Math.max(this.recipe.getFluidInput().amount(), 1L);
            if (this.recipe.getFluidInput().fluidContent().left().isPresent()) {
                EmiIngredient tagIng = EmiIngredient.of((TagKey)((TagKey)this.recipe.getFluidInput().fluidContent().left().get()), (long)inputAmount);
                this.inputs.add(tagIng);
            } else {
                this.inputs.add(EmiStack.of((Fluid)this.recipe.getFluidInput().getFluidStacks().getFirst().getFluid(), (long)inputAmount));
            }
        }
        this.recipe.getFluidOutputs().forEach(stack -> this.outputs.add(EmiStack.of((Fluid)stack.getFluid(), (long)stack.getAmount())));
        try {
            MachineBlockEntity screenProvider = screenProviderSource.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(new BlockPos(0, 0, 0), machineState);
            this.isGenerator = screenProvider instanceof UpgradableGeneratorBlockEntity;
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlotAssignments();
            this.indicatorConfig = screenProvider.getIndicatorConfiguration();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public OritechEMIRecipe(RecipeHolder<OritechRecipe> entry, EmiRecipeCategory category, Boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment slotOffsets) {
        super(category, entry.id(), 150, 69);
        this.isGenerator = isGenerator;
        this.slots = slots;
        this.slotOffsets = slotOffsets;
        this.indicatorConfig = new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 80, 35, 29, 16, true);
        this.recipe = (OritechRecipe)entry.value();
        this.recipe.getInputs().forEach(ingredient -> this.inputs.add(EmiIngredient.of((Ingredient)ingredient)));
        this.recipe.getResults().forEach(stack -> this.outputs.add(EmiStack.of((ItemStack)stack)));
        if (this.recipe.getFluidInput() != null && this.recipe.getFluidInput().amount() > 0L) {
            long inputAmount = Math.max(this.recipe.getFluidInput().amount(), 1L);
            if (this.recipe.getFluidInput().hasTag()) {
                this.inputs.add(new TagEmiIngredient(this.recipe.getFluidInput().getTag(), inputAmount));
            } else {
                this.inputs.add(EmiStack.of((Fluid)this.recipe.getFluidInput().getFluid(), (long)inputAmount));
            }
        }
        this.recipe.getFluidOutputs().forEach(stack -> this.outputs.add(EmiStack.of((Fluid)stack.getFluid(), (long)stack.getAmount())));
    }

    public void addWidgets(WidgetHolder widgets) {
        int offsetX = 23;
        int offsetY = 19;
        if (this.isGenerator.booleanValue()) {
            widgets.addTexture(EmiTexture.FULL_FLAME, this.indicatorConfig.x() - offsetX, this.indicatorConfig.y() - offsetY);
        } else {
            widgets.addFillingArrow(this.indicatorConfig.x() - offsetX, this.indicatorConfig.y() - offsetY, this.recipe.getTime() * 20 / 2);
        }
        List emiIngredients = this.inputs;
        for (int i = 0; i < emiIngredients.size(); ++i) {
            EmiIngredient input = (EmiIngredient)emiIngredients.get(i);
            if (input.isEmpty() && input.getAmount() <= 0L) continue;
            boolean isFluid = input.getEmiStacks().stream().anyMatch(stack -> stack.getKey() instanceof Fluid);
            if (isFluid && input.getAmount() > 0L) {
                widgets.addTank(input, 10, 6, 18, 50, (int)input.getAmount()).drawBack(false);
                widgets.addTexture(BasicMachineScreen.GUI_COMPONENTS, 10, 6, 18, 50, 48, 0, 14, 50, 98, 96);
                continue;
            }
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            int usedY = Math.max(2, pos.y() - offsetY);
            widgets.addSlot(input, pos.x() - offsetX, usedY);
        }
        List emiStacks = this.outputs;
        int tankCount = 0;
        int tankStartX = this.recipe.getFluidOutputs().size() > 1 ? 80 : 120;
        for (int i = 0; i < emiStacks.size(); ++i) {
            EmiStack result = (EmiStack)emiStacks.get(i);
            if (result.isEmpty() || result.getAmount() <= 0L) continue;
            boolean isFluid = result.getEmiStacks().stream().anyMatch(stack -> stack.getKey() instanceof Fluid);
            if (isFluid && result.getAmount() > 0L) {
                widgets.addTank((EmiIngredient)result, tankStartX + tankCount * 20, 6, 18, 50, (int)result.getAmount()).drawBack(false).recipeContext((EmiRecipe)this);
                widgets.addTexture(BasicMachineScreen.GUI_COMPONENTS, tankStartX + tankCount * 20, 6, 18, 50, 48, 0, 14, 50, 98, 96);
                ++tankCount;
                continue;
            }
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            int usedY = Math.max(1, pos.y() - offsetY);
            widgets.addSlot((EmiIngredient)result, pos.x() - offsetX, usedY).recipeContext((EmiRecipe)this);
        }
        String duration = String.format("%.0f", Float.valueOf((float)this.recipe.getTime() / 20.0f));
        widgets.addText((Component)Component.translatable((String)"emi.title.oritech.cookingtime", (Object[])new Object[]{duration, this.recipe.getTime()}), (int)((double)this.getDisplayWidth() * 0.33), (int)((double)this.getDisplayHeight() * 0.88), 0xFFFFFF, true);
    }
}

