/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.registry.EmiRecipeFiller;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.compat.emi.OritechEMIRecipe;

public class EmiTransferHandler<S extends BasicMachineScreenHandler>
implements StandardRecipeHandler<S> {
    private final ResourceLocation categoryId;

    public EmiTransferHandler(ResourceLocation categoryId) {
        this.categoryId = categoryId;
    }

    public List<Slot> getInputSources(S handler) {
        return ((BasicMachineScreenHandler)((Object)handler)).slots;
    }

    public List<Slot> getCraftingSlots(S handler) {
        BlockEntity blockEntity = ((BasicMachineScreenHandler)((Object)handler)).blockEntity;
        if (!(blockEntity instanceof MachineBlockEntity)) {
            return List.of();
        }
        MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
        ArrayList<Slot> res = new ArrayList<Slot>();
        for (int i = ((BasicMachineScreenHandler)((Object)handler)).getMachineInvStartSlot(ItemStack.EMPTY); i < ((BasicMachineScreenHandler)((Object)handler)).getMachineInvStartSlot(ItemStack.EMPTY) + machine.getSlotAssignments().inputCount(); ++i) {
            res.add((Slot)((BasicMachineScreenHandler)((Object)handler)).slots.get(i));
        }
        return res;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        if (!(recipe instanceof OritechEMIRecipe)) {
            return false;
        }
        OritechEMIRecipe oriRecipe = (OritechEMIRecipe)recipe;
        ResourceLocation id = oriRecipe.getCategory().getId();
        return id.equals((Object)this.categoryId);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<S> context) {
        List stacks = EmiRecipeFiller.getStacks((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (int)context.getAmount());
        if (stacks != null) {
            return EmiRecipeFiller.clientFill((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (List)stacks, (EmiCraftContext.Destination)context.getDestination());
        }
        return false;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<S> context) {
        BasicMachineScreenHandler handler = (BasicMachineScreenHandler)context.getScreenHandler();
        if (this.getCraftingSlots((S)((Object)handler)).stream().anyMatch(slot -> slot.hasItem() && !slot.getItem().isEmpty())) {
            return false;
        }
        return super.canCraft(recipe, context);
    }
}

