/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.pipes.item.ItemFilterBlock;
import rearth.oritech.client.ui.ItemFilterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;

public class ItemFilterBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
ExtendedMenuProvider {
    public final FilterBlockInventory inventory = new FilterBlockInventory(1, this::setChanged);
    @SyncField(value={SyncType.GUI_OPEN})
    protected FilterData filterSettings = new FilterData(false, true, false, new HashMap<Integer, ItemStack>());

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putBoolean("whitelist", this.filterSettings.useWhitelist);
        nbt.putBoolean("useNbt", this.filterSettings.useNbt);
        nbt.putBoolean("useComponents", this.filterSettings.useComponents);
        Collection<ItemStack> filterItems = this.filterSettings.items.values();
        ListTag itemsNbtList = new ListTag();
        for (ItemStack item : filterItems) {
            Tag data = item.save(registryLookup);
            itemsNbtList.add((Object)data);
        }
        nbt.put("filterItems", (Tag)itemsNbtList);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        boolean whiteList = nbt.getBoolean("whitelist");
        boolean useNbt = nbt.getBoolean("useNbt");
        boolean useComponents = nbt.getBoolean("useComponents");
        ListTag list = nbt.getList("filterItems", 10);
        HashMap<Integer, ItemStack> itemsList = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            Tag data = list.get(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)data).orElse(ItemStack.EMPTY);
            itemsList.put(i, stack);
        }
        FilterData data = new FilterData(useNbt, whiteList, useComponents, itemsList);
        this.setFilterSettings(data);
    }

    public ItemFilterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ITEM_FILTER_ENTITY, pos, state);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new ItemFilterScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.inventory.isEmpty()) {
            return;
        }
        Direction targetDirection = (Direction)this.getBlockState().getValue((Property)ItemFilterBlock.TARGET_DIR);
        BlockPos targetPos = pos.offset(targetDirection.getNormal());
        ItemApi.InventoryStorage targetInv = ItemApi.BLOCK.find(world, targetPos, targetDirection);
        if (targetInv == null) {
            return;
        }
        ItemStack firstItem = (ItemStack)this.inventory.heldStacks.getFirst();
        int inserted = targetInv.insert(firstItem.copy(), false);
        firstItem.shrink(inserted);
    }

    public FilterData getFilterSettings() {
        return this.filterSettings;
    }

    public void setFilterSettings(FilterData filterSettings) {
        this.filterSettings = filterSettings;
        this.setChanged();
    }

    @Override
    public void setChanged() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public static void handleClientUpdate(ItemFilterPayload message, Player player, RegistryAccess registryAccess) {
        Optional blockEntity = player.level().getBlockEntity(message.pos(), BlockEntitiesContent.ITEM_FILTER_ENTITY);
        if (blockEntity.isPresent()) {
            ((ItemFilterBlockEntity)blockEntity.get()).setFilterSettings(message.data);
        }
    }

    public class FilterBlockInventory
    extends SimpleInventoryStorage {
        public FilterBlockInventory(int size, Runnable onUpdate) {
            super(size, onUpdate);
        }

        public boolean canInsert(ItemStack stack) {
            boolean checkNbt = ItemFilterBlockEntity.this.filterSettings.useNbt;
            boolean checkComponents = ItemFilterBlockEntity.this.filterSettings.useComponents;
            boolean matchesFilterItems = false;
            for (ItemStack filterItem : ItemFilterBlockEntity.this.filterSettings.items.values()) {
                boolean componentsMatch;
                boolean matchesType = stack.getItem().equals(filterItem.getItem());
                if (!matchesType) continue;
                if (checkComponents && !(componentsMatch = stack.getComponentsPatch().equals((Object)filterItem.getComponentsPatch()))) break;
                if (checkNbt) {
                    if (stack.has(DataComponents.CUSTOM_DATA) && filterItem.has(DataComponents.CUSTOM_DATA)) {
                        boolean match = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).equals(filterItem.get(DataComponents.CUSTOM_DATA));
                        if (!match) continue;
                        matchesFilterItems = true;
                        break;
                    }
                    if (stack.has(DataComponents.CUSTOM_DATA) || filterItem.has(DataComponents.CUSTOM_DATA)) continue;
                    matchesFilterItems = true;
                    break;
                }
                matchesFilterItems = true;
                break;
            }
            if (ItemFilterBlockEntity.this.filterSettings.useWhitelist) {
                return matchesFilterItems;
            }
            return !matchesFilterItems;
        }

        @Override
        public int insertToSlot(ItemStack addedStack, int slot, boolean simulate) {
            if (!this.canInsert(addedStack)) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    }

    public record FilterData(boolean useNbt, boolean useWhitelist, boolean useComponents, Map<Integer, ItemStack> items) {
        public static StreamCodec<RegistryFriendlyByteBuf, FilterData> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, FilterData::useNbt, (StreamCodec)ByteBufCodecs.BOOL, FilterData::useWhitelist, (StreamCodec)ByteBufCodecs.BOOL, FilterData::useComponents, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ItemStack.STREAM_CODEC), FilterData::items, FilterData::new);
    }

    public record ItemFilterPayload(BlockPos pos, FilterData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ItemFilterPayload> FILTER_PACKET_ID = new CustomPacketPayload.Type(Oritech.id("filter"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemFilterPayload> PACKET_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ItemFilterPayload::pos, FilterData.PACKET_CODEC, ItemFilterPayload::data, ItemFilterPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return FILTER_PACKET_ID;
        }
    }
}

