/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.block.entity.accelerator.BlackHoleBlockEntity;
import rearth.oritech.init.BlockContent;

public class BlackHoleRenderer
implements BlockEntityRenderer<BlackHoleBlockEntity> {
    public void render(BlackHoleBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        long time = entity.getLevel().getGameTime();
        if (entity.currentlyPullingFrom != null && entity.currentlyPulling != null && entity.pullingStartedAt + entity.pullTime > time && !entity.currentlyPulling.isAir()) {
            float progress = (float)Math.pow(((float)time + tickDelta - (float)entity.pullingStartedAt) / (float)entity.pullTime, 1.3f);
            Vec3 startPos = Vec3.atLowerCornerOf((Vec3i)entity.currentlyPullingFrom);
            Vec3 endPos = entity.getBlockPos().getCenter();
            BlockState renderedBlock = entity.currentlyPulling;
            Vec3 offset = endPos.subtract(startPos).scale((double)(1.0f - progress));
            float rotationY = progress * (float)entity.pullTime * 3.0f;
            matrices.pushPose();
            matrices.translate(0.5, 0.5, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees(rotationY));
            matrices.translate(-offset.x, -offset.y, -offset.z);
            matrices.mulPose(Axis.XP.rotationDegrees(rotationY));
            matrices.mulPose(Axis.ZP.rotationDegrees(rotationY));
            matrices.scale(1.0f - progress, 1.0f - progress, 1.0f - progress);
            Minecraft.getInstance().getBlockRenderer().renderBatched(renderedBlock, entity.getBlockPos(), (BlockAndTintGetter)entity.getLevel(), matrices, vertexConsumers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)renderedBlock)), true, entity.getLevel().random);
            matrices.popPose();
        }
        BlackHoleRenderer.renderBlackHole(entity, tickDelta, matrices, vertexConsumers);
    }

    private static void renderBlackHole(BlackHoleBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
        float time = (float)entity.getLevel().getGameTime() + tickDelta;
        float rotationY = time * 1.2f % 360.0f;
        double rotationX = Math.sin((double)time * 0.02) * 5.0;
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YP.rotationDegrees(rotationY));
        matrices.mulPose(Axis.XP.rotationDegrees((float)rotationX));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        Minecraft.getInstance().getBlockRenderer().renderBatched(BlockContent.BLACK_HOLE_INNER.defaultBlockState(), entity.getBlockPos(), (BlockAndTintGetter)entity.getLevel(), matrices, vertexConsumers.getBuffer(RenderType.endGateway()), true, entity.getLevel().random);
        Minecraft.getInstance().getBlockRenderer().renderBatched(BlockContent.BLACK_HOLE_MIDDLE.defaultBlockState(), entity.getBlockPos(), (BlockAndTintGetter)entity.getLevel(), matrices, vertexConsumers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)BlockContent.BLACK_HOLE_MIDDLE.defaultBlockState())), true, entity.getLevel().random);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        rotationY = time * 1.1f % 360.0f;
        matrices.mulPose(Axis.YP.rotationDegrees(rotationY));
        matrices.mulPose(Axis.XP.rotationDegrees((float)rotationX));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        Minecraft.getInstance().getBlockRenderer().renderBatched(BlockContent.BLACK_HOLE_OUTER.defaultBlockState(), entity.getBlockPos(), (BlockAndTintGetter)entity.getLevel(), matrices, vertexConsumers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)BlockContent.BLACK_HOLE_OUTER.defaultBlockState())), true, entity.getLevel().random);
        matrices.popPose();
    }
}

