/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;

public abstract class NetworkedBlockEntity
extends BlockEntity
implements BlockEntityTicker<NetworkedBlockEntity> {
    private boolean networkDirty = false;
    private boolean needsInitialUpdate = false;

    public NetworkedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (world.isClientSide) {
            this.clientTick(world, pos, state, blockEntity);
            return;
        }
        this.serverTick(world, pos, state, blockEntity);
        if ((world.getGameTime() + this.worldPosition.asLong()) % (long)this.getSparseUpdateInterval() == 0L) {
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
        if (this.networkDirty) {
            this.networkDirty = false;
            this.sendUpdate(SyncType.TICK);
        }
        if (this.needsInitialUpdate) {
            this.needsInitialUpdate = false;
            this.sendUpdate(SyncType.INITIAL);
        }
    }

    public abstract void serverTick(Level var1, BlockPos var2, BlockState var3, NetworkedBlockEntity var4);

    public void clientTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
    }

    public int getSparseUpdateInterval() {
        return 100;
    }

    public void setChanged() {
        this.markDirty(false);
    }

    public void markDirty(boolean updateComparator) {
        if (this.level != null) {
            NetworkedBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
            if (updateComparator) {
                this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
            }
        }
        this.networkDirty = true;
    }

    public void preNetworkUpdate(SyncType type) {
    }

    public void sendUpdate(SyncType type) {
        if (this.level == null) {
            Oritech.LOGGER.warn("unable to send update: World is null.");
            return;
        }
        this.preNetworkUpdate(type);
        RegistryFriendlyByteBuf usedBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.level.registryAccess());
        int fieldCount = NetworkManager.encodeFields((Object)this, type, (ByteBuf)usedBuf, this.level);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(this.worldPosition, BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()), type, usedBuf.array()));
    }

    public void sendUpdate(SyncType type, ServerPlayer player) {
        if (this.level == null) {
            Oritech.LOGGER.warn("unable to send player update: World is null.");
            return;
        }
        this.preNetworkUpdate(type);
        RegistryFriendlyByteBuf usedBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.level.registryAccess());
        int fieldCount = NetworkManager.encodeFields((Object)this, type, (ByteBuf)usedBuf, this.level);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendPlayerHandle(new NetworkManager.MessagePayload(this.worldPosition, BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()), type, usedBuf.array()), player);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        this.needsInitialUpdate = true;
        return super.getUpdateTag(registryLookup);
    }
}

