/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.energy;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.api.energy.BlockEnergyApi;
import rearth.oritech.api.energy.ItemEnergyApi;

public class EnergyApi {
    public static BlockEnergyApi BLOCK;
    public static ItemEnergyApi ITEM;

    public static Long transfer(EnergyStorage from, EnergyStorage to, long amount, boolean simulate) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(extracted, simulate);
        if ((extracted = from.extract(inserted, simulate)) > 0L && !simulate) {
            from.update();
            to.update();
        }
        return extracted;
    }

    public static abstract class EnergyStorage {
        public boolean supportsInsertion() {
            return true;
        }

        public abstract long insert(long var1, boolean var3);

        public boolean supportsExtraction() {
            return true;
        }

        public abstract long extract(long var1, boolean var3);

        public abstract void setAmount(long var1);

        public abstract long getAmount();

        public abstract long getCapacity();

        public abstract void update();
    }

    public static interface ItemProvider {
        public EnergyStorage getEnergyStorage(ItemStack var1);
    }

    public static interface BlockProvider {
        public EnergyStorage getEnergyStorage(Direction var1);
    }
}

