/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.processing.RefineryBlockEntity;
import rearth.oritech.client.renderers.MachineModel;
import rearth.oritech.client.renderers.SmallTankRenderer;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class RefineryRenderer<T extends RefineryBlockEntity>
extends GeoBlockRenderer<T> {
    private final Map<T, VisualTankHeights> tankHeights = new HashMap<T, VisualTankHeights>();

    public RefineryRenderer(String model) {
        super(new MachineModel(model));
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return AABB.ofSize((Vec3)blockEntity.getBlockPos().getCenter(), (double)6.0, (double)6.0, (double)6.0);
    }

    public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.translucent());
        VisualTankHeights lastHeight = this.tankHeights.computeIfAbsent(animatable, key -> new VisualTankHeights());
        FluidStack inputStack = ((RefineryBlockEntity)animatable).ownStorage.getInStack();
        if (!inputStack.isEmpty()) {
            RefineryRenderer.renderFluidCube(new Vec3(-1.5, 0.1875, 0.6875), new Vector3f(0.75f, 1.5625f, 1.75f), inputStack, ((RefineryBlockEntity)animatable).ownStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, -1, lastHeight);
        }
        int moduleCount = ((RefineryBlockEntity)animatable).getModuleCount();
        for (int i = 0; i <= moduleCount; ++i) {
            FluidApi.SingleSlotStorage outputStorage = ((RefineryBlockEntity)animatable).getOutputStorage(i);
            FluidStack renderedStack = outputStorage.getStack();
            if (renderedStack.isEmpty()) continue;
            Tuple<Vec3, Vector3f> tankPosition = RefineryRenderer.getTankCoordinates(i);
            RefineryRenderer.renderFluidCube((Vec3)tankPosition.getA(), (Vector3f)tankPosition.getB(), renderedStack, outputStorage.getCapacity(), consumer, poseStack, packedLight, packedOverlay, i, lastHeight);
        }
    }

    private static Tuple<Vec3, Vector3f> getTankCoordinates(int i) {
        return switch (i) {
            case 0 -> new Tuple((Object)new Vec3(-1.375, 0.5625, -0.3125), (Object)new Vector3f(0.4375f, 0.9375f, 0.625f));
            case 1 -> new Tuple((Object)new Vec3(-1.3125, 2.0, -0.3125), (Object)new Vector3f(1.625f, 0.875f, 1.625f));
            case 2 -> new Tuple((Object)new Vec3(-1.3125, 3.0, -0.3125), (Object)new Vector3f(1.625f, 0.875f, 1.625f));
            default -> throw new IllegalStateException("Tried to access invalid tank for renderer: " + i);
        };
    }

    private static void renderFluidCube(Vec3 min, Vector3f size, FluidStack drawnStack, Long tankCapacity, VertexConsumer consumer, PoseStack matrices, int light, int overlay, int index, VisualTankHeights lastHeight) {
        Fluid fluid = drawnStack.getFluid();
        float fill = (float)drawnStack.getAmount() / (float)tankCapacity.longValue();
        float lastFill = index == -1 ? lastHeight.input : lastHeight.outputs[index];
        float newFill = Mth.lerp((float)0.003f, (float)lastFill, (float)fill);
        if (index == -1) {
            lastHeight.input = newFill;
        } else {
            lastHeight.outputs[index] = newFill;
        }
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((Fluid)fluid);
        int spriteColor = FluidStackHooks.getColor((Fluid)fluid);
        Color parsedColor = Color.ofArgb((int)spriteColor);
        Color opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1.0f);
        spriteColor = opaqueColor.argb();
        matrices.pushPose();
        matrices.translate(min.x + (double)0.01f, min.y + (double)0.01f, min.z + (double)0.01f);
        matrices.scale(size.x - 0.02f, size.y * newFill - 0.03f, size.z - 0.02f);
        PoseStack.Pose entry = matrices.last();
        Matrix4f modelMatrix = entry.pose();
        for (Direction direction : Direction.values()) {
            if (direction.equals((Object)Direction.DOWN)) continue;
            SmallTankRenderer.drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        matrices.popPose();
    }

    private static class VisualTankHeights {
        private float input = 0.0f;
        private final float[] outputs = new float[3];

        private VisualTankHeights() {
        }
    }
}

