/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockFrameInteractionEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.FakeMachinePlayer;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class DestroyerBlockEntity
extends MultiblockFrameInteractionEntity {
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasCropFilterAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasSilkTouchAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public int yieldAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.SPARSE_TICK})
    public int range = 1;
    @SyncField
    public BlockPos quarryTarget = BlockPos.ZERO;
    public float targetHardness = 1.0f;
    private ServerPlayer destroyerPlayerEntity = null;

    public DestroyerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.DESTROYER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.range = 1;
        this.yieldAddons = 0;
        this.hasSilkTouchAddon = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().getBlock().equals(BlockContent.CROP_FILTER_ADDON)) {
            this.hasCropFilterAddon = true;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.QUARRY_ADDON)) {
            this.range *= 8;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            ++this.yieldAddons;
        }
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) {
            this.hasSilkTouchAddon = true;
        }
        super.getAdditionalStatFromAddon(addonBlock);
        this.yieldAddons = Math.min(this.yieldAddons, 3);
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasCropFilterAddon = false;
        this.hasSilkTouchAddon = false;
        this.range = 1;
        this.yieldAddons = 0;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("cropAddon", this.hasCropFilterAddon);
        nbt.putBoolean("silkTouchAddon", this.hasSilkTouchAddon);
        nbt.putInt("range", this.range);
        nbt.putInt("yield", this.yieldAddons);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasCropFilterAddon = nbt.getBoolean("cropAddon");
        this.hasSilkTouchAddon = nbt.getBoolean("silkTouchAddon");
        this.range = nbt.getInt("range");
        this.yieldAddons = nbt.getInt("yield");
    }

    @Override
    protected boolean hasWorkAvailable(BlockPos toolPosition) {
        if (this.range > 1) {
            return this.hasQuarryTarget(toolPosition);
        }
        BlockPos targetPosition = toolPosition.below();
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPosition);
        if (this.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(targetState)) {
            return false;
        }
        return !targetState.getBlock().equals(Blocks.AIR);
    }

    private Player getDestroyerPlayerEntity() {
        Level level;
        if (this.destroyerPlayerEntity == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.destroyerPlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_destroyer"), this.inventory);
        }
        return this.destroyerPlayerEntity;
    }

    private boolean hasQuarryTarget(BlockPos toolPosition) {
        return this.getQuarryDownwardState(toolPosition) != null;
    }

    public static boolean isImmatureCrop(BlockState targetState) {
        CropBlock cropBlock;
        Block targetBlock = targetState.getBlock();
        return targetBlock instanceof CropBlock && !(cropBlock = (CropBlock)targetBlock).isMaxAge(targetState) || targetBlock instanceof NetherWartBlock && (Integer)targetState.getValue((Property)NetherWartBlock.AGE) < 3 || targetBlock instanceof CocoaBlock && (Integer)targetState.getValue((Property)CocoaBlock.AGE) < 2;
    }

    private Tuple<BlockPos, BlockState> getQuarryDownwardState(BlockPos toolPosition) {
        for (int i = 1; i <= this.range; ++i) {
            BlockPos checkPos = toolPosition.below(i);
            BlockState targetState = this.level.getBlockState(checkPos);
            if (targetState.isAir() || targetState.getFluidState().isSource()) continue;
            this.quarryTarget = checkPos;
            this.targetHardness = Math.clamp(targetState.getDestroySpeed((BlockGetter)this.level, checkPos), 0.0f, 100.0f);
            return new Tuple((Object)checkPos, (Object)targetState);
        }
        this.quarryTarget = BlockPos.ZERO;
        return null;
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
        float targetHardness;
        BlockPos targetPosition = processed.below();
        BlockState targetState = Objects.requireNonNull(this.level).getBlockState(targetPosition);
        if (this.range > 1) {
            if (this.quarryTarget != BlockPos.ZERO) {
                targetPosition = this.quarryTarget;
                targetState = this.level.getBlockState(targetPosition);
            } else {
                Tuple<BlockPos, BlockState> data = this.getQuarryDownwardState(processed);
                if (data == null) {
                    return;
                }
                targetPosition = (BlockPos)data.getA();
                targetState = (BlockState)data.getB();
            }
        }
        if (targetState.getFluidState().isSource()) {
            this.level.setBlockAndUpdate(targetPosition, Blocks.AIR.defaultBlockState());
        }
        if ((targetHardness = targetState.getBlock().defaultDestroyTime()) < 0.0f) {
            return;
        }
        if (this.range == 1 && this.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(targetState)) {
            return;
        }
        if (!targetState.getBlock().equals(Blocks.AIR)) {
            BlockEntity targetEntity = this.level.getBlockEntity(targetPosition);
            List dropped = this.hasSilkTouchAddon ? DestroyerBlockEntity.getSilkTouchDrops(targetState, (ServerLevel)this.level, targetPosition, targetEntity, this.getDestroyerPlayerEntity()) : (this.yieldAddons > 0 ? DestroyerBlockEntity.getLootDrops(targetState, (ServerLevel)this.level, targetPosition, targetEntity, this.yieldAddons, this.getDestroyerPlayerEntity()) : Block.getDrops((BlockState)targetState, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPosition, (BlockEntity)targetEntity));
            if (dropped.isEmpty()) {
                dropped = Block.getDrops((BlockState)targetState, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPosition, (BlockEntity)targetEntity, null, (ItemStack)new ItemStack((ItemLike)Items.SHEARS));
            }
            for (ItemStack stack : dropped) {
                if (this.inventory.insert(stack, true) == stack.getCount()) continue;
                return;
            }
            for (ItemStack stack : dropped) {
                this.inventory.insert(stack, false);
            }
            targetState.getBlock().playerWillDestroy(this.level, targetPosition, targetState, this.getDestroyerPlayerEntity());
            this.level.playSound(null, targetPosition, targetState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.destroyBlock(targetPosition, false);
            super.finishBlockWork(processed);
        }
    }

    public static List<ItemStack> getLootDrops(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity, int yieldAddons, @Nullable Player entity) {
        ItemStack sampleTool = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
        sampleTool.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        Holder.Reference fortuneEntry = (Holder.Reference)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.FORTUNE).get();
        sampleTool.enchant((Holder)fortuneEntry, Math.min(yieldAddons, 3));
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)sampleTool).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
        if (entity != null) {
            builder.withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        }
        return state.getDrops(builder);
    }

    public static List<ItemStack> getSilkTouchDrops(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Player entity) {
        ItemStack sampleTool = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
        sampleTool.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        Holder.Reference silkTouchEntry = (Holder.Reference)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).get();
        sampleTool.enchant((Holder)silkTouchEntry, 1);
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)sampleTool).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
        if (entity != null) {
            builder.withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        }
        return state.getDrops(builder);
    }

    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);
        if (moving) {
            return;
        }
        if (this.range > 1 && this.quarryTarget != BlockPos.ZERO) {
            ParticleContent.QUARRY_DESTROY_EFFECT.spawn(this.level, Vec3.atCenterOf((Vec3i)this.quarryTarget).add(0.0, 0.5, 0.0), (Object)3);
        } else if (this.hasWorkAvailable(this.getCurrentTarget())) {
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)this.getCurrentTarget().below()), (Object)4);
        }
    }

    @Override
    public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        if (this.range == 1 && this.yieldAddons == 0 && !this.hasSilkTouchAddon) {
            return super.getExtraExtensionLabels();
        }
        if (this.hasSilkTouchAddon) {
            return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.range}), (Object)Component.translatable((String)"tooltip.oritech.block_destroyer.addon_range")), new Tuple((Object)Component.translatable((String)"enchantment.minecraft.silk_touch"), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_silk_touch")));
        }
        return List.of(new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.range}), (Object)Component.translatable((String)"tooltip.oritech.block_destroyer.addon_range")), new Tuple((Object)Component.translatable((String)"title.oritech.machine.addon_fortune", (Object[])new Object[]{this.yieldAddons}), (Object)Component.translatable((String)"tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public BlockState getMachineHead() {
        return BlockContent.BLOCK_DESTROYER_HEAD.defaultBlockState();
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 20, true), new ScreenProvider.GuiSlot(1, 117, 38, true), new ScreenProvider.GuiSlot(2, 135, 20, true), new ScreenProvider.GuiSlot(3, 135, 38, true));
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -2), new Vec3i(-1, 0, -1), new Vec3i(0, 0, 2), new Vec3i(-1, 0, 1));
    }

    @Override
    public float getMoveTime() {
        float quarrySpeedBonus = this.range > 1 ? 0.15f : 1.0f;
        return (float)Oritech.CONFIG.destroyerConfig.moveDuration() * this.getSpeedMultiplier() * quarrySpeedBonus;
    }

    @Override
    public float getWorkTime() {
        float quarrySpeedBonus = this.range > 1 ? 0.15f : 1.0f;
        return (float)((double)((float)Oritech.CONFIG.destroyerConfig.workDuration() * this.getSpeedMultiplier()) * Math.pow(this.targetHardness, 0.5) * (double)quarrySpeedBonus);
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.destroyerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        int quarryCostBonus = this.range > 1 ? 4 : 1;
        return Oritech.CONFIG.destroyerConfig.workEnergyUsage() * quarryCostBonus;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, -1), new Vec3i(0, 0, 1));
    }
}

