/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.fluid.BlockFluidApi;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;

public class FluidApi {
    public static BlockFluidApi BLOCK;
    public static ItemFluidApi ITEM;

    public static long transferFirst(FluidStorage from, FluidStorage to, long max, boolean simulate) {
        if (from.getContent().isEmpty()) {
            return 0L;
        }
        FluidStack kind = from.getContent().getFirst();
        if (kind.isEmpty()) {
            return 0L;
        }
        return FluidApi.transfer(from, to, kind.copyWithAmount(max), simulate);
    }

    public static long transferLast(FluidStorage from, FluidStorage to, long max, boolean simulate) {
        if (from.getContent().isEmpty()) {
            return 0L;
        }
        FluidStack kind = from.getContent().getLast();
        if (kind.isEmpty()) {
            return 0L;
        }
        return FluidApi.transfer(from, to, kind.copyWithAmount(max), simulate);
    }

    public static long transferLastIncludingInputs(FluidStorage from, FluidStorage to, long max, boolean simulate) {
        DelegatingFluidStorage delegatingFluidStorage;
        if (from.getContent().isEmpty()) {
            return 0L;
        }
        if (from instanceof DelegatingFluidStorage && (delegatingFluidStorage = (DelegatingFluidStorage)from).getBackend() != null) {
            from = delegatingFluidStorage.getBackend();
        }
        if (from instanceof MultiSlotStorage) {
            MultiSlotStorage multiSlotStorage = (MultiSlotStorage)from;
            for (int i = multiSlotStorage.getSlotCount() - 1; i >= 0; --i) {
                long moved;
                FluidStorage storage = multiSlotStorage.getStorageForSlot(i);
                if (storage.getContent().isEmpty() || (moved = FluidApi.transferLast(storage, to, max, simulate)) <= 0L) continue;
                return moved;
            }
        }
        return FluidApi.transferLast(from, to, max, simulate);
    }

    public static long transfer(FluidStorage from, FluidStorage to, FluidStack toMove, boolean simulate) {
        long maxExtraction = from.extract(toMove, true);
        long potentialInsertion = to.insert(toMove.copyWithAmount(maxExtraction), true);
        long extracted = from.extract(toMove.copyWithAmount(potentialInsertion), simulate);
        long inserted = to.insert(toMove.copyWithAmount(extracted), simulate);
        if (extracted > 0L && !simulate) {
            from.update();
            to.update();
        }
        return extracted;
    }

    public static abstract class FluidStorage {
        public boolean supportsInsertion() {
            return true;
        }

        public abstract long insert(FluidStack var1, boolean var2);

        public boolean supportsExtraction() {
            return true;
        }

        public abstract long extract(FluidStack var1, boolean var2);

        public abstract List<FluidStack> getContent();

        public abstract void update();

        public abstract long getCapacity();
    }

    public static abstract class MultiSlotStorage
    extends FluidStorage {
        public abstract FluidStorage getStorageForDirection(Direction var1);

        public abstract void setStack(int var1, FluidStack var2);

        public abstract FluidStack getStack(int var1);

        public abstract int getSlotCount();

        public abstract FluidStorage getStorageForSlot(int var1);
    }

    public static abstract class SingleSlotStorage
    extends FluidStorage {
        public abstract void setStack(FluidStack var1);

        public abstract FluidStack getStack();
    }

    public static interface BlockProvider {
        public FluidStorage getFluidStorage(@Nullable Direction var1);
    }

    public static interface ItemProvider {
        public SingleSlotStorage getFluidStorage(ItemStack var1);
    }
}

