/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.world.features.uranium;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5542;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;
import org.joml.Vector2d;
import rearth.oritech.init.world.features.uranium.UraniumPatchFeatureConfig;
import rearth.oritech.util.Geometry;

public class UraniumPatchFeature
extends class_3031<UraniumPatchFeatureConfig> {
    public UraniumPatchFeature(Codec<UraniumPatchFeatureConfig> configCodec) {
        super(configCodec);
    }

    private static boolean isAirOrWater(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382);
    }

    public boolean method_13151(class_5821<UraniumPatchFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        if (world.method_8608()) {
            return false;
        }
        class_2338 testPos = new class_2338((class_2382)origin.method_10087(3));
        if (UraniumPatchFeature.isAirOrWater(world.method_8320(testPos))) {
            this.placeStructure(testPos, context);
        }
        return false;
    }

    private void placeStructure(class_2338 pos, class_5821<UraniumPatchFeatureConfig> context) {
        class_5819 random = context.method_33654();
        UraniumPatchFeatureConfig config = (UraniumPatchFeatureConfig)context.method_33656();
        class_2680 state = ((class_2248)class_7923.field_41175.method_10223(config.blockId())).method_9564();
        class_2248 crystalBlock = (class_2248)class_7923.field_41175.method_10223(config.crystalId());
        class_5281 world = context.method_33652();
        int range = config.number();
        class_2338 closestWall = pos;
        for (class_2338 candidate : class_2338.method_25996((class_2338)pos, (int)range, (int)range, (int)range)) {
            class_2680 candidateState = world.method_8320(candidate);
            if (UraniumPatchFeature.isAirOrWater(candidateState)) continue;
            closestWall = candidate;
            break;
        }
        if (closestWall.equals((Object)pos)) {
            return;
        }
        class_2338 closestWallDir = closestWall.method_10059((class_2382)pos);
        class_2382 forward = this.getBiggestDirection((class_2382)closestWallDir);
        class_2350 facing = class_2350.method_50026((int)forward.method_10263(), (int)forward.method_10264(), (int)forward.method_10260());
        if (facing == null) {
            return;
        }
        class_2382 right = Geometry.getRight(facing);
        class_2382 up = Geometry.getUp(facing);
        int veinCount = 3;
        for (int i = 0; i < veinCount; ++i) {
            Vector2d randomDir = new Vector2d((double)(random.method_43057() * 2.0f - 1.0f), (double)(random.method_43057() * 2.0f - 1.0f)).normalize();
            int veinLength = random.method_39332(5, 9);
            for (int j = 0; j < veinLength; ++j) {
                class_2338 test = pos.method_10081(right.method_35862((int)(randomDir.x * (double)j))).method_10081(up.method_35862((int)(randomDir.y * (double)j)));
                class_2338 test2 = pos.method_10081(right.method_35862((int)(randomDir.x * (double)j + 0.5))).method_10081(up.method_35862((int)(randomDir.y * (double)j + 0.5)));
                for (int k = 0; k < 5; ++k) {
                    class_2338 projected = test.method_10081(forward.method_35862(k));
                    class_2338 projected2 = test2.method_10081(forward.method_35862(k));
                    class_2680 testState = world.method_8320(projected);
                    class_2680 testState2 = world.method_8320(projected2);
                    if (this.isValidReplacementBloc(testState)) {
                        this.createCrystals(projected, world, random, crystalBlock);
                        world.method_30092(projected, state, 2, 0);
                        break;
                    }
                    if (!this.isValidReplacementBloc(testState2)) continue;
                    world.method_30092(projected2, state, 2, 0);
                    break;
                }
                randomDir = randomDir.add((double)random.method_43057() * 0.2, (double)random.method_43057() * 0.2).normalize();
            }
        }
    }

    private boolean isValidReplacementBloc(class_2680 state) {
        return state.method_26164(class_3481.field_28993) || state.method_26164(class_3481.field_28992);
    }

    private void createCrystals(class_2338 pos, class_5281 world, class_5819 random, class_2248 crystal) {
        for (class_2338 neighborPos : this.getNeighbors(pos)) {
            class_2680 neighborState = world.method_8320(neighborPos);
            boolean isValid = neighborState.method_26215() || neighborState.method_27852(class_2246.field_10382);
            if (!isValid || (double)random.method_43057() < 0.7) continue;
            boolean waterLogged = neighborState.method_27852(class_2246.field_10382);
            class_2350 facing = Geometry.fromVector((class_2382)neighborPos.method_10059((class_2382)pos));
            if (facing == null) continue;
            class_2680 targetState = (class_2680)((class_2680)crystal.method_9564().method_11657((class_2769)class_5542.field_27086, (Comparable)Boolean.valueOf(waterLogged))).method_11657((class_2769)class_5542.field_27087, (Comparable)facing);
            world.method_30092(neighborPos, targetState, 2, 0);
        }
    }

    private List<class_2338> getNeighbors(class_2338 pos) {
        return List.of(pos.method_10074(), pos.method_10084(), pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067());
    }

    private class_2382 getBiggestDirection(class_2382 source) {
        int x = Math.abs(source.method_10263());
        int y = Math.abs(source.method_10264());
        int z = Math.abs(source.method_10260());
        if (x > y && x > z) {
            return new class_2382(Math.clamp((long)source.method_10263(), -1, 1), 0, 0);
        }
        if (y > x && y > z) {
            return new class_2382(0, Math.clamp((long)source.method_10264(), -1, 1), 0);
        }
        return new class_2382(0, 0, Math.clamp((long)source.method_10260(), -1, 1));
    }
}

