/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.RedstoneAddonScreenHandler;
import rearth.oritech.util.ScreenProvider;

public class RedstoneAddonScreen
extends BaseOwoHandledScreen<FlowLayout, RedstoneAddonScreenHandler> {
    private LabelComponent activeLabel;
    private FlowLayout overlay;
    private final List<ButtonComponent> buttons = new ArrayList<ButtonComponent>();
    private FlowLayout buttonContainer;
    private LabelComponent descriptionLabel;

    public RedstoneAddonScreen(RedstoneAddonScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)100));
        this.overlay.padding(Insets.of((int)3)).margins(Insets.of((int)3));
        FlowLayout spacer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)71));
        rootComponent.child((Component)this.overlay.surface(BasicMachineScreen.ORITECH_PANEL));
        rootComponent.child((Component)spacer);
        RedstoneAddonBlockEntity.RedstoneMode[] modes = RedstoneAddonBlockEntity.RedstoneMode.values();
        RedstoneAddonBlockEntity.RedstoneMode activeMode = ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.activeMode;
        this.activeLabel = Components.label((class_2561)this.getModeText(activeMode));
        this.activeLabel.horizontalTextAlignment(HorizontalAlignment.CENTER);
        this.activeLabel.sizing(Sizing.fill(), Sizing.content((int)2));
        this.activeLabel.positioning(Positioning.absolute((int)0, (int)15));
        this.overlay.child((Component)this.activeLabel);
        this.descriptionLabel = Components.label((class_2561)this.getDescriptionText(activeMode));
        this.descriptionLabel.horizontalTextAlignment(HorizontalAlignment.CENTER);
        this.descriptionLabel.sizing(Sizing.fill(), Sizing.content((int)2));
        this.descriptionLabel.positioning(Positioning.absolute((int)0, (int)25));
        this.overlay.child((Component)this.descriptionLabel);
        DiscreteSliderComponent slider = Components.discreteSlider((Sizing)Sizing.fixed((int)160), (double)0.0, (double)(modes.length - 1));
        slider.positioning(Positioning.absolute((int)8, (int)63));
        slider.snap(true);
        slider.onChanged().subscribe(this::onModeSelected);
        slider.setFromDiscreteValue((double)activeMode.ordinal());
        this.overlay.child((Component)slider);
        this.addTitle(this.overlay);
    }

    private void onModeSelected(double mode) {
        RedstoneAddonBlockEntity.RedstoneMode[] modes = RedstoneAddonBlockEntity.RedstoneMode.values();
        if (mode >= (double)modes.length) {
            return;
        }
        RedstoneAddonBlockEntity.RedstoneMode activeMode = modes[(int)mode];
        this.activeLabel.text(this.getModeText(activeMode));
        this.descriptionLabel.text(this.getDescriptionText(activeMode));
        ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.activeMode = activeMode;
        if (activeMode.equals((Object)RedstoneAddonBlockEntity.RedstoneMode.OUTPUT_SLOT)) {
            this.overlay.verticalSizing().animate(250, Easing.CUBIC, (Animatable)Sizing.fixed((int)194)).forwards();
            this.addSlotSelector();
        } else if (((Sizing)this.overlay.verticalSizing().get()).value != 100) {
            this.overlay.verticalSizing().animate(270, Easing.CUBIC, (Animatable)Sizing.fixed((int)100)).forwards();
            this.removeSlotSelector();
        }
        this.triggerServerUpdate();
    }

    private void addSlotSelector() {
        this.removeSlotSelector();
        RedstoneAddonBlockEntity.RedstoneControllable controller = ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.getCachedController();
        if (!(controller instanceof ScreenProvider)) {
            return;
        }
        ScreenProvider screenProvider = (ScreenProvider)((Object)controller);
        List<ScreenProvider.GuiSlot> slots = screenProvider.getGuiSlots();
        this.buttonContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)100));
        this.buttonContainer.positioning(Positioning.absolute((int)0, (int)100));
        this.buttonContainer.child((Component)Components.box((Sizing)Sizing.fixed((int)160), (Sizing)Sizing.fixed((int)1)).color(new Color(0.1f, 0.1f, 0.1f)).positioning(Positioning.absolute((int)8, (int)0)));
        LabelComponent title = Components.label((class_2561)class_2561.method_43471((String)"title.oritech.redstone_addon"));
        title.horizontalTextAlignment(HorizontalAlignment.CENTER);
        this.buttonContainer.child((Component)title.positioning(Positioning.relative((int)50, (int)5)));
        for (ScreenProvider.GuiSlot slot : slots) {
            ButtonComponent button = Components.button((class_2561)class_2561.method_43470((String)" "), elem -> this.setActiveSlot(slot.index()));
            this.buttons.add(button);
            this.buttonContainer.child(BasicMachineScreen.getItemFrame(slot.x(), slot.y()));
            this.buttonContainer.child(button.sizing(Sizing.fixed((int)10)).positioning(Positioning.absolute((int)(slot.x() + 3), (int)(slot.y() + 3))));
        }
        this.setActiveSlot(((RedstoneAddonScreenHandler)this.field_2797).blockEntity.monitoredSlot);
        if (screenProvider.showProgress()) {
            ScreenProvider.ArrowConfiguration arrowConfig = screenProvider.getIndicatorConfiguration();
            TextureComponent arrow = Components.texture((class_2960)arrowConfig.full(), (int)0, (int)0, (int)arrowConfig.width(), (int)arrowConfig.height(), (int)arrowConfig.width(), (int)arrowConfig.height());
            this.buttonContainer.child((Component)arrow.positioning(Positioning.absolute((int)arrowConfig.x(), (int)arrowConfig.y())));
        }
        this.overlay.child((Component)this.buttonContainer);
    }

    private void removeSlotSelector() {
        if (this.buttonContainer == null) {
            return;
        }
        this.overlay.removeChild((Component)this.buttonContainer);
        this.buttons.clear();
        this.buttonContainer = null;
    }

    private void setActiveSlot(int slot) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonComponent button = this.buttons.get(i);
            button.field_22763 = i != slot;
        }
        ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.monitoredSlot = slot;
        this.triggerServerUpdate();
    }

    private class_2561 getModeText(RedstoneAddonBlockEntity.RedstoneMode mode) {
        return class_2561.method_43471((String)("title.oritech.redstone_" + mode.toString().toLowerCase(Locale.ROOT))).method_27695(new class_124[]{class_124.field_1067, class_124.field_1063});
    }

    private class_2561 getDescriptionText(RedstoneAddonBlockEntity.RedstoneMode mode) {
        return class_2561.method_43471((String)("tooltip.oritech.redstone_" + mode.toString().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1074);
    }

    private void addTitle(FlowLayout overlay) {
        class_5250 blockTitle = ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.method_11010().method_26204().method_9518();
        LabelComponent label = Components.label((class_2561)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((Component)label.positioning(Positioning.relative((int)50, (int)2)));
    }

    private void triggerServerUpdate() {
        ((RedstoneAddonScreenHandler)this.field_2797).blockEntity.sendDataToServer();
    }
}

