/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.ui.AugmentSelectionScreen;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.util.SizedIngredient;
import rearth.oritech.util.TooltipHelper;

public class PlayerModifierScreen
extends BaseOwoHandledScreen<FlowLayout, PlayerModifierScreenHandler> {
    private static DraggableScrollContainer<FlowLayout> main;
    private static FlowLayout root;
    private static final HashMap<String, class_3545<Vector2i, Vector2i>> dependencyLines;
    private static final HashMap<class_2960, AugmentUiState> shownAugments;
    private final Set<BoxComponent> highlighters = new HashSet<BoxComponent>();
    private final List<LabelComponent> researchLabels = new ArrayList<LabelComponent>();
    private final int backgroundAugmentFrameSize = 32;
    private final int augmentIconSize = 24;
    private static final float panelHeight = 0.8f;
    private TextureComponent energyIndicator;

    public PlayerModifierScreen(PlayerModifierScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, CustomFlowRootContainer::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        root = rootComponent;
        if (((PlayerModifierScreenHandler)this.field_2797).blockEntity == null) {
            this.method_25419();
            return;
        }
        dependencyLines.clear();
        shownAugments.clear();
        FlowLayout outerContainer = Containers.horizontalFlow((Sizing)Sizing.fill((int)60), (Sizing)Sizing.fill((int)80));
        outerContainer.surface(BasicMachineScreen.ORITECH_PANEL);
        FlowLayout movedPanel = Containers.horizontalFlow((Sizing)Sizing.fixed((int)900), (Sizing)Sizing.fill());
        movedPanel.surface(Surface.tiled((class_2960)Oritech.id("textures/block/machine_plating_block/empty.png"), (int)16, (int)16));
        movedPanel.margins(Insets.of((int)2));
        DraggableScrollContainer<FlowLayout> innerContainer = new DraggableScrollContainer<FlowLayout>(ScrollContainer.ScrollDirection.HORIZONTAL, Sizing.fill(), Sizing.fill(), movedPanel);
        innerContainer.scrollbar(ScrollContainer.Scrollbar.vanillaFlat());
        innerContainer.surface(Surface.PANEL_INSET);
        innerContainer.margins(Insets.of((int)6));
        main = innerContainer;
        rootComponent.child((Component)outerContainer.positioning(Positioning.relative((int)50, (int)50)));
        outerContainer.child(innerContainer);
        this.addAvailableAugments(movedPanel);
        int researchWidth = 120;
        FlowLayout researchContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)researchWidth), (Sizing)Sizing.content());
        researchContainer.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.addResearchPanels(researchContainer, researchWidth);
        FlowLayout energyPanel = Containers.verticalFlow((Sizing)Sizing.content((int)3), (Sizing)Sizing.content((int)3));
        energyPanel.surface(BasicMachineScreen.ORITECH_PANEL);
        energyPanel.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ButtonComponent loadResearchedAugments = Components.button((class_2561)class_2561.method_43471((String)"\ud83d\udd2c"), elem -> this.onLoadAugmentsClick());
        loadResearchedAugments.tooltip((class_2561)class_2561.method_43471((String)"text.oritech.load_augments.tooltip"));
        loadResearchedAugments.margins(Insets.of((int)2));
        loadResearchedAugments.renderer(BasicMachineScreen.ORITECH_BUTTON);
        ButtonComponent openInvScreen = Components.button((class_2561)class_2561.method_43471((String)"\ud83e\uddf0"), elem -> this.onOpenInvClicked());
        openInvScreen.tooltip((class_2561)class_2561.method_43471((String)"text.oritech.open_inv.tooltip"));
        openInvScreen.margins(Insets.of((int)2));
        openInvScreen.renderer(BasicMachineScreen.ORITECH_BUTTON);
        double energyPanelX = (double)this.field_22789 * 0.2 - 22.0;
        double energyPanelY = (double)this.field_22790 * 0.3;
        double researchPanelX = (double)this.field_22789 * 0.8 - 2.0;
        double researchPanelY = (double)this.field_22790 * 0.2;
        this.addEnergyBar(energyPanel);
        energyPanel.child(loadResearchedAugments.horizontalSizing(Sizing.fixed((int)18)));
        energyPanel.child(openInvScreen.horizontalSizing(Sizing.fixed((int)18)));
        root.child(energyPanel.positioning(Positioning.absolute((int)((int)energyPanelX), (int)((int)energyPanelY))).zIndex(-1));
        root.child(researchContainer.positioning(Positioning.absolute((int)((int)researchPanelX), (int)((int)researchPanelY))).zIndex(-1));
    }

    protected void method_37432() {
        super.method_37432();
        if (((PlayerModifierScreenHandler)this.field_2797).blockEntity == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            boolean isIdle;
            if (i >= this.researchLabels.size()) continue;
            LabelComponent panelData = this.researchLabels.get(i);
            AugmentApplicationEntity.ResearchState researchData = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.availableStations.get(i);
            if (researchData == null || panelData == null) continue;
            class_5250 baseKey = class_2561.method_43470((String)"");
            long time = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.method_10997().method_8510();
            boolean bl = isIdle = !researchData.working;
            if (isIdle) {
                long ticks = time % 20L / 7L;
                baseKey = class_2561.method_43471((String)("text.oritech.accelerator.ui.waiting." + ticks));
            } else {
                long remainingTicks = researchData.researchStartedAt + (long)researchData.workTime - time;
                int remainingSeconds = (int)((float)remainingTicks / 20.0f);
                baseKey = class_2561.method_43469((String)"text.oritech.augmenter_active", (Object[])new Object[]{remainingSeconds});
            }
            panelData.text((class_2561)baseKey);
        }
        for (Map.Entry<class_2960, AugmentUiState> entry : shownAugments.entrySet()) {
            class_2960 augmentId = entry.getKey();
            AugmentUiState augmentState = entry.getValue();
            AugmentDataRecipe augmentRecipe = (AugmentDataRecipe)((class_8786)((PlayerModifierScreenHandler)this.field_2797).player.method_37908().method_8433().method_8130(augmentId).get()).comp_1933();
            boolean isResearched = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.researchedAugments.contains(augmentId);
            boolean isResearching = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.availableStations.values().stream().filter(Objects::nonNull).anyMatch(station -> station.selectedResearch.equals((Object)augmentId));
            boolean isApplied = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.hasPlayerAugment(augmentId, ((PlayerModifierScreenHandler)this.field_2797).player);
            boolean hasRequirements = true;
            ArrayList<class_5250> missingRequirements = new ArrayList<class_5250>();
            missingRequirements.add(class_2561.method_43471((String)PlayerModifierScreen.augmentKey(augmentId).formatted(class_124.field_1067)));
            missingRequirements.add(class_2561.method_43471((String)"oritech.text.missing_requirements_title"));
            for (class_2960 requirementId : augmentRecipe.getRequirements()) {
                if (!((PlayerModifierScreenHandler)this.field_2797).blockEntity.researchedAugments.contains(requirementId)) {
                    hasRequirements = false;
                    missingRequirements.add(class_2561.method_43471((String)PlayerModifierScreen.augmentKey(requirementId)).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061}));
                    continue;
                }
                missingRequirements.add(class_2561.method_43471((String)PlayerModifierScreen.augmentKey(requirementId)).method_27695(new class_124[]{class_124.field_1056, class_124.field_1077}));
            }
            boolean hasResearchStation = false;
            class_2248 requiredStationBlock = (class_2248)class_7923.field_41175.method_10223(augmentRecipe.getRequiredStation());
            for (AugmentApplicationEntity.ResearchState ownStation : ((PlayerModifierScreenHandler)this.field_2797).blockEntity.availableStations.values()) {
                if (ownStation == null || !ownStation.type.equals(requiredStationBlock)) continue;
                hasResearchStation = true;
                break;
            }
            if (!hasResearchStation) {
                missingRequirements.add(class_2561.method_43469((String)"oritech.text.required_station", (Object[])new Object[]{requiredStationBlock.method_9518()}));
                hasRequirements = false;
            }
            PlayerAugments.AugmentApplicatorOperation operation = PlayerAugments.AugmentApplicatorOperation.RESEARCH;
            class_5250 tooltipTitleText = class_2561.method_43471((String)PlayerModifierScreen.augmentKey(augmentId)).method_27692(class_124.field_1067);
            String tooltipOperation = "oritech.text.augment_op.research";
            class_5250 tooltipDesc = class_2561.method_43471((String)(PlayerModifierScreen.augmentKey(augmentId) + ".desc")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
            ArrayList<class_5250> extraTooltips = new ArrayList<class_5250>();
            for (int i = 1; i < 8; ++i) {
                String key = PlayerModifierScreen.augmentKey(augmentId) + ".desc." + i;
                if (!class_1074.method_4663((String)key)) continue;
                extraTooltips.add(class_2561.method_43471((String)key).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
            }
            if (isApplied) {
                operation = PlayerAugments.AugmentApplicatorOperation.REMOVE;
                tooltipOperation = "oritech.text.augment_op.remove";
            } else if (isResearched) {
                operation = PlayerAugments.AugmentApplicatorOperation.ADD;
                tooltipOperation = "oritech.text.augment_op.apply";
            } else if (isResearching) {
                operation = PlayerAugments.AugmentApplicatorOperation.NONE;
                tooltipOperation = "oritech.text.augment_op.pending";
            }
            tooltipTitleText = class_2561.method_43471((String)tooltipOperation).method_10852((class_2561)tooltipTitleText);
            PlayerAugments.AugmentApplicatorOperation lastOp = augmentState.openOp;
            if (operation != lastOp) {
                ArrayList<class_5684> collectedTooltip = new ArrayList<class_5684>();
                Stream.of(tooltipTitleText, tooltipDesc).map(elem -> class_5684.method_32662((class_5481)elem.method_30937())).forEach(collectedTooltip::add);
                extraTooltips.stream().map(elem -> class_5684.method_32662((class_5481)elem.method_30937())).forEach(collectedTooltip::add);
                class_2960 backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
                if (isApplied) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_installed.png");
                } else if (isResearched) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_completed.png");
                } else if (isResearching) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_pending.png");
                } else {
                    List<SizedIngredient> inputs = augmentRecipe.getResearchCost();
                    int time = augmentRecipe.getTime() / 20;
                    collectedTooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"oritech.text.augment_research_time", (Object[])new Object[]{time}).method_30937()));
                    SizedIngredientTooltipComponent inputsComponent = new SizedIngredientTooltipComponent(inputs);
                    collectedTooltip.add(inputsComponent);
                }
                augmentState.icon.tooltip(collectedTooltip);
                DraggableScrollContainer scrollPanel = (DraggableScrollContainer)augmentState.parent.parent();
                int scrollOffset = (int)scrollPanel.getScrollPosition();
                TextureComponent oldBackground = augmentState.background;
                TextureComponent newBackground = Components.texture((class_2960)backgroundTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
                newBackground.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
                newBackground.positioning(Positioning.absolute((int)(oldBackground.x() - augmentState.parent.x() - scrollOffset), (int)(oldBackground.y() - augmentState.parent.y())));
                augmentState.parent.removeChild((Component)oldBackground);
                augmentState.parent.child(newBackground.zIndex(2));
                augmentState.openOp = operation;
            }
            if (!hasRequirements && augmentState.blocker == null) {
                BoxComponent blocker = Components.box((Sizing)Sizing.fixed((int)24), (Sizing)Sizing.fixed((int)24));
                blocker.color(new Color(0.3f, 0.4f, 0.4f, 0.8f));
                blocker.fill(true);
                blocker.positioning(Positioning.absolute((int)(augmentState.icon.x() - augmentState.parent.x()), (int)(augmentState.icon.y() - augmentState.parent.y())));
                blocker.mouseDown().subscribe((a, b, c) -> true);
                blocker.zIndex(4);
                augmentState.parent.child((Component)blocker);
                augmentState.blocker = blocker;
            } else if (hasRequirements && augmentState.blocker != null) {
                augmentState.parent.removeChild((Component)augmentState.blocker);
                augmentState.blocker = null;
            }
            if (hasRequirements) continue;
            augmentState.blocker.tooltip(missingRequirements);
        }
        this.updateEnergyBar();
    }

    public void method_25394(class_332 vanillaContext, int mouseX, int mouseY, float delta) {
        for (BoxComponent highlight : this.highlighters) {
            boolean isActive = highlight.isInBoundingBox((double)mouseX, (double)mouseY);
            if (isActive) {
                highlight.color(new Color(0.7f, 0.7f, 0.7f, 1.0f));
                continue;
            }
            highlight.color(new Color(0.7f, 0.7f, 0.7f, 0.0f));
        }
        super.method_25394(vanillaContext, mouseX, mouseY, delta);
    }

    protected void updateEnergyBar() {
        long capacity = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.getEnergyStorageForMultiblock(null).getCapacity();
        long amount = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.getEnergyStorageForMultiblock(null).getAmount();
        float fillAmount = (float)amount / (float)capacity;
        class_2561 tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, 0L, (int)AugmentApplicationEntity.maxEnergyTransfer);
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }

    private void addResearchPanels(FlowLayout parent, int width) {
        for (int i = 0; i < 3; ++i) {
            AugmentApplicationEntity.ResearchState researchState = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.availableStations.getOrDefault(i, null);
            if (researchState == null) {
                this.researchLabels.add(null);
                continue;
            }
            FlowLayout panel = Containers.verticalFlow((Sizing)Sizing.fixed((int)width), (Sizing)Sizing.fixed((int)((int)((double)width * 0.4))));
            LabelComponent title = Components.label((class_2561)researchState.type.method_9518().method_27692(class_124.field_1067));
            title.horizontalSizing(Sizing.fill());
            title.horizontalTextAlignment(HorizontalAlignment.CENTER);
            LabelComponent status = Components.label((class_2561)class_2561.method_43470((String)" "));
            panel.child((Component)title);
            panel.child((Component)status.margins(Insets.of((int)4, (int)2, (int)0, (int)0)));
            this.researchLabels.add(status);
            parent.child(panel.surface(BasicMachineScreen.ORITECH_PANEL).padding(Insets.of((int)6)).margins(Insets.of((int)0, (int)10, (int)0, (int)0)).zIndex(-1));
        }
    }

    private void addAvailableAugments(FlowLayout parent) {
        float maxHeight = (float)this.field_22790 * 0.75f;
        int leftOffset = 20;
        for (class_2960 augmentId : PlayerAugments.allAugments.keySet()) {
            AugmentDataRecipe augmentRecipe = (AugmentDataRecipe)((class_8786)((PlayerModifierScreenHandler)this.field_2797).player.method_37908().method_8433().method_8130(augmentId).get()).comp_1933();
            Vector2i position = new Vector2i(leftOffset + augmentRecipe.getUiX() * 4, (int)((float)augmentRecipe.getUiY() / 100.0f * maxHeight));
            class_2960 iconTexture = Oritech.id("textures/gui/" + augmentId.method_12832() + ".png");
            class_2960 backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
            class_2960 augmentOpId = augmentId;
            TextureComponent icon = Components.texture((class_2960)iconTexture, (int)0, (int)0, (int)24, (int)24, (int)24, (int)24);
            icon.mouseDown().subscribe((a, b, c) -> {
                this.onAugmentClick(augmentOpId, PlayerModifierScreen.shownAugments.get((Object)augmentOpId).openOp, false);
                return true;
            });
            icon.sizing(Sizing.fixed((int)24), Sizing.fixed((int)24));
            icon.positioning(Positioning.absolute((int)(position.x - 12), (int)(position.y - 12)));
            TextureComponent background = Components.texture((class_2960)backgroundTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
            background.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
            background.positioning(Positioning.absolute((int)(position.x - 16), (int)(position.y - 16)));
            BoxComponent highlight = Components.box((Sizing)Sizing.fixed((int)34), (Sizing)Sizing.fixed((int)34));
            highlight.color(new Color(0.7f, 0.7f, 0.7f, 1.0f));
            highlight.positioning(Positioning.absolute((int)(position.x - 16 - 1), (int)(position.y - 16 - 1)));
            for (class_2960 dependencyId : augmentRecipe.getRequirements()) {
                AugmentDataRecipe dependencyRecipe = (AugmentDataRecipe)((class_8786)((PlayerModifierScreenHandler)this.field_2797).player.method_37908().method_8433().method_8130(dependencyId).get()).comp_1933();
                Vector2i dependencyPos = new Vector2i(leftOffset + dependencyRecipe.getUiX() * 4, (int)((float)dependencyRecipe.getUiY() / 100.0f * maxHeight));
                String depId = augmentId.method_12832() + "_" + dependencyId.method_12832();
                dependencyLines.put(depId, (class_3545<Vector2i, Vector2i>)new class_3545((Object)position, (Object)dependencyPos));
            }
            parent.child(highlight.zIndex(1));
            parent.child(background.zIndex(2));
            parent.child(icon.zIndex(3));
            this.highlighters.add(highlight);
            shownAugments.put(augmentId, new AugmentUiState(highlight, background, icon, null, PlayerAugments.AugmentApplicatorOperation.NEEDS_INIT, parent));
        }
    }

    private void onAugmentClick(class_2960 id, PlayerAugments.AugmentApplicatorOperation operation, boolean confirmed) {
        if (!confirmed) {
            this.showAugmentDialog(id, operation);
            return;
        }
        int operationId = operation.ordinal();
        NetworkManager.sendToServer(new PlayerAugments.AugmentInstallTriggerPacket(((PlayerModifierScreenHandler)this.field_2797).blockPos, id, operationId));
    }

    private void onLoadAugmentsClick() {
        NetworkManager.sendToServer(new PlayerAugments.LoadPlayerAugmentsToMachinePacket(((PlayerModifierScreenHandler)this.field_2797).blockPos));
        int loadedAugmentsCount = 0;
        for (Map.Entry<class_2960, Augment> entry : PlayerAugments.allAugments.entrySet()) {
            Augment augment = entry.getValue();
            boolean isResearched = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.researchedAugments.contains(entry.getKey());
            boolean isInstalled = augment.isInstalled(((PlayerModifierScreenHandler)this.field_2797).player);
            if (!isInstalled || isResearched) continue;
            ++loadedAugmentsCount;
        }
        ((PlayerModifierScreenHandler)this.field_2797).player.method_43496((class_2561)class_2561.method_43469((String)"text.oritech.loaded_augments", (Object[])new Object[]{loadedAugmentsCount}));
        this.method_25419();
    }

    private void onOpenInvClicked() {
        this.method_25419();
        NetworkManager.sendToServer(new PlayerAugments.OpenAugmentScreenPacket(((PlayerModifierScreenHandler)this.field_2797).blockPos));
    }

    private void showAugmentDialog(class_2960 id, PlayerAugments.AugmentApplicatorOperation operation) {
        AugmentDataRecipe researchRecipe = (AugmentDataRecipe)((class_8786)((PlayerModifierScreenHandler)this.field_2797).blockEntity.method_10997().method_8433().method_8130(id).get()).comp_1933();
        boolean isCreative = ((PlayerModifierScreenHandler)this.field_2797).player.method_7337();
        boolean hasResources = true;
        boolean hasEnergy = true;
        FlowLayout panel = Containers.verticalFlow((Sizing)Sizing.fixed((int)310), (Sizing)Sizing.content((int)1));
        panel.padding(Insets.of((int)5));
        panel.surface(BasicMachineScreen.ORITECH_PANEL);
        panel.horizontalAlignment(HorizontalAlignment.CENTER);
        FlowLayout descriptionPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)3));
        descriptionPanel.surface(Surface.PANEL_INSET);
        descriptionPanel.padding(Insets.of((int)3, (int)0, (int)3, (int)3));
        descriptionPanel.margins(Insets.of((int)4));
        OverlayContainer overlay = Containers.overlay((Component)panel);
        LabelComponent titleLabel = Components.label((class_2561)class_2561.method_43471((String)PlayerModifierScreen.augmentKey(id)).method_27695(new class_124[]{class_124.field_1067, class_124.field_1074}));
        titleLabel.margins(Insets.of((int)3, (int)1, (int)0, (int)0));
        descriptionPanel.child((Component)Components.label((class_2561)class_2561.method_43471((String)(PlayerModifierScreen.augmentKey(id) + ".desc")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})));
        for (int i = 1; i < 8; ++i) {
            String key = PlayerModifierScreen.augmentKey(id) + ".desc." + i;
            if (!class_1074.method_4663((String)key)) continue;
            descriptionPanel.child((Component)Components.label((class_2561)class_2561.method_43471((String)key).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})));
        }
        class_2248 requiredStationBlock = (class_2248)class_7923.field_41175.method_10223(researchRecipe.getRequiredStation());
        LabelComponent requiredStationLabel = Components.label((class_2561)class_2561.method_43469((String)"oritech.text.required_station", (Object[])new Object[]{requiredStationBlock.method_9518()}));
        descriptionPanel.child((Component)requiredStationLabel.margins(Insets.of((int)4, (int)2, (int)0, (int)0)));
        boolean hasRequiredStation = false;
        for (int i = 0; i < 3; ++i) {
            AugmentApplicationEntity.ResearchState station = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.availableStations.getOrDefault(i, null);
            if (station == null || station.working || !requiredStationBlock.equals(station.type)) continue;
            hasRequiredStation = true;
        }
        if (!operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.RESEARCH)) {
                long rfCost = researchRecipe.getRfCost();
                Iterator<SizedIngredient> parsedCost = TooltipHelper.getEnergyText(rfCost);
                descriptionPanel.child((Component)Components.label((class_2561)class_2561.method_43469((String)"oritech.text.augment_research_time", (Object[])new Object[]{researchRecipe.getTime() / 20}).method_27692(class_124.field_1068)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
                descriptionPanel.child((Component)Components.label((class_2561)class_2561.method_43469((String)"oritech.text.energy_cost", (Object[])new Object[]{parsedCost}).method_27692(class_124.field_1068)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
                if (((PlayerModifierScreenHandler)this.field_2797).blockEntity.getEnergyStorageForMultiblock(null).getAmount() < rfCost) {
                    hasEnergy = false;
                }
            }
            descriptionPanel.child((Component)Components.label((class_2561)class_2561.method_43471((String)"oritech.text.augment_resource_cost").method_27692(class_124.field_1068)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
            FlowLayout itemContainer = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)1));
            List<SizedIngredient> shownCost = researchRecipe.getResearchCost();
            if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD)) {
                shownCost = researchRecipe.getApplyCost();
            }
            for (SizedIngredient wantedInput : shownCost) {
                class_1856 type = wantedInput.ingredient();
                int count = wantedInput.count();
                int matchingIngredients = ((PlayerModifierScreenHandler)this.field_2797).blockEntity.inventory.heldStacks.stream().filter(type).mapToInt(class_1799::method_7947).sum();
                int playerMatchingIngredients = ((PlayerModifierScreenHandler)this.field_2797).player.method_31548().field_7547.stream().filter(type).mapToInt(class_1799::method_7947).sum();
                if (playerMatchingIngredients + matchingIngredients >= count) continue;
                hasResources = false;
                break;
            }
            for (SizedIngredient input : shownCost) {
                class_1792 shownItem = Arrays.stream(input.ingredient().method_8105()).findFirst().get().method_7909();
                class_1799 shownStack = new class_1799((class_1935)shownItem, input.count());
                List<class_2561> allMatchingItems = Arrays.stream(input.ingredient().method_8105()).map(class_1799::method_7964).toList();
                ArrayList<Object> combinedList = new ArrayList<Object>();
                combinedList.add(class_2561.method_43471((String)"oritech.text.augment_ingredient_tip").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080}));
                combinedList.addAll(allMatchingItems);
                ItemComponent shown = Components.item((class_1799)shownStack).showOverlay(true).setTooltipFromStack(false);
                if (allMatchingItems.size() > 1) {
                    shown.tooltip(combinedList);
                } else {
                    shown.setTooltipFromStack(true);
                }
                itemContainer.child((Component)shown.margins(Insets.of((int)2)));
            }
            descriptionPanel.child((Component)itemContainer);
        }
        FlowLayout buttonPanel = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)26));
        buttonPanel.margins(Insets.of((int)2, (int)0, (int)4, (int)4));
        buttonPanel.horizontalAlignment(HorizontalAlignment.RIGHT);
        String confirmKey = "text.oritech.begin_research";
        if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD)) {
            confirmKey = "text.oritech.install";
        } else if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            confirmKey = "text.oritech.remove";
        } else if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.NONE)) {
            confirmKey = "text.oritech.noop";
        }
        ButtonComponent cancelButton = Components.button((class_2561)class_2561.method_43471((String)"text.oritech.cancel").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR), component -> overlay.remove());
        cancelButton.textShadow(false);
        ButtonComponent confirmButton = Components.button((class_2561)class_2561.method_43471((String)confirmKey).method_54663(BasicMachineScreen.GRAY_TEXT_COLOR), component -> {
            this.onAugmentClick(id, operation, true);
            overlay.remove();
        });
        confirmButton.textShadow(false);
        cancelButton.renderer(BasicMachineScreen.ORITECH_BUTTON);
        confirmButton.renderer(BasicMachineScreen.ORITECH_BUTTON);
        if (!(hasResources && hasEnergy || !isCreative)) {
            hasResources = true;
            hasEnergy = true;
            class_5250 text = class_2561.method_43470((String)"[C] ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43471((String)confirmKey));
            confirmButton.method_25355((class_2561)text);
            confirmButton.tooltip((class_2561)class_2561.method_43471((String)"text.oritech.augmenter_creative_tooltip"));
        }
        if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.NONE) || operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.RESEARCH) && (!hasRequiredStation || !hasResources || !hasEnergy) || operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD) && !hasResources) {
            confirmButton.active(false);
        }
        buttonPanel.child(cancelButton.margins(Insets.of((int)2)));
        buttonPanel.child(confirmButton.margins(Insets.of((int)2, (int)2, (int)2, (int)0)));
        panel.child((Component)titleLabel);
        panel.child((Component)descriptionPanel);
        panel.child((Component)buttonPanel);
        overlay.zIndex(100);
        root.child((Component)overlay);
    }

    private void addEnergyBar(FlowLayout panel) {
        int insetSize = 1;
        class_5250 tooltipText = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{10, 50});
        int width = 17;
        int height = 80;
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(width + insetSize * 2)), (Sizing)Sizing.fixed((int)(height + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((class_2960)BasicMachineScreen.GUI_COMPONENTS, (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
        this.energyIndicator = Components.texture((class_2960)BasicMachineScreen.GUI_COMPONENTS, (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((class_2561)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    private static void drawLine(class_332 context, Vector2i from, Vector2i to, int color) {
        if ((double)from.distanceSquared((Vector2ic)to) < 0.1) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        Matrix4f pos = matrices.method_23760().method_23761();
        Vector2f normal = AugmentSelectionScreen.getNormalVector(from, to).normalize();
        Vector2f offset = normal.mul(1.0f);
        float zIndex = 1.1f;
        class_4588 buffer = context.method_51450().getBuffer(class_1921.method_51784());
        buffer.method_22918(pos, (float)from.x - offset.x, (float)from.y - offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, (float)from.x + offset.x, (float)from.y + offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, (float)to.x + offset.x, (float)to.y + offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, (float)to.x - offset.x, (float)to.y - offset.y, zIndex).method_39415(color);
        context.method_51452();
        matrices.method_22909();
    }

    public static String augmentKey(class_2960 id) {
        return "oritech.text." + id.method_12832().replace('/', '.');
    }

    static {
        dependencyLines = new HashMap();
        shownAugments = new HashMap();
    }

    private static class DraggableScrollContainer<C extends Component>
    extends ScrollContainer<C> {
        protected DraggableScrollContainer(ScrollContainer.ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child) {
            super(direction, horizontalSizing, verticalSizing, child);
        }

        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            boolean inScrollBar = this.isInScrollbar((double)this.x + mouseX, (double)this.y + mouseY);
            double delta = this.direction.choose(deltaX, deltaY);
            double selfSize = (Integer)this.direction.sizeGetter.apply(this) - (Integer)this.direction.insetGetter.apply((Insets)this.padding.get());
            double scalar = (double)this.maxScroll / (selfSize - this.lastScrollbarLength);
            if (!Double.isFinite(scalar)) {
                scalar = 0.0;
            }
            this.scrollBy(delta * (scalar *= -0.5), true, false);
            if (inScrollBar) {
                this.scrollbaring = true;
            }
            return false;
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            Vector2i offset = new Vector2i((int)(-this.currentScrollPosition), 0).add(this.x, this.y);
            for (class_3545<Vector2i, Vector2i> dependency : dependencyLines.values()) {
                PlayerModifierScreen.drawLine((class_332)context, new Vector2i((Vector2ic)dependency.method_15442()).add((Vector2ic)offset), new Vector2i((Vector2ic)dependency.method_15441()).add((Vector2ic)offset), new Color(0.1f, 0.15f, 0.2f, 1.0f).argb());
            }
        }

        public double getScrollPosition() {
            return this.currentScrollPosition;
        }
    }

    private static final class AugmentUiState {
        private BoxComponent highlight;
        private TextureComponent background;
        private TextureComponent icon;
        private BoxComponent blocker;
        private PlayerAugments.AugmentApplicatorOperation openOp;
        private final FlowLayout parent;

        private AugmentUiState(BoxComponent highlight, TextureComponent background, TextureComponent icon, BoxComponent blocker, PlayerAugments.AugmentApplicatorOperation openOp, FlowLayout parent) {
            this.highlight = highlight;
            this.background = background;
            this.icon = icon;
            this.blocker = blocker;
            this.openOp = openOp;
            this.parent = parent;
        }
    }

    public static class SizedIngredientTooltipComponent
    implements class_5684 {
        private final List<SizedIngredient> items;
        private final int size = 16;
        private final int spacing = 3;

        public SizedIngredientTooltipComponent(List<SizedIngredient> items) {
            this.items = items;
        }

        public int method_32661() {
            return 24;
        }

        public int method_32664(class_327 textRenderer) {
            return 19 * this.items.size();
        }

        public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
            context.push();
            for (int i = 0; i < this.items.size(); ++i) {
                SizedIngredient ingredient = this.items.get(i);
                if (ingredient.ingredient().method_8105().length == 0) continue;
                class_1799 stack = Arrays.stream(ingredient.ingredient().method_8105()).findFirst().get();
                stack = new class_1799((class_1935)stack.method_7909(), ingredient.count());
                int itemX = x + 19 * i;
                int itemY = y + 3;
                context.method_51427(stack, itemX, itemY);
                if (stack.method_7947() <= 1) continue;
                context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                context.method_51433(textRenderer, String.valueOf(stack.method_7947()), itemX + 19 - 2 - textRenderer.method_1727(String.valueOf(stack.method_7947())), itemY + 6 + 3, 0xFFFFFF, true);
            }
            context.pop();
        }
    }

    private static class CustomFlowRootContainer
    extends FlowLayout {
        public static FlowLayout verticalFlow(Sizing horizontalSizing, Sizing verticalSizing) {
            return new CustomFlowRootContainer(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        }

        protected CustomFlowRootContainer(Sizing horizontalSizing, Sizing verticalSizing, FlowLayout.Algorithm algorithm) {
            super(horizontalSizing, verticalSizing, algorithm);
        }

        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            if (main != null) {
                return main.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            }
            return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
    }
}

