/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SpriteComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.ui.util.SpriteUtilInvoker;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2459;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_9801;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import rearth.oracle.OracleClient;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.generators.BasicGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.client.renderers.LaserArmModel;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.TooltipHelper;

public class BasicMachineScreen<S extends BasicMachineScreenHandler>
extends BaseOwoHandledScreen<FlowLayout, S> {
    public static final class_2960 BACKGROUND = Oritech.id("textures/gui/modular/gui_base.png");
    public static final class_2960 ITEM_SLOT = Oritech.id("textures/gui/modular/itemslot.png");
    public static final class_2960 GUI_COMPONENTS = Oritech.id("textures/gui/modular/machine_gui_components.png");
    public static final int GRAY_TEXT_COLOR = new Color(0.2f, 0.2f, 0.3f).rgb();
    public static Surface ORITECH_PANEL = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oritech", (String)"bedrock_panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORITECH_PANEL_DARK = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oritech", (String)"bedrock_panel_dark"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORITECH_PANEL_ORANGE = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oritech", (String)"bedrock_panel_orange"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static ButtonComponent.Renderer ORITECH_BUTTON = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        class_2960 texture = button.field_22763 ? (button.method_49606() ? (class_310.method_1551().field_1729.method_1608() ? class_2960.method_60655((String)"oritech", (String)"bedrock_panel_pressed") : class_2960.method_60655((String)"oritech", (String)"bedrock_panel_hover")) : class_2960.method_60655((String)"oritech", (String)"bedrock_panel")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.width(), (int)button.height());
    };
    public static ButtonComponent.Renderer ORITECH_BUTTON_DARK = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        class_2960 texture = button.field_22763 ? (button.method_49606() ? (class_310.method_1551().field_1729.method_1608() ? class_2960.method_60655((String)"oritech", (String)"bedrock_panel_pressed") : class_2960.method_60655((String)"oritech", (String)"bedrock_panel_dark_hover")) : class_2960.method_60655((String)"oritech", (String)"bedrock_panel_dark")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.width(), (int)button.height());
    };
    public FlowLayout root;
    protected TextureComponent progress_indicator;
    protected TextureComponent energyIndicator;
    private ButtonComponent cycleInputButton;
    private final FluidDisplay genericDisplay;
    private final FluidDisplay steamDisplay;
    private final FluidDisplay waterDisplay;
    protected final LabelComponent steamProductionLabel;

    public BasicMachineScreen(S handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        ScreenProvider.BarConfiguration config;
        if (((BasicMachineScreenHandler)((Object)handler)).mainFluidContainer != null) {
            config = ((BasicMachineScreenHandler)((Object)handler)).screenData.getFluidConfiguration();
            this.genericDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).mainFluidContainer, config);
        } else {
            this.genericDisplay = null;
        }
        if (((BasicMachineScreenHandler)((Object)handler)).steamStorage != null) {
            config = this.getBoilerInConfig();
            this.waterDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).waterStorage, config);
            ScreenProvider.BarConfiguration configSteam = this.getBoilerOutConfig();
            this.steamDisplay = this.initFluidDisplay(((BasicMachineScreenHandler)((Object)handler)).steamStorage, configSteam);
            this.steamProductionLabel = Components.label((class_2561)class_2561.method_43469((String)"title.oritech.steam_production", (Object[])new Object[]{"0"}));
            this.steamProductionLabel.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.steam_production"));
        } else {
            this.steamDisplay = null;
            this.waterDisplay = null;
            this.steamProductionLabel = null;
        }
    }

    public ScreenProvider.BarConfiguration getBoilerInConfig() {
        return ((BasicMachineScreenHandler)this.field_2797).screenData.getEnergyConfiguration();
    }

    public ScreenProvider.BarConfiguration getBoilerOutConfig() {
        ScreenProvider.BarConfiguration config = this.getBoilerInConfig();
        return new ScreenProvider.BarConfiguration(config.x() + config.width() + 8, config.y(), config.width(), config.height());
    }

    public class_2960 getGuiComponents() {
        return GUI_COMPONENTS;
    }

    public class_2960 getItemSlot() {
        return ITEM_SLOT;
    }

    public class_2960 getBackground() {
        return BACKGROUND;
    }

    protected FluidDisplay initFluidDisplay(FluidApi.SingleSlotStorage container, ScreenProvider.BarConfiguration config) {
        float lastFill = 1.0f - (float)container.getStack().getAmount() / (float)container.getCapacity();
        ColoredSpriteComponent background = BasicMachineScreen.createFluidRenderer(container.getStack(), config);
        BoxComponent fillOverlay = Components.box((Sizing)Sizing.fixed((int)config.width()), (Sizing)Sizing.fixed((int)((int)((float)config.height() * lastFill))));
        fillOverlay.color(new Color(0.30431372f, 0.30431372f, 0.30431372f));
        fillOverlay.fill(true);
        fillOverlay.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        TextureComponent foreGround = Components.texture((class_2960)this.getGuiComponents(), (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
        foreGround.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        foreGround.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        return new FluidDisplay(fillOverlay, lastFill, container.getStack().getFluid(), background, foreGround, config, container);
    }

    public static Component getItemFrame(int x, int y) {
        return Components.texture((class_2960)ITEM_SLOT, (int)0, (int)0, (int)18, (int)18, (int)18, (int)18).sizing(Sizing.fixed((int)18)).positioning(Positioning.absolute((int)(x - 1), (int)(y - 1)));
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.root = rootComponent;
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        if (this.showExtensionPanel()) {
            rootComponent.child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)426), (Sizing)Sizing.fixed((int)206)).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.buildExtensionPanel()).surface(ORITECH_PANEL).positioning(Positioning.absolute((int)293, (int)30))).positioning(Positioning.relative((int)50, (int)50)).zIndex(-1));
        }
        if (((BasicMachineScreenHandler)this.field_2797).armorSlots != null) {
            rootComponent.child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)426), (Sizing)Sizing.fixed((int)206)).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.buildEquipmentPanel()).surface(ORITECH_PANEL).positioning(Positioning.absolute((int)96, (int)30))).positioning(Positioning.relative((int)50, (int)50)).zIndex(-1));
        }
        if (Oritech.CONFIG.enableHelpButton()) {
            boolean hasOracleLib = Platform.isModLoaded((String)"oracle_index");
            Optional<Object> linkTarget = hasOracleLib ? this.getHelpBookLink() : Optional.empty();
            ButtonComponent oracleButton = Components.button((class_2561)class_2561.method_43470((String)"?"), elem -> this.onOracleButtonClick(hasOracleLib, linkTarget));
            oracleButton.renderer(ORITECH_BUTTON_DARK);
            if (hasOracleLib) {
                oracleButton.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.oracle_available"));
            } else {
                oracleButton.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.oracle_missing"));
            }
            oracleButton.positioning(Positioning.relative((int)0, (int)96));
            oracleButton.zIndex(10);
            if (linkTarget.isPresent() || !hasOracleLib) {
                rootComponent.child((Component)Containers.horizontalFlow((Sizing)Sizing.fixed((int)201), (Sizing)Sizing.fixed((int)186)).child((Component)oracleButton).positioning(Positioning.relative((int)50, (int)50)));
            }
        }
        rootComponent.child((Component)Components.texture((class_2960)BACKGROUND, (int)0, (int)0, (int)176, (int)166, (int)176, (int)166)).child((Component)this.buildOverlay().positioning(Positioning.relative((int)50, (int)50)));
    }

    public boolean showExtensionPanel() {
        return ((BasicMachineScreenHandler)this.field_2797).screenData.showExpansionPanel();
    }

    protected void method_37432() {
        super.method_37432();
        if (((BasicMachineScreenHandler)this.field_2797).screenData.showEnergy()) {
            if (((BasicMachineScreenHandler)this.field_2797).steamStorage != null) {
                this.updateFluidDisplay(this.waterDisplay);
                this.updateFluidDisplay(this.steamDisplay);
            } else {
                this.updateEnergyBar();
            }
        }
        if (((BasicMachineScreenHandler)this.field_2797).screenData.showProgress()) {
            this.updateProgressBar();
        }
        if (this.showExtensionPanel()) {
            this.updateSettingsButtons();
        }
        if (((BasicMachineScreenHandler)this.field_2797).mainFluidContainer != null) {
            this.updateFluidDisplay(this.genericDisplay);
        }
        if (this.steamProductionLabel != null) {
            float productionRate = ((BasicMachineScreenHandler)this.field_2797).screenData.getDisplayedEnergyUsage() * Oritech.CONFIG.generators.steamEngineData.rfToSteamRatio();
            productionRate = Math.min((float)this.waterDisplay.storage.getStack().getAmount(), productionRate);
            this.steamProductionLabel.text((class_2561)class_2561.method_43469((String)"title.oritech.steam_production", (Object[])new Object[]{String.format("%.0f", Float.valueOf(productionRate))}));
        }
    }

    private void updateProgressBar() {
        MachineBlockEntity machineEntity;
        ScreenProvider.ArrowConfiguration config = ((BasicMachineScreenHandler)this.field_2797).screenData.getIndicatorConfiguration();
        float progress = ((BasicMachineScreenHandler)this.field_2797).screenData.getProgress();
        class_2586 class_25862 = ((BasicMachineScreenHandler)this.field_2797).blockEntity;
        if (class_25862 instanceof MachineBlockEntity && ((machineEntity = (MachineBlockEntity)class_25862).getCurrentRecipe().getTime() > 0 || machineEntity.progress > 0)) {
            int progressTicks = machineEntity.progress;
            int recipeDurationTicks = machineEntity.getCurrentRecipe().getTime();
            int effectiveDurationTicks = (int)((float)recipeDurationTicks * machineEntity.getSpeedMultiplier());
            if (machineEntity instanceof UpgradableGeneratorBlockEntity) {
                UpgradableGeneratorBlockEntity generatorBlock = (UpgradableGeneratorBlockEntity)machineEntity;
                if (recipeDurationTicks <= 0) {
                    recipeDurationTicks = (int)((float)generatorBlock.currentMaxBurnTime / generatorBlock.getSpeedMultiplier() * generatorBlock.getEfficiencyMultiplier());
                }
                effectiveDurationTicks = generatorBlock.currentMaxBurnTime;
            }
            if (machineEntity instanceof BasicGeneratorEntity) {
                BasicGeneratorEntity generatorEntity = (BasicGeneratorEntity)machineEntity;
                recipeDurationTicks = generatorEntity.currentMaxBurnTime;
            }
            this.progress_indicator.tooltip((class_2561)class_2561.method_43469((String)"tooltip.oritech.progress_indicator", (Object[])new Object[]{progressTicks, effectiveDurationTicks, recipeDurationTicks}));
        }
        if (config.horizontal()) {
            this.progress_indicator.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)((int)((float)config.width() * progress)), (int)config.height()));
        } else {
            this.progress_indicator.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)config.width(), (int)((int)((float)config.height() * progress))));
        }
    }

    protected void updateEnergyBar() {
        long capacity = ((BasicMachineScreenHandler)this.field_2797).energyStorage.getCapacity();
        long amount = ((BasicMachineScreenHandler)this.field_2797).energyStorage.getAmount();
        long transfer = (long)((BasicMachineScreenHandler)this.field_2797).screenData.getDisplayedEnergyTransfer();
        long usage = (long)((BasicMachineScreenHandler)this.field_2797).screenData.getDisplayedEnergyUsage();
        float fillAmount = (float)amount / (float)capacity;
        class_2561 tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, usage, transfer);
        boolean isAtomicForge = ((BasicMachineScreenHandler)this.field_2797).blockEntity instanceof AtomicForgeBlockEntity;
        if (isAtomicForge) {
            tooltipText = tooltipText.method_27662().method_10852((class_2561)class_2561.method_43471((String)"tooltip.oritech.atomic_forge_energy_tip"));
        }
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }

    public static class_2561 getEnergyTooltip(long amount, long max, long showedUsage, long showedTransfer) {
        float percentage = (float)amount / (float)max;
        String energyFill = String.format("%.1f", Float.valueOf(percentage * 100.0f));
        String storedAmount = TooltipHelper.getEnergyText(amount);
        String usageText = TooltipHelper.getEnergyText(showedUsage);
        String maxAmount = TooltipHelper.getEnergyText(max);
        String transfer = TooltipHelper.getEnergyText(showedTransfer);
        return class_2561.method_43469((String)"tooltip.oritech.energy_usage", (Object[])new Object[]{storedAmount, maxAmount, energyFill, usageText, transfer});
    }

    public void updateSettingsButtons() {
        class_2586 class_25862;
        InventoryInputMode activeMode = ((BasicMachineScreenHandler)this.field_2797).screenData.getInventoryInputMode();
        String modeName = activeMode.name().toLowerCase(Locale.ROOT);
        if (activeMode.equals((Object)InventoryInputMode.SIDED) && (class_25862 = ((BasicMachineScreenHandler)this.field_2797).blockEntity) instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)class_25862;
            class_5250 tooltip = class_2561.method_43471((String)"tooltip.%s.input_mode_%s".formatted("oritech", modeName));
            InventorySlotAssignment assignment = machineBlock.getSlotAssignments();
            for (class_2350 direction : class_2350.values()) {
                String key = "tooltip.oritech.mode_sided_slot_number";
                if (direction.equals((Object)class_2350.field_11033)) {
                    key = "tooltip.oritech.mode_sided_bottom";
                }
                if (direction.equals((Object)class_2350.field_11036)) {
                    key = "tooltip.oritech.mode_sided_top";
                }
                int horizontalOrdinal = 0;
                if (direction.equals((Object)class_2350.field_11034)) {
                    horizontalOrdinal = 1;
                }
                if (direction.equals((Object)class_2350.field_11035)) {
                    horizontalOrdinal = 2;
                }
                if (direction.equals((Object)class_2350.field_11039)) {
                    horizontalOrdinal = 3;
                }
                int inputSlotIndex = assignment.inputStart() + horizontalOrdinal % assignment.inputCount();
                tooltip = tooltip.method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{StringUtils.capitalize((String)direction.toString()), inputSlotIndex}));
            }
            this.cycleInputButton.tooltip((class_2561)tooltip);
        } else {
            this.cycleInputButton.tooltip((class_2561)class_2561.method_43471((String)"tooltip.%s.input_mode_%s".formatted("oritech", modeName)));
        }
        this.cycleInputButton.method_25355((class_2561)class_2561.method_43471((String)"button.%s.input_mode_%s".formatted("oritech", modeName)).method_54663(GRAY_TEXT_COLOR));
        this.cycleInputButton.method_25355((class_2561)class_2561.method_43471((String)"button.%s.input_mode_%s".formatted("oritech", modeName)).method_54663(GRAY_TEXT_COLOR));
    }

    private Component buildExtensionPanel() {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        container.padding(Insets.of((int)1, (int)4, (int)1, (int)1));
        container.margins(Insets.of((int)7));
        this.addExtensionComponents(container);
        this.updateSettingsButtons();
        return container;
    }

    private Component buildEquipmentPanel() {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        container.padding(Insets.of((int)2));
        container.margins(Insets.of((int)6));
        for (int i = ((BasicMachineScreenHandler)this.field_2797).armorSlots.size() - 1; i >= 0; --i) {
            Integer slotId = ((BasicMachineScreenHandler)this.field_2797).armorSlots.get(i);
            FlowLayout slotContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            BaseOwoHandledScreen.SlotComponent slotComponent = this.slotAsComponent(slotId);
            TextureComponent background = Components.texture((class_2960)this.getEquipmentSlotTexture(i), (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
            slotContainer.child((Component)slotComponent);
            slotContainer.child((Component)background.positioning(Positioning.absolute((int)0, (int)0)));
            container.child((Component)slotContainer.margins(Insets.of((int)1)));
            if (i <= 0) continue;
            container.child((Component)Components.box((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)));
        }
        return container;
    }

    private class_2960 getEquipmentSlotTexture(int armorSlot) {
        return switch (armorSlot) {
            case 0 -> class_2960.method_60655((String)"minecraft", (String)"textures/item/empty_armor_slot_boots.png");
            case 1 -> class_2960.method_60655((String)"minecraft", (String)"textures/item/empty_armor_slot_leggings.png");
            case 2 -> class_2960.method_60655((String)"minecraft", (String)"textures/item/empty_armor_slot_chestplate.png");
            case 3 -> class_2960.method_60655((String)"minecraft", (String)"textures/item/empty_armor_slot_helmet.png");
            case 4 -> class_2960.method_60655((String)"minecraft", (String)"textures/item/empty_slot_axe.png");
            default -> null;
        };
    }

    public void addExtensionComponents(FlowLayout container) {
        this.cycleInputButton = Components.button((class_2561)class_2561.method_43471((String)"button.oritech.input_mode_fill_matching_recipe").method_54663(GRAY_TEXT_COLOR), button -> NetworkManager.sendToServer(new MachineBlockEntity.InventoryInputModeSelectorPacket(((BasicMachineScreenHandler)this.field_2797).blockPos)));
        this.cycleInputButton.horizontalSizing(Sizing.fixed((int)73));
        this.cycleInputButton.margins(Insets.of((int)3));
        this.cycleInputButton.renderer(ORITECH_BUTTON);
        this.cycleInputButton.textShadow(false);
        container.child((Component)Components.label((class_2561)class_2561.method_43471((String)"title.oritech.details")).margins(Insets.of((int)3, (int)1, (int)1, (int)1)));
        long inputSlots = ((BasicMachineScreenHandler)this.field_2797).screenData.getGuiSlots().stream().filter(slot -> !slot.output()).count();
        if (((BasicMachineScreenHandler)this.field_2797).screenData.inputOptionsEnabled() && inputSlots > 1L) {
            container.child((Component)this.cycleInputButton);
        }
        for (class_3545<class_2561, class_2561> label : ((BasicMachineScreenHandler)this.field_2797).screenData.getExtraExtensionLabels()) {
            container.child(Components.label((class_2561)((class_2561)label.method_15442())).tooltip((class_2561)label.method_15441()).margins(Insets.of((int)3)));
        }
        if (((BasicMachineScreenHandler)this.field_2797).showRedstoneAddon()) {
            container.child((Component)Components.box((Sizing)Sizing.fixed((int)73), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)).margins(Insets.of((int)2)));
            boolean hasRedstone = ((BasicMachineScreenHandler)this.field_2797).screenData.receivedRedstoneSignal() > 0;
            FlowLayout statusContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            statusContainer.child(Components.block((class_2680)((class_2680)class_2246.field_10523.method_9564().method_11657((class_2769)class_2459.field_11446, (Comparable)Boolean.valueOf(hasRedstone)))).sizing(Sizing.fixed((int)20)).margins(Insets.of((int)-6, (int)-4, (int)-8, (int)-4)));
            statusContainer.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.oritech.redstone_power", (Object[])new Object[]{((BasicMachineScreenHandler)this.field_2797).screenData.receivedRedstoneSignal()})).margins(Insets.of((int)3, (int)1, (int)1, (int)1)));
            container.child((Component)statusContainer);
            if (!((BasicMachineScreenHandler)this.field_2797).screenData.currentRedstoneEffect().isEmpty()) {
                container.child(Components.label((class_2561)class_2561.method_43471((String)((BasicMachineScreenHandler)this.field_2797).screenData.currentRedstoneEffect())).tooltip((class_2561)class_2561.method_43471((String)(((BasicMachineScreenHandler)this.field_2797).screenData.currentRedstoneEffect() + ".tooltip"))).margins(Insets.of((int)3, (int)3, (int)1, (int)1)));
            }
        }
    }

    private FlowLayout buildOverlay() {
        FlowLayout overlay = Containers.verticalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)166));
        this.fillOverlay(overlay);
        return overlay;
    }

    public void fillOverlay(FlowLayout overlay) {
        this.addTitle(overlay);
        if (((BasicMachineScreenHandler)this.field_2797).mainFluidContainer != null) {
            this.addFluidDisplay(overlay, this.genericDisplay);
            this.updateFluidDisplay(this.genericDisplay);
        }
        for (ScreenProvider.GuiSlot slot : ((BasicMachineScreenHandler)this.field_2797).screenData.getGuiSlots()) {
            overlay.child((Component)this.slotAsComponent(slot.index()).positioning(Positioning.absolute((int)slot.x(), (int)slot.y())));
            overlay.child(BasicMachineScreen.getItemFrame(slot.x(), slot.y()));
        }
        if (((BasicMachineScreenHandler)this.field_2797).screenData.showEnergy()) {
            if (((BasicMachineScreenHandler)this.field_2797).steamStorage != null) {
                this.addFluidDisplay(overlay, this.steamDisplay);
                this.updateFluidDisplay(this.steamDisplay);
                this.addFluidDisplay(overlay, this.waterDisplay);
                this.updateFluidDisplay(this.waterDisplay);
            } else {
                this.addEnergyBar(overlay);
                this.updateEnergyBar();
            }
            if (((BasicMachineScreenHandler)this.field_2797).blockEntity instanceof SteamEngineEntity) {
                this.addEnergyBar(overlay);
                this.updateEnergyBar();
            }
        }
        if (((BasicMachineScreenHandler)this.field_2797).screenData.showProgress()) {
            this.addProgressArrow(overlay);
            this.updateProgressBar();
        }
    }

    private void onOracleButtonClick(boolean enabled, Optional<class_2960> target) {
        if (!enabled || target.isEmpty()) {
            Oritech.LOGGER.info("Oracle Index mod is missing. Install it here: https://www.curseforge.com/minecraft/mc-mods/oracle-index (or from modrinth)");
            return;
        }
        OracleClient.openScreen((String)"oritech", (class_2960)target.get(), (class_437)this);
    }

    private Optional<class_2960> getHelpBookLink() {
        if (((BasicMachineScreenHandler)this.field_2797).screenData.getWikiLink().isPresent()) {
            return Optional.of(class_2960.method_60655((String)"oracle_index", (String)("books/oritech/" + ((BasicMachineScreenHandler)this.field_2797).screenData.getWikiLink().get() + ".mdx")));
        }
        class_1792 blockItem = ((BasicMachineScreenHandler)this.field_2797).machineBlock.method_26204().method_8389();
        class_2960 itemId = class_7923.field_41178.method_10221((Object)blockItem);
        if (OracleClient.ITEM_LINKS.containsKey(itemId)) {
            return Optional.of(((OracleClient.BookItemLink)OracleClient.ITEM_LINKS.get(itemId)).linkTarget());
        }
        return Optional.empty();
    }

    public boolean useHighTitle() {
        return ((BasicMachineScreenHandler)this.field_2797).machineBlock.method_26204().method_9518().toString().length() > 18;
    }

    private void addTitle(FlowLayout overlay) {
        class_5250 blockTitle = ((BasicMachineScreenHandler)this.field_2797).machineBlock.method_26204().method_9518();
        LabelComponent label = Components.label((class_2561)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.zIndex(1);
        ItemComponent blockIcon = Components.item((class_1799)this.getTitleIcon());
        blockIcon.sizing(Sizing.fixed((int)24));
        FlowLayout iconPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        iconPanel.padding(Insets.of((int)2, (int)5, (int)3, (int)3));
        iconPanel.child((Component)blockIcon);
        iconPanel.surface(ORITECH_PANEL);
        iconPanel.zIndex(50);
        FlowLayout textPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        textPanel.padding(Insets.of((int)5, (int)6, (int)6, (int)5));
        textPanel.child((Component)label);
        textPanel.surface(ORITECH_PANEL);
        FlowLayout combinedPanel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        combinedPanel.child((Component)iconPanel);
        combinedPanel.child((Component)textPanel.margins(Insets.of((int)4, (int)0, (int)-1, (int)0)));
        int horizontalPos = blockTitle.getString().length() > 15 ? 100 : 65;
        int verticalPos = this.useHighTitle() ? -25 : -15;
        overlay.child((Component)combinedPanel.positioning(Positioning.relative((int)horizontalPos, (int)verticalPos)));
        overlay.allowOverflow(true);
    }

    public class_1799 getTitleIcon() {
        return new class_1799((class_1935)((BasicMachineScreenHandler)this.field_2797).blockEntity.method_11010().method_26204());
    }

    private void addProgressArrow(FlowLayout panel) {
        ScreenProvider.ArrowConfiguration config = ((BasicMachineScreenHandler)this.field_2797).screenData.getIndicatorConfiguration();
        TextureComponent empty = Components.texture((class_2960)config.empty(), (int)0, (int)0, (int)config.width(), (int)config.height(), (int)config.width(), (int)config.height());
        this.progress_indicator = Components.texture((class_2960)config.full(), (int)0, (int)0, (int)config.width(), (int)config.height(), (int)config.width(), (int)config.height());
        panel.child((Component)empty.positioning(Positioning.absolute((int)config.x(), (int)config.y()))).child((Component)this.progress_indicator.positioning(Positioning.absolute((int)config.x(), (int)config.y())));
    }

    protected void addFluidDisplay(FlowLayout panel, FluidDisplay display) {
        panel.child((Component)display.background);
        panel.child((Component)display.fillOverlay);
        panel.child((Component)display.foreGround);
    }

    protected void updateFluidDisplay(FluidDisplay display) {
        float targetFill;
        ColoredSpriteComponent background = display.background;
        FluidApi.SingleSlotStorage container = display.storage;
        ScreenProvider.BarConfiguration config = display.config;
        if (!display.lastDrawnFluid.equals(container.getStack().getFluid())) {
            ParentComponent parent = background.parent();
            int targetIndex = parent.children().indexOf((Object)background);
            ColoredSpriteComponent newFluid = BasicMachineScreen.createFluidRenderer(container.getStack(), config);
            parent.removeChild((Component)background);
            ((FlowLayout)parent).child(targetIndex, (Component)newFluid);
            display.background = background = newFluid;
            display.lastDrawnFluid = container.getStack().getFluid();
        }
        float fill = 1.0f - (float)container.getStack().getAmount() / (float)container.getCapacity();
        display.lastFill = targetFill = LaserArmModel.lerp(display.lastFill, fill, 0.15f);
        display.fillOverlay.verticalSizing(Sizing.fixed((int)((int)((float)config.height() * targetFill * 0.98f))));
        class_5250 tooltipText = container.getStack().getAmount() > 0L ? class_2561.method_43469((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{container.getStack().getAmount() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)container.getStack()).getString()}) : class_2561.method_43471((String)"tooltip.oritech.fluid_empty");
        background.tooltip((class_2561)tooltipText);
    }

    public static ColoredSpriteComponent createFluidRenderer(FluidStack stack, ScreenProvider.BarConfiguration config) {
        class_1058 sprite = FluidStackHooks.getStillTexture((FluidStack)stack);
        int spriteColor = FluidStackHooks.getColor((FluidStack)stack);
        Color parsedColor = Color.ofArgb((int)spriteColor);
        Color opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1.0f);
        spriteColor = opaqueColor.argb();
        return BasicMachineScreen.getColoredSpriteComponent(stack, config, sprite, spriteColor);
    }

    @NotNull
    private static ColoredSpriteComponent getColoredSpriteComponent(FluidStack stack, ScreenProvider.BarConfiguration config, class_1058 sprite, int spriteColor) {
        class_5250 tooltipText = stack.getAmount() > 0L ? class_2561.method_43469((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{stack.getAmount() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)stack).toString()}) : class_2561.method_43471((String)"tooltip.oritech.fluid_empty");
        ColoredSpriteComponent result = new ColoredSpriteComponent(sprite);
        result.widthMultiplier = (float)config.width() / 60.0f;
        result.color = Color.ofArgb((int)spriteColor);
        result.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        result.positioning(Positioning.absolute((int)config.x(), (int)config.y()));
        result.tooltip((class_2561)tooltipText);
        return result;
    }

    private void addEnergyBar(FlowLayout panel) {
        ScreenProvider.BarConfiguration config = ((BasicMachineScreenHandler)this.field_2797).screenData.getEnergyConfiguration();
        int insetSize = 1;
        class_5250 tooltipText = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{0, 50});
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(config.width() + insetSize * 2)), (Sizing)Sizing.fixed((int)(config.height() + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        frame.positioning(Positioning.absolute((int)(config.x() - insetSize), (int)(config.y() - insetSize)));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((class_2960)this.getGuiComponents(), (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator = Components.texture((class_2960)this.getGuiComponents(), (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((class_2561)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    protected static final class FluidDisplay {
        private final BoxComponent fillOverlay;
        private float lastFill;
        private class_3611 lastDrawnFluid;
        protected ColoredSpriteComponent background;
        private final TextureComponent foreGround;
        private final ScreenProvider.BarConfiguration config;
        private final FluidApi.SingleSlotStorage storage;

        private FluidDisplay(BoxComponent fillOverlay, float lastFill, class_3611 lastDrawnFluid, ColoredSpriteComponent background, TextureComponent foreGround, ScreenProvider.BarConfiguration config, FluidApi.SingleSlotStorage storage) {
            this.fillOverlay = fillOverlay;
            this.lastFill = lastFill;
            this.lastDrawnFluid = lastDrawnFluid;
            this.background = background;
            this.foreGround = foreGround;
            this.config = config;
            this.storage = storage;
        }
    }

    public static class ColoredSpriteComponent
    extends SpriteComponent {
        public Color color;
        public float widthMultiplier = 1.0f;

        protected ColoredSpriteComponent(class_1058 sprite) {
            super(sprite);
        }

        public class_1058 getSprite() {
            return this.sprite;
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (this.sprite == null) {
                return;
            }
            SpriteUtilInvoker.markSpriteActive((class_1058)this.sprite);
            this.drawSprite(this.x, this.y, 0, this.width, this.height, this.sprite, this.color.red(), this.color.green(), this.color.blue(), this.color.alpha(), context.method_51448());
        }

        public void drawSprite(int x, int y, int z, int width, int height, class_1058 sprite, float red, float green, float blue, float alpha, class_4587 matrices) {
            float uvWidth = sprite.method_4577() - sprite.method_4594();
            float newMax = sprite.method_4594() + uvWidth * this.widthMultiplier;
            this.drawTexturedQuad(sprite.method_45852(), matrices, x, x + width, y, y + height, z, sprite.method_4594(), newMax, sprite.method_4593(), sprite.method_4575(), red, green, blue, alpha);
        }

        private void drawTexturedQuad(class_2960 texture, class_4587 matrices, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha) {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.enableBlend();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22913(u1, v2).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22913(u2, v1).method_22915(red, green, blue, alpha);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderSystem.disableBlend();
        }
    }
}

