/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.cablesurfer;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.client.cablesurfer.CableMath;

public class ClientCableFinder {
    private static final boolean DEBUG_DRAW = false;
    private static final int POLE_SEARCH_RADIUS = 196;

    public static CableHit findLookedAtCable(class_1657 player, float reachDistance) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        class_243 eyePos = player.method_5836(1.0f);
        class_243 lookDir = player.method_5828(1.0f).method_1029();
        class_2338 minPos = class_2338.method_49638((class_2374)eyePos.method_1031(-196.0, -196.0, -196.0));
        class_2338 maxPos = class_2338.method_49638((class_2374)eyePos.method_1031(196.0, 196.0, 196.0));
        ArrayList<PowerPoleEntity> nearbyPoles = new ArrayList<PowerPoleEntity>();
        for (int cx = minPos.method_10263() >> 4; cx <= maxPos.method_10263() >> 4; ++cx) {
            for (int cz = minPos.method_10260() >> 4; cz <= maxPos.method_10260() >> 4; ++cz) {
                if (!level.method_8393(cx, cz)) continue;
                for (class_2586 be : level.method_8497(cx, cz).method_12214().values()) {
                    PowerPoleEntity pole;
                    if (!(be instanceof PowerPoleEntity) || !(player.method_5707(class_243.method_24953((class_2382)(pole = (PowerPoleEntity)be).method_11016())) < 38416.0)) continue;
                    nearbyPoles.add(pole);
                }
            }
        }
        double bestDistSq = Double.MAX_VALUE;
        CableHit bestHit = null;
        class_243 debugHitPos = null;
        for (PowerPoleEntity startPole : nearbyPoles) {
            class_2338 startPos = startPole.method_11016();
            class_243 startCenter = class_243.method_24953((class_2382)startPos);
            class_2350 startFacing = startPole.getFacingForMultiblock();
            class_243 startSideVec = class_243.method_24954((class_2382)startFacing.method_10163());
            for (PowerPoleEntity.ConnectionTarget target : startPole.getConnections()) {
                RayResult result2;
                class_243 cable2End;
                class_243 cable2Start;
                class_243 cable1End;
                class_243 cable1Start;
                double distCross;
                class_2338 endPos = target.pos();
                class_243 endCenter = class_243.method_24953((class_2382)endPos);
                class_2350 endFacing = target.facing();
                class_243 endSideVec = class_243.method_24954((class_2382)endFacing.method_10163());
                if (!ClientCableFinder.isPlayerNearCableBounds(player, startCenter, endCenter, reachDistance)) continue;
                class_243 startWorldA = startCenter.method_1019(startSideVec);
                class_243 startWorldB = startCenter.method_1020(startSideVec);
                class_243 targetWorldA = endCenter.method_1019(endSideVec);
                class_243 targetWorldB = endCenter.method_1020(endSideVec);
                double distDirect = startWorldA.method_1025(targetWorldA) + startWorldB.method_1025(targetWorldB);
                if (distDirect < (distCross = startWorldA.method_1025(targetWorldB) + startWorldB.method_1025(targetWorldA))) {
                    cable1Start = startWorldA;
                    cable1End = targetWorldA;
                    cable2Start = startWorldB;
                    cable2End = targetWorldB;
                } else {
                    cable1Start = startWorldA;
                    cable1End = targetWorldB;
                    cable2Start = startWorldB;
                    cable2End = targetWorldA;
                }
                RayResult result1 = ClientCableFinder.raycastCable(cable1Start, cable1End, eyePos, lookDir, reachDistance, (class_1937)level);
                if (result1 != null && result1.distSq < bestDistSq) {
                    bestDistSq = result1.distSq;
                    bestHit = new CableHit(startPos, endPos, cable1Start, cable1End, cable2Start, cable2End);
                    debugHitPos = result1.hitPos;
                }
                if ((result2 = ClientCableFinder.raycastCable(cable2Start, cable2End, eyePos, lookDir, reachDistance, (class_1937)level)) == null || !(result2.distSq < bestDistSq)) continue;
                bestDistSq = result2.distSq;
                bestHit = new CableHit(startPos, endPos, cable2Start, cable2End, cable1Start, cable1End);
                debugHitPos = result2.hitPos;
            }
        }
        return bestHit;
    }

    private static boolean isPlayerNearCableBounds(class_1657 player, class_243 start, class_243 end, float reach) {
        double minX = Math.min(start.field_1352, end.field_1352) - (double)reach;
        double minY = Math.min(start.field_1351, end.field_1351) - (double)reach - 10.0;
        double minZ = Math.min(start.field_1350, end.field_1350) - (double)reach;
        double maxX = Math.max(start.field_1352, end.field_1352) + (double)reach;
        double maxY = Math.max(start.field_1351, end.field_1351) + (double)reach;
        double maxZ = Math.max(start.field_1350, end.field_1350) + (double)reach;
        class_243 p = player.method_19538();
        return p.field_1352 >= minX && p.field_1352 <= maxX && p.field_1351 >= minY && p.field_1351 <= maxY && p.field_1350 >= minZ && p.field_1350 <= maxZ;
    }

    private static RayResult raycastCable(class_243 p1, class_243 p2, class_243 eyePos, class_243 lookDir, float reach, class_1937 level) {
        double cableLength = p1.method_1022(p2);
        int segments = class_3532.method_15340((int)((int)cableLength), (int)8, (int)128);
        double hitRadius = 1.5;
        double hitRadiusSq = hitRadius * hitRadius;
        double reachSq = reach * reach;
        class_243 prevPoint = CableMath.getAt(p1, p2, 0.0f);
        RayResult bestLocal = null;
        double bestLocalDist = Double.MAX_VALUE;
        for (int i = 1; i <= segments; ++i) {
            double distToPlayer;
            float t = (float)i / (float)segments;
            class_243 nextPoint = CableMath.getAt(p1, p2, t);
            class_243 closestOnSeg = ClientCableFinder.getClosestPointOnSegment(prevPoint, nextPoint, eyePos, lookDir);
            if (ClientCableFinder.distSqPointToRay(closestOnSeg, eyePos, lookDir) < hitRadiusSq && (distToPlayer = eyePos.method_1025(closestOnSeg)) < reachSq && distToPlayer < bestLocalDist) {
                bestLocalDist = distToPlayer;
                bestLocal = new RayResult(distToPlayer, closestOnSeg);
            }
            prevPoint = nextPoint;
        }
        return bestLocal;
    }

    private static class_243 getClosestPointOnSegment(class_243 segA, class_243 segB, class_243 rayOrigin, class_243 rayDir) {
        class_243 u = rayDir;
        class_243 v = segB.method_1020(segA);
        class_243 w = rayOrigin.method_1020(segA);
        double a = u.method_1026(u);
        double b = u.method_1026(v);
        double c = v.method_1026(v);
        double d = u.method_1026(w);
        double e = v.method_1026(w);
        double D = a * c - b * b;
        double tc = D < 1.0E-8 ? (b > c ? d / b : e / c) : (a * e - b * d) / D;
        return segA.method_1019(v.method_1021(class_3532.method_15350((double)tc, (double)0.0, (double)1.0)));
    }

    private static double distSqPointToRay(class_243 point, class_243 rayOrigin, class_243 rayDir) {
        class_243 w = point.method_1020(rayOrigin);
        double proj = w.method_1026(rayDir);
        if (proj < 0.0) {
            proj = 0.0;
        }
        return point.method_1025(rayOrigin.method_1019(rayDir.method_1021(proj)));
    }

    private record RayResult(double distSq, class_243 hitPos) {
    }

    public record CableHit(class_2338 poleA, class_2338 poleB, class_243 selectedStart, class_243 selectedEnd, class_243 parallelStart, class_243 parallelEnd) {
    }
}

