/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3861;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class PoweredFurnaceBlockEntity
extends MultiblockMachineEntity {
    private final float FURNACE_SPEED_MULTIPLIER;

    public PoweredFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.POWERED_FURNACE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.furnaceData.energyPerTick());
        this.FURNACE_SPEED_MULTIPLIER = Oritech.CONFIG.processingMachines.furnaceData.speedMultiplier();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.furnaceData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.furnaceData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ASSEMBLER;
    }

    @Override
    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * this.getEfficiencyMultiplier() * (1.0f / this.getSpeedMultiplier()) / 2.0f;
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state)) {
            return;
        }
        Optional recipeCandidate = world.method_8433().method_8132(class_3956.field_17546, (class_9695)this.getFurnaceInput(), world);
        if (recipeCandidate.isPresent() && this.canAddToSlot(((class_3861)((class_8786)recipeCandidate.get()).comp_1933()).method_8110((class_7225.class_7874)world.method_30349()), (class_1799)this.inventory.heldStacks.get(1))) {
            if (this.hasEnoughEnergy()) {
                class_3861 activeRecipe = (class_3861)((class_8786)recipeCandidate.get()).comp_1933();
                this.useEnergy();
                ++this.progress;
                this.lastWorkedAt = world.method_8510();
                if ((double)world.field_9229.method_43057() > 0.8) {
                    ParticleContent.FURNACE_BURNING.spawn(world, class_243.method_24954((class_2382)pos), (Object)1);
                }
                if (this.furnaceCraftingFinished(activeRecipe)) {
                    this.craftFurnaceItem(activeRecipe);
                    for (int i = 0; i < this.getBaseAddonData().extraChambers() && this.canAddToSlot(((class_3861)((class_8786)recipeCandidate.get()).comp_1933()).method_8110((class_7225.class_7874)world.method_30349()), (class_1799)this.inventory.heldStacks.get(1)) && !((class_1799)this.inventory.heldStacks.get(0)).method_7960(); ++i) {
                        this.craftFurnaceItem(activeRecipe);
                    }
                    this.resetProgress();
                }
                this.method_5431();
            }
        } else if (this.progress > 0) {
            this.resetProgress();
        }
        this.addBurstTicks();
        if (world.method_8510() % 18L == 0L) {
            this.updateFurnaceState(state);
        }
    }

    private void updateFurnaceState(class_2680 state) {
        Boolean wasLit = (Boolean)state.method_11654((class_2769)class_2741.field_12548);
        boolean isLit = this.isActivelyWorking();
        if (wasLit != isLit) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(isLit)));
        }
    }

    private void craftFurnaceItem(class_3861 activeRecipe) {
        class_1799 result = activeRecipe.method_8110((class_7225.class_7874)this.field_11863.method_30349());
        class_1799 outSlot = (class_1799)this.inventory.heldStacks.get(1);
        class_1799 inSlot = (class_1799)this.inventory.heldStacks.get(0);
        inSlot.method_7934(1);
        if (outSlot.method_7960()) {
            this.inventory.heldStacks.set(1, (Object)result.method_7972());
        } else {
            outSlot.method_7933(result.method_7947());
        }
    }

    private boolean furnaceCraftingFinished(class_3861 activeRecipe) {
        return (float)this.progress >= (float)activeRecipe.method_8167() * this.getSpeedMultiplier();
    }

    private class_9696 getFurnaceInput() {
        return new class_9696(this.getInputView().get(0));
    }

    @Override
    public float getProgress() {
        if (this.progress == 0) {
            return 0.0f;
        }
        Optional recipeCandidate = Objects.requireNonNull(this.field_11863).method_8433().method_8132(class_3956.field_17546, (class_9695)this.getFurnaceInput(), this.field_11863);
        if (recipeCandidate.isPresent()) {
            return (float)this.progress / (float)this.getRecipeDuration();
        }
        return 0.0f;
    }

    @Override
    protected int getRecipeDuration() {
        Optional recipeCandidate = Objects.requireNonNull(this.field_11863).method_8433().method_8132(class_3956.field_17546, (class_9695)this.getFurnaceInput(), this.field_11863);
        if (recipeCandidate.isPresent()) {
            return (int)((float)((class_3861)((class_8786)recipeCandidate.get()).comp_1933()).method_8167() * this.getSpeedMultiplier());
        }
        return 120;
    }

    @Override
    public float getSpeedMultiplier() {
        return super.getSpeedMultiplier() * this.FURNACE_SPEED_MULTIPLIER;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 38, true));
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.POWERED_FURNACE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 1, 0));
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, -1, 0));
    }
}

