/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_8786;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class AtomicForgeBlockEntity
extends MultiblockMachineEntity {
    public AtomicForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ATOMIC_FORGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick());
    }

    @Override
    protected boolean canProceed(OritechRecipe value) {
        return this.hasEnoughEnergy() && super.canProceed(value);
    }

    @Override
    protected boolean hasEnoughEnergy() {
        return this.energyStorage.getCapacity() > 10L && this.energyStorage.getAmount() >= this.energyStorage.getCapacity();
    }

    @Override
    protected boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return this.progress > 0;
    }

    @Override
    protected void useEnergy() {
        this.energyStorage.amount = 0L;
    }

    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        Optional<class_8786<OritechRecipe>> result = super.getRecipe();
        if (result.isPresent()) {
            this.energyStorage.setCapacity((long)Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick() * (long)((OritechRecipe)result.get().comp_1933()).getTime());
        } else {
            this.energyStorage.setCapacity(1L);
            this.energyStorage.setAmount(0L);
        }
        return result;
    }

    @Override
    public void updateEnergyContainer() {
    }

    @Override
    public boolean canEnergyStorageChangeWhileGUIOpen() {
        return true;
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    @Override
    public float getProgress() {
        return (float)this.energyStorage.getAmount() / (float)this.energyStorage.getCapacity();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ATOMIC_FORGE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 3, 3, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 36), new ScreenProvider.GuiSlot(1, 74, 17), new ScreenProvider.GuiSlot(2, 74, 55), new ScreenProvider.GuiSlot(3, 117, 36, true));
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ATOMIC_FORGE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(1, 0, 1), new class_2382(1, 0, 0), new class_2382(1, 0, -1), new class_2382(0, 0, 1), new class_2382(0, 0, -1), new class_2382(-1, 0, 1), new class_2382(-1, 0, 0), new class_2382(-1, 0, -1));
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return new ArrayList<class_2382>();
    }

    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.energyStorage.getCapacity();
    }
}

