package rearth.oritech.util.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import rearth.oritech.Oritech;

import java.lang.reflect.Field;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface ArchitecturyRecipeRegistryContainer extends ArchitecturyRegistryContainer<class_3956<?>> {
    
    DeferredRegister<class_1865<?>> SERIALIZER_REGISTRY = DeferredRegister.create(Oritech.MOD_ID, class_7924.field_41216);
    
    @Override
    default class_5321<class_2378<class_3956<?>>> getRegistryType() {
        return class_7924.field_41217;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    default Class<class_3956<?>> getTargetFieldType() {
        return (Class<class_3956<?>>) (Object) class_3956.class;
    }
    
    @Override
    default void postProcessField(String namespace, class_3956<?> value, String identifier, Field field, RegistrySupplier<class_3956<?>> supplier) {
        ArchitecturyRegistryContainer.super.postProcessField(namespace, value, identifier, field, supplier);
        SERIALIZER_REGISTRY.register(identifier, () -> (class_1865<?>) value);
    }
    
    static void finishSerializerRegister() {
        SERIALIZER_REGISTRY.register();
    }
    
}
