package rearth.oritech.util;

import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class TooltipHelper {
    
    public static String getEnergyText(long amount) {
        if (amount < 1000) {
            return String.valueOf(amount);
        } else if (amount < 1_000_000) {
            return getFormatted(amount / 1_000.0) + class_1074.method_4662("tooltip.oritech.thousand_abbrev");
        } else if (amount < 1_000_000_000) {
            return getFormatted(amount / 1_000_000.0) + class_1074.method_4662("tooltip.oritech.million_abbrev");
        } else if (amount < 1_000_000_000_000L)  {
            return getFormatted(amount / 1_000_000_000.0) + class_1074.method_4662("tooltip.oritech.billion_abbrev");
        } else {
            return getFormatted(amount / 1_000_000_000_000.0) + class_1074.method_4662("tooltip.oritech.trillion_abbrev");
        }
    }
    
    private static String getFormatted(double number) {
        var formatter = NumberFormat.getNumberInstance(Locale.ROOT);
        formatter.setMinimumFractionDigits(0);
        formatter.setMaximumFractionDigits(2);
        return formatter.format(number);
    }
    
    public static void addMachineTooltip(List<class_2561> tooltip, class_2248 block, class_2343 entityProvider) {
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            var entity = entityProvider.method_10123(class_2338.field_10980, block.method_9564());
            
            var isAtomicForge = entity instanceof AtomicForgeBlockEntity;
            
            if (entity instanceof MultiblockMachineController multiblockController) {
                var corePositions = multiblockController.getCorePositions();
                tooltip.add(class_2561.method_43471("tooltip.oritech.core_desc").method_27692(class_124.field_1080).method_10852(class_2561.method_43470(String.valueOf(corePositions.size())).method_27692(class_124.field_1065)));
            }
            if (entity instanceof FrameInteractionBlockEntity) {
                tooltip.add(class_2561.method_43471("tooltip.oritech.frame_needed").method_27692(class_124.field_1080));
            }
            if (entity instanceof MachineAddonController addonProvider) {
                var addonSlots = addonProvider.getAddonSlots();
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_desc").method_27692(class_124.field_1080).method_10852(class_2561.method_43470(String.valueOf(addonSlots.size())).method_27692(class_124.field_1065)));
            }
            if (entity instanceof MachineBlockEntity machineEntity && machineEntity.getEnergyPerTick() > 1 && !isAtomicForge) {
                var energyRate = machineEntity.getEnergyPerTick();
                if (entity instanceof UpgradableGeneratorBlockEntity) {
                    tooltip.add(class_2561.method_43471("tooltip.oritech.generator_rate_desc").method_27692(class_124.field_1080).method_10852(class_2561.method_43469("tooltip.oritech.energy_transfer_rate", energyRate).method_27692(class_124.field_1065)));
                } else if (entity instanceof MachineBlockEntity) {
                    tooltip.add(class_2561.method_43471("tooltip.oritech.machine_rate_desc").method_27692(class_124.field_1080).method_10852(class_2561.method_43469("tooltip.oritech.energy_transfer_rate", energyRate).method_27692(class_124.field_1065)));
                }
            } else if (entity instanceof ExpandableEnergyStorageBlockEntity energyStorage) {
                var transferRate = energyStorage.getDefaultExtractionRate();
                tooltip.add(class_2561.method_43471("tooltip.oritech.energy_max_transfer").method_27692(class_124.field_1080).method_10852(class_2561.method_43469("tooltip.oritech.energy_transfer_rate", transferRate).method_27692(class_124.field_1065)));
            }
            
            
            if (entity instanceof EnergyApi.BlockProvider energyProvider) {
                var maxStorage = getEnergyText(energyProvider.getEnergyStorage(null).getCapacity());
                if (!isAtomicForge)
                    tooltip.add(class_2561.method_43471("tooltip.oritech.machine_capacity_desc").method_27692(class_124.field_1080).method_10852(class_2561.method_43469("tooltip.oritech.energy_capacity", maxStorage).method_27692(class_124.field_1065)));
                
                if (isAtomicForge || energyProvider instanceof DeepDrillEntity)
                    tooltip.add(class_2561.method_43471("tooltip.oritech.needs_laser_power").method_27692(class_124.field_1067));
                
                var id = class_7923.field_41175.method_10221(block);
                if (class_1074.method_4663("tooltip.oritech." + id.method_12832() + ".extra")) {
                    tooltip.add(class_2561.method_43471("tooltip.oritech." + id.method_12832() + ".extra").method_27692(class_124.field_1080));
                }
            }
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }
    
    public static class_2561 getFormattedEnergyChangeTooltip(long amount, String unit) {
        var formatted = getEnergyText(amount);
        var text = amount > 0 ? "+" + formatted : formatted;
        return class_2561.method_43470(text).method_27692(class_124.field_1065).method_27693(unit).method_27692(class_124.field_1065);
    }
    
    public static class_2561 getFormattedValueChangeTooltip(int amount) {
        var text = amount > 0 ? "+" + amount : String.valueOf(amount);
        var color = amount > 0 ? class_124.field_1060 : class_124.field_1061;
        return class_2561.method_43470(text).method_27692(color).method_27693("%").method_27692(color);
    }
    
}
