package rearth.oritech.item.tools.harvesting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class PromethiumPickaxeItem extends class_1766 implements GeoItem {
    
    private static final RawAnimation AREA_ANIM = RawAnimation.begin().thenLoop("area");
    private static final RawAnimation SILK_ANIM = RawAnimation.begin().thenLoop("silk_touch");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    
    public PromethiumPickaxeItem(class_1832 toolMaterial, class_6862<class_2248> effectiveBlocks, class_1793 settings) {
        super(toolMaterial, effectiveBlocks, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }
    
    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
    
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }
    
    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && stack.method_57826(class_9334.field_49642)) {
            var enchantments = stack.method_58657();
            var builder = new class_9304.class_9305(enchantments);
            builder.method_57548(elem -> elem.method_40225(class_1893.field_9099));
            stack.method_57379(class_9334.field_49633, builder.method_57549());
            stack.method_57381(class_9334.field_49642);
        }
        
        return true;
    }
    
    private static boolean isAreaEnabled(class_1799 stack) {
        return stack.method_57825(ComponentContent.IS_AOE_ACTIVE.get(), false);
    }
    
    private static void setAreaEnabled(class_1799 stack, boolean enabled) {
        stack.method_57379(ComponentContent.IS_AOE_ACTIVE.get(), enabled);
    }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        
        if (!world.field_9236 && user.method_5715()) {
            var stack = user.method_5998(hand);
            
            var wasArea = isAreaEnabled(stack);
            var isArea = !wasArea;
            setAreaEnabled(stack, isArea);
            
            user.method_43496(isArea ? class_2561.method_43471("message.oritech.tool_mode.area_effect") : class_2561.method_43471("message.oritech.tool_mode.silk_touch"));
        }
        
        return super.method_7836(world, user, hand);
    }
    
    public static List<class_2338> getOffsetBlocks(class_1937 world, class_1657 player, class_2338 pos) {
        var handStack = player.method_6047();
        if (handStack == null || !handStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) return List.of();
        
        if (isAreaEnabled(handStack) && !player.method_5715()) {
            var breakBlocks = new ArrayList<class_2338>();
            var playerHit = player.method_5745(player.method_55754(), 0.0F, false);
            if (playerHit instanceof class_3965 blockHit) {
                var blockSide = blockHit.method_17780();
                var perpA = class_2350.field_11034;
                var perpB = class_2350.field_11043;
                
                if (blockSide.equals(class_2350.field_11043) || blockSide.equals(class_2350.field_11035)) {
                    perpA = class_2350.field_11036;
                    perpB = class_2350.field_11034;
                } else if (blockSide.equals(class_2350.field_11034) || blockSide.equals(class_2350.field_11039)) {
                    perpA = class_2350.field_11036;
                    perpB = class_2350.field_11043;
                }
                
                for (int x = -1; x <= 1; x++) {
                    for (int z = -1; z <= 1; z++) {
                        if (x == 0 && z == 0) continue;
                        var neighborPos = pos.method_10081(perpA.method_10163().method_35862(x)).method_10081(perpB.method_10163().method_35862(z));
                        breakBlocks.add(neighborPos);
                    }
                }
                
                return ImmutableList.copyOf(Iterables.filter(breakBlocks, p -> world.method_8320(p).method_26164(TagContent.DRILL_MINEABLE)));
            }
        }
        
        return List.of();
    }
    
    // called as event in Oritech initializer
    // area mode: breaks 3x3 blocks unless player is sneaking
    // silk touch mode: adds a temporary silk touch, which is then removed in the after break event
    public static EventResult preMine(class_1937 world, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        
        var handStack = player.method_6047();
        if (handStack == null || !handStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) return EventResult.pass();
        
        // break additional blocks in preMine (Block.onBreak) instead of postMine (Block.onBroken)
        // so that the block still exists when determining which face of the block the player was looking at
        if (isAreaEnabled(handStack)) {
            // break additional blocks
            for (var offsetPos : getOffsetBlocks(world, player, pos)) {
                // drop stacks before breaking additional block, because world.breakBlock doesn't apply item enchantments if drop is enabled
                // this will ONLY apply item enchantments that affect block drops, and will not apply enchants like vein mining
                var offsetState = world.method_8320(offsetPos);
                var offsetEntity = world.method_8321(offsetPos);
                class_2248.method_9511(offsetState, world, offsetPos, offsetEntity, player, handStack);
                offsetState.method_26204().method_9576(world, offsetPos, offsetState, player);
                world.method_8651(offsetPos, false, player);
            }
        } else {
            // do silk touch
            var hasExistingSilkTouch = class_1890.method_57532(handStack).method_57534().stream().anyMatch(elem -> elem.method_40225(class_1893.field_9099));
            
            if (!hasExistingSilkTouch) {
                var registryEntry = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).get();
                handStack.method_7978(registryEntry, 1);
                handStack.method_57379(class_9334.field_49642, class_3902.field_17274);
            }
        }
        
        return EventResult.pass();
    }
    
    public static class_9285 createPromethiumAttributes(class_1832 tier, float attackDamage, float attackSpeed, float range) {
        return class_9285.method_57480()
                 .method_57487(
                   class_5134.field_23721,
                   new class_1322(field_8006, attackDamage + tier.method_8028(), class_1322.class_1323.field_6328),
                   class_9274.field_49217
                 )
                 .method_57487(
                   class_5134.field_23723,
                   new class_1322(field_8001, attackSpeed, class_1322.class_1323.field_6328),
                   class_9274.field_49217
                 )
                 .method_57487(
                   class_5134.field_47758,
                   new class_1322(Oritech.id("pick_block_range"), range, class_1322.class_1323.field_6328),
                   class_9274.field_49217)
                 .method_57487(
                   class_5134.field_47759,
                   new class_1322(Oritech.id("pick_entity_range"), range, class_1322.class_1323.field_6328),
                   class_9274.field_49217)
                 .method_57486();
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        
        var area = isAreaEnabled(stack);
        
        tooltip.add((area ? class_2561.method_43471("tooltip.oritech.tool_mode.area_range.area") : class_2561.method_43471("tooltip.oritech.tool_mode.area_range.single")).method_27692(class_124.field_1065));
        tooltip.add(class_2561.method_43471("tooltip.oritech.promethium_pick").method_27692(class_124.field_1063));
        
    }
    
    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider() {
            private PromethiumToolRenderer renderer;
            
            @Override
            public @Nullable class_756 getGeoItemRenderer() {
                if (this.renderer == null)
                    this.renderer = new PromethiumToolRenderer("promethium_pickaxe");
                return renderer;
            }
        });
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "Pickaxe", 5, state -> PlayState.CONTINUE).triggerableAnim("silk", SILK_ANIM).triggerableAnim("area", AREA_ANIM));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
    
    // client only
    public void onHeldTick(class_1799 stack, class_1657 player, class_638 world) {
        
        if (world.method_8510() % 20 != 0) return;
        
        var area = isAreaEnabled(stack);
        triggerAnim(player, GeoItem.getId(stack), "Pickaxe", area ? "area" : "silk");
        
    }
}