package rearth.oritech.item.other;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.MultiblockMachineController;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ColorCartridgeItem extends class_1792 {
    
    public final ColorableMachine.ColorVariant variant;
    
    public ColorCartridgeItem(class_1793 properties, ColorableMachine.ColorVariant variant) {
        super(properties);
        this.variant = variant;
    }
    
    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        
        tooltipComponents.add(class_2561.method_43471("tooltip.oritech.paint.1").method_27695(class_124.field_1080, class_124.field_1056));
        tooltipComponents.add(class_2561.method_43471("tooltip.oritech.paint.2").method_27695(class_124.field_1080, class_124.field_1056));
        
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }
    
    @Override
    public @NotNull class_1269 method_7884(class_1838 context) {
        
        if (context.method_8045().method_8608())
            return super.method_7884(context);
        
        var targetBlock = context.method_8037();
        var targetEntity = context.method_8045().method_8321(targetBlock);
        
        if (targetEntity instanceof MachineCoreEntity machineCore && machineCore.getCachedController() != null) {
            targetEntity = (net.minecraft.class_2586) machineCore.getCachedController();
            targetBlock = targetEntity.method_11016();
        }
        
        if (targetEntity instanceof ColorableMachine colorableMachine) {
            
            if (colorableMachine.getCurrentColor().equals(variant)) return super.method_7884(context);
            
            Oritech.LOGGER.info("assigning color {} to {}", variant, targetBlock);
            colorableMachine.assignColor(variant);
            
            var stack = context.method_8041();
            stack.method_7934(1);
            
            context.method_8036().method_6122(context.method_20287(), stack);
            
            context.method_8045().method_8396(null, targetBlock, class_3417.field_28292, class_3419.field_15248, 1f, 0.6f);
            
            // create particles
            var targetBlocks = new ArrayList<class_2338>();
            targetBlocks.add(targetBlock);
            
            if (targetEntity instanceof MultiblockMachineController multiblockMachineController) {
                targetBlocks.addAll(multiblockMachineController.getConnectedCores());
            }
            
            var level = context.method_8045();
            if (context.method_8045() instanceof class_3218 serverLevel) {
                for (var pos : targetBlocks) {
                    var at = pos.method_46558().method_1031(level.field_9229.method_43057() * 0.1, level.field_9229.method_43057() * 0.1, level.field_9229.method_43057() * 0.1);
                    serverLevel.method_14199(class_2398.field_47494, at.field_1352, at.field_1351, at.field_1350, 1, level.field_9229.method_43057(), level.field_9229.method_43057(), level.field_9229.method_43057(), 0.15f);
                }
            }
            
            return class_1269.field_5812;
        }
        
        return super.method_7884(context);
    }
}
