package rearth.oritech.client.ui;

import rearth.oritech.Oritech;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.MachineAddonController;

import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class UpgradableMachineScreenHandler extends BasicMachineScreenHandler {
    
    protected final class_1937 worldAccess;
    protected final MachineAddonController addonController;
    
    public UpgradableMachineScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(buf.method_10811())));
    }
    
    // on server, also called from client constructor
    public UpgradableMachineScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(syncId, playerInventory, blockEntity);
        
        // sync speed and efficiency to client entity, so the getProgress method works correctly
        if (blockEntity instanceof MachineAddonController upgradableEntity) {
            addonController = upgradableEntity;
        } else {
            Oritech.LOGGER.debug("Creating Upgrade screen for non-upgradable block: {}", blockEntity);
            addonController = null;
        }
        
        this.worldAccess = playerInventory.field_7546.method_37908();
    }
    
    @Override
    public boolean showRedstoneAddon() {
        return super.showRedstoneAddon() ||
                 addonController.getConnectedAddons().stream().anyMatch(addonPos -> this.worldAccess.method_8320(addonPos).method_26204().equals(BlockContent.MACHINE_REDSTONE_ADDON));
    }
}
