package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.*;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.util.SizedIngredient;
import rearth.oritech.util.TooltipHelper;

import java.util.*;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_5684;
import net.minecraft.class_7923;

import static rearth.oritech.client.ui.BasicMachineScreen.*;

public class PlayerModifierScreen extends BaseOwoHandledScreen<FlowLayout, PlayerModifierScreenHandler> {
    
    private static DraggableScrollContainer<FlowLayout> main;
    private static FlowLayout root;
    private static final HashMap<String, class_3545<Vector2i, Vector2i>> dependencyLines = new HashMap<>();
    private static final HashMap<class_2960, AugmentUiState> shownAugments = new HashMap<>();
    private final Set<BoxComponent> highlighters = new HashSet<>();
    private final List<LabelComponent> researchLabels = new ArrayList<>();
    private final int backgroundAugmentFrameSize = 32;
    private final int augmentIconSize = 24;
    
    private static final float panelHeight = 0.8f;
    private TextureComponent energyIndicator;
    
    public PlayerModifierScreen(PlayerModifierScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, CustomFlowRootContainer::verticalFlow);
    }
    
    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent
          .surface(Surface.VANILLA_TRANSLUCENT)
          .horizontalAlignment(HorizontalAlignment.CENTER)
          .verticalAlignment(VerticalAlignment.CENTER);
        
        root = rootComponent;
        
        if (field_2797.blockEntity == null) {
            this.method_25419();
            return;
        }
        
        dependencyLines.clear();
        shownAugments.clear();
        
        var outerContainer = Containers.horizontalFlow(Sizing.fill(60), Sizing.fill((int) (panelHeight * 100)));
        outerContainer.surface(ORITECH_PANEL);
        
        var movedPanel = Containers.horizontalFlow(Sizing.fixed(900), Sizing.fill());
        movedPanel.surface(Surface.tiled(Oritech.id("textures/block/machine_plating_block/empty.png"), 16, 16));
        movedPanel.margins(Insets.of(2));
        
        var innerContainer = new DraggableScrollContainer<>(ScrollContainer.ScrollDirection.HORIZONTAL, Sizing.fill(), Sizing.fill(), movedPanel);
        innerContainer.scrollbar(ScrollContainer.Scrollbar.vanillaFlat());
        innerContainer.surface(Surface.PANEL_INSET);
        innerContainer.margins(Insets.of(6));
        main = innerContainer;
        
        rootComponent.child(outerContainer.positioning(Positioning.relative(50, 50)));
        outerContainer.child(innerContainer);
        
        addAvailableAugments(movedPanel);
        
        var researchWidth = 120;
        var researchContainer = Containers.verticalFlow(Sizing.fixed(researchWidth), Sizing.content());
        researchContainer.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        
        addResearchPanels(researchContainer, researchWidth);
        
        var energyPanel = Containers.verticalFlow(Sizing.content(3), Sizing.content(3));
        energyPanel.surface(ORITECH_PANEL);
        energyPanel.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        
        var loadResearchedAugments = Components.button(class_2561.method_43471("\uD83D\uDD2C"), elem -> onLoadAugmentsClick());
        loadResearchedAugments.tooltip(class_2561.method_43471("text.oritech.load_augments.tooltip"));
        loadResearchedAugments.margins(Insets.of(2));
        loadResearchedAugments.renderer(ORITECH_BUTTON);
        
        var openInvScreen = Components.button(class_2561.method_43471("\uD83E\uDDF0"), elem -> onOpenInvClicked());
        openInvScreen.tooltip(class_2561.method_43471("text.oritech.open_inv.tooltip"));
        openInvScreen.margins(Insets.of(2));
        openInvScreen.renderer(ORITECH_BUTTON);
        
        var energyPanelX = this.field_22789 * 0.2 - 22;
        var energyPanelY = this.field_22790 * 0.3;
        
        var researchPanelX = this.field_22789 * 0.8 - 2;
        var researchPanelY = this.field_22790 * 0.2;
        
        addEnergyBar(energyPanel);
        energyPanel.child(loadResearchedAugments.horizontalSizing(Sizing.fixed(18)));
        energyPanel.child(openInvScreen.horizontalSizing(Sizing.fixed(18)));
        
        root.child(energyPanel.positioning(Positioning.absolute((int) energyPanelX, (int) energyPanelY)).zIndex(-1));
        root.child(researchContainer.positioning(Positioning.absolute((int) researchPanelX, (int) researchPanelY)).zIndex(-1));
        
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        if (field_2797.blockEntity == null) return;
        
        // update research panels
        for (int i = 0; i < 3; i++) {
            if (i >= researchLabels.size()) continue;
            var panelData = researchLabels.get(i);
            var researchData = this.field_2797.blockEntity.availableStations.get(i);
            if (researchData == null || panelData == null) continue;
            
            var baseKey = class_2561.method_43470("");
            var time = this.field_2797.blockEntity.method_10997().method_8510();
            
            var isIdle = !researchData.working;
            if (isIdle) {
                var ticks = time % 20 / 7;
                baseKey = class_2561.method_43471("text.oritech.accelerator.ui.waiting." + ticks);
            } else {
                var remainingTicks = researchData.researchStartedAt + researchData.workTime - time;
                var remainingSeconds = (int) (remainingTicks / 20f);
                baseKey = class_2561.method_43469("text.oritech.augmenter_active", remainingSeconds);
            }
            
            panelData.text(baseKey);
            
        }
        
        
        for (var entry : shownAugments.entrySet()) {
            var augmentId = entry.getKey();
            var augmentState = entry.getValue();
            var augmentRecipe = (AugmentDataRecipe) this.field_2797.player.method_37908().method_8433().method_8130(augmentId).get().comp_1933();
            
            var isResearched = this.field_2797.blockEntity.researchedAugments.contains(augmentId);
            var isResearching = this.field_2797.blockEntity.availableStations.values().stream().filter(Objects::nonNull).anyMatch(station -> station.selectedResearch.equals(augmentId));
            var isApplied = this.field_2797.blockEntity.hasPlayerAugment(augmentId, this.field_2797.player);
            
            var hasRequirements = true;
            var missingRequirements = new ArrayList<class_2561>();
            missingRequirements.add(class_2561.method_43471(augmentKey(augmentId).formatted(class_124.field_1067)));
            missingRequirements.add(class_2561.method_43471("oritech.text.missing_requirements_title"));
            for (var requirementId : augmentRecipe.getRequirements()) {
                if (!this.field_2797.blockEntity.researchedAugments.contains(requirementId)) {
                    hasRequirements = false;
                    missingRequirements.add(class_2561.method_43471(augmentKey(requirementId)).method_27695(class_124.field_1056, class_124.field_1061));
                } else {
                    missingRequirements.add(class_2561.method_43471(augmentKey(requirementId)).method_27695(class_124.field_1056, class_124.field_1077));
                }
            }
            
            var hasResearchStation = false;
            var requiredStationBlock = class_7923.field_41175.method_10223(augmentRecipe.getRequiredStation());
            
            for (var ownStation : this.field_2797.blockEntity.availableStations.values()) {
                if (ownStation == null) continue;
                if (ownStation.type.equals(requiredStationBlock)) {
                    hasResearchStation = true;
                    break;
                }
            }
            
            if (!hasResearchStation) {
                missingRequirements.add(class_2561.method_43469("oritech.text.required_station", requiredStationBlock.method_9518()));
                hasRequirements = false;
            }
            
            var operation = PlayerAugments.AugmentApplicatorOperation.RESEARCH;
            var tooltipTitleText = class_2561.method_43471(augmentKey(augmentId)).method_27692(class_124.field_1067);
            var tooltipOperation = "oritech.text.augment_op.research";
            var tooltipDesc = class_2561.method_43471(augmentKey(augmentId) + ".desc").method_27695(class_124.field_1056, class_124.field_1080);
            
            var extraTooltips = new ArrayList<class_2561>();
            for (int i = 1; i < 8; i++) {
                var key = augmentKey(augmentId) + ".desc." + i;
                if (class_1074.method_4663(key))
                    extraTooltips.add(class_2561.method_43471(key).method_27695(class_124.field_1056, class_124.field_1080));
            }
            
            if (isApplied) {
                operation = PlayerAugments.AugmentApplicatorOperation.REMOVE;
                tooltipOperation = "oritech.text.augment_op.remove";
            } else if (isResearched) {
                operation = PlayerAugments.AugmentApplicatorOperation.ADD;
                tooltipOperation = "oritech.text.augment_op.apply";
            } else if (isResearching) {
                operation = PlayerAugments.AugmentApplicatorOperation.NONE;
                tooltipOperation = "oritech.text.augment_op.pending";
            }
            
            tooltipTitleText = class_2561.method_43471(tooltipOperation).method_10852(tooltipTitleText);
            
            var lastOp = augmentState.openOp;
            if (operation != lastOp) {
                
                var collectedTooltip = new ArrayList<class_5684>();
                Stream.of(tooltipTitleText, tooltipDesc)
                  .map(elem -> class_5684.method_32662(elem.method_30937()))
                  .forEach(collectedTooltip::add);
                
                extraTooltips.stream().map(elem -> class_5684.method_32662(elem.method_30937())).forEach(collectedTooltip::add);
                
                var backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
                
                if (isApplied) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_installed.png");
                } else if (isResearched) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_completed.png");
                } else if (isResearching) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_pending.png");
                } else {
                    // collect requirements / cost
                    var inputs = augmentRecipe.getResearchCost();
                    var time = augmentRecipe.getTime() / 20;
                    
                    collectedTooltip.add(class_5684.method_32662(class_2561.method_43469("oritech.text.augment_research_time", time).method_30937()));
                    var inputsComponent = new SizedIngredientTooltipComponent(inputs);
                    collectedTooltip.add(inputsComponent);
                }
                
                augmentState.icon.tooltip(collectedTooltip);
                
                var scrollPanel = (DraggableScrollContainer<?>) augmentState.parent.parent();
                var scrollOffset = (int) scrollPanel.getScrollPosition();
                
                var oldBackground = augmentState.background;
                var newBackground = Components.texture(backgroundTexture, 0, 0, 16, 16, 16, 16);
                newBackground.sizing(Sizing.fixed(backgroundAugmentFrameSize), Sizing.fixed(backgroundAugmentFrameSize));
                newBackground.positioning(Positioning.absolute(oldBackground.x() - augmentState.parent.x() - scrollOffset, oldBackground.y() - augmentState.parent.y()));
                augmentState.parent.removeChild(oldBackground);
                augmentState.parent.child(newBackground.zIndex(2));
                
                augmentState.openOp = operation;
                
            }
            
            if (!hasRequirements && augmentState.blocker == null) {
                
                var blocker = Components.box(Sizing.fixed(augmentIconSize), Sizing.fixed(augmentIconSize));
                blocker.color(new Color(0.3f, 0.4f, 0.4f, 0.8f));
                blocker.fill(true);
                blocker.positioning(Positioning.absolute(augmentState.icon.x() - augmentState.parent.x(), augmentState.icon.y() - augmentState.parent.y()));
                blocker.mouseDown().subscribe((a, b, c) -> true);
                blocker.zIndex(4);
                
                augmentState.parent.child(blocker);
                
                augmentState.blocker = blocker;
                
            } else if (hasRequirements && augmentState.blocker != null) {
                augmentState.parent.removeChild(augmentState.blocker);
                augmentState.blocker = null;
            }
            
            // update tooltip separately always
            if (!hasRequirements)
                augmentState.blocker.tooltip(missingRequirements);
            
        }
        
        // update energy bar
        updateEnergyBar();
        
    }
    
    @Override
    public void method_25394(class_332 vanillaContext, int mouseX, int mouseY, float delta) {
        
        for (var highlight : highlighters) {
            var isActive = highlight.isInBoundingBox(mouseX, mouseY);
            if (isActive) {
                highlight.color(new Color(0.7f, 0.7f, 0.7f, 1f));
            } else {
                highlight.color(new Color(0.7f, 0.7f, 0.7f, 0f));
            }
        }
        
        super.method_25394(vanillaContext, mouseX, mouseY, delta);
    }
    
    protected void updateEnergyBar() {
        
        var capacity = field_2797.blockEntity.getEnergyStorageForMultiblock(null).getCapacity();
        var amount = field_2797.blockEntity.getEnergyStorageForMultiblock(null).getAmount();
        
        var fillAmount = (float) amount / capacity;
        var tooltipText = getEnergyTooltip(amount, capacity, 0, (int) AugmentApplicationEntity.maxEnergyTransfer);
        
        energyIndicator.tooltip(tooltipText);
        energyIndicator.visibleArea(PositionedRectangle.of(0, 96 - ((int) (96 * (fillAmount))), 24, (int) (96 * fillAmount)));
    }
    
    private void addResearchPanels(FlowLayout parent, int width) {
        
        for (int i = 0; i < 3; i++) {
            var researchState = this.field_2797.blockEntity.availableStations.getOrDefault(i, null);
            if (researchState == null) {
                researchLabels.add(null);
                continue;
            }
            
            var panel = Containers.verticalFlow(Sizing.fixed(width), Sizing.fixed((int) (width * 0.4)));
            var title = Components.label(researchState.type.method_9518().method_27692(class_124.field_1067));
            title.horizontalSizing(Sizing.fill());
            title.horizontalTextAlignment(HorizontalAlignment.CENTER);
            var status = Components.label(class_2561.method_43470(" "));
            
            panel.child(title);
            panel.child(status.margins(Insets.of(4, 2, 0, 0)));
            
            researchLabels.add(status);
            
            parent.child(panel.surface(ORITECH_PANEL).padding(Insets.of(6)).margins(Insets.of(0, 10, 0, 0)).zIndex(-1));
        }
        
    }
    
    private void addAvailableAugments(FlowLayout parent) {
        
        var maxHeight = this.field_22790 * 0.75f;
        var leftOffset = 20;
        
        for (var augmentId : PlayerAugments.allAugments.keySet()) {
            var augmentRecipe = (AugmentDataRecipe) this.field_2797.player.method_37908().method_8433().method_8130(augmentId).get().comp_1933();
            
            var position = new Vector2i(leftOffset + augmentRecipe.getUiX() * 4, (int) (augmentRecipe.getUiY() / 100f * maxHeight));
            
            var iconTexture = Oritech.id("textures/gui/" + augmentId.method_12832() + ".png");
            var backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
            
            final var augmentOpId = augmentId;
            
            var icon = Components.texture(iconTexture, 0, 0, 24, 24, 24, 24);
            icon.mouseDown().subscribe((a, b, c) -> {
                onAugmentClick(augmentOpId, shownAugments.get(augmentOpId).openOp, false);
                return true;
            });
            icon.sizing(Sizing.fixed(augmentIconSize), Sizing.fixed(augmentIconSize));
            icon.positioning(Positioning.absolute(position.x - augmentIconSize / 2, position.y - augmentIconSize / 2));
            
            var background = Components.texture(backgroundTexture, 0, 0, 16, 16, 16, 16);
            background.sizing(Sizing.fixed(backgroundAugmentFrameSize), Sizing.fixed(backgroundAugmentFrameSize));
            background.positioning(Positioning.absolute(position.x - backgroundAugmentFrameSize / 2, position.y - backgroundAugmentFrameSize / 2));
            
            var highlight = Components.box(Sizing.fixed(backgroundAugmentFrameSize + 2), Sizing.fixed(backgroundAugmentFrameSize + 2));
            highlight.color(new Color(0.7f, 0.7f, 0.7f, 1f));
            highlight.positioning(Positioning.absolute(position.x - backgroundAugmentFrameSize / 2 - 1, position.y - backgroundAugmentFrameSize / 2 - 1));
            
            for (var dependencyId : augmentRecipe.getRequirements()) {
                var dependencyRecipe = (AugmentDataRecipe) this.field_2797.player.method_37908().method_8433().method_8130(dependencyId).get().comp_1933();
                var dependencyPos = new Vector2i(leftOffset + dependencyRecipe.getUiX() * 4, (int) (dependencyRecipe.getUiY() / 100f * maxHeight));
                
                var depId = augmentId.method_12832() + "_" + dependencyId.method_12832();
                dependencyLines.put(depId, new class_3545<>(position, dependencyPos));
            }
            
            parent.child(highlight.zIndex(1));
            parent.child(background.zIndex(2));
            parent.child(icon.zIndex(3));
            
            highlighters.add(highlight);
            
            shownAugments.put(augmentId, new AugmentUiState(highlight, background, icon, null, PlayerAugments.AugmentApplicatorOperation.NEEDS_INIT, parent));
            
        }
        
    }
    
    private void onAugmentClick(class_2960 id, PlayerAugments.AugmentApplicatorOperation operation, boolean confirmed) {
        
        if (!confirmed) {
            showAugmentDialog(id, operation);
            return;
        }
        
        var operationId = operation.ordinal();
        NetworkManager.sendToServer(new PlayerAugments.AugmentInstallTriggerPacket(this.field_2797.blockPos, id, operationId));
    }
    
    private void onLoadAugmentsClick() {
        NetworkManager.sendToServer(new PlayerAugments.LoadPlayerAugmentsToMachinePacket(this.field_2797.blockPos));
        
        var loadedAugmentsCount = 0;
        for (var entry : PlayerAugments.allAugments.entrySet()) {
            var augment = entry.getValue();
            var isResearched = this.field_2797.blockEntity.researchedAugments.contains(entry.getKey());
            var isInstalled = augment.isInstalled(field_2797.player);
            
            if (isInstalled && !isResearched) {
                loadedAugmentsCount++;
            }
        }
        
        this.field_2797.player.method_43496(class_2561.method_43469("text.oritech.loaded_augments", loadedAugmentsCount));
        this.method_25419();
        
    }
    
    private void onOpenInvClicked() {
        this.method_25419();
        NetworkManager.sendToServer(new PlayerAugments.OpenAugmentScreenPacket(this.field_2797.blockPos));
        
    }
    
    private void showAugmentDialog(class_2960 id, PlayerAugments.AugmentApplicatorOperation operation) {
        
        var researchRecipe = (AugmentDataRecipe) this.field_2797.blockEntity.method_10997().method_8433().method_8130(id).get().comp_1933();
        
        var isCreative = this.field_2797.player.method_7337();
        var hasResources = true;
        var hasEnergy = true;
        
        var panel = Containers.verticalFlow(Sizing.fixed(310), Sizing.content(1));
        panel.padding(Insets.of(5));
        panel.surface(ORITECH_PANEL);
        panel.horizontalAlignment(HorizontalAlignment.CENTER);
        
        var descriptionPanel = Containers.verticalFlow(Sizing.fill(100), Sizing.content(3));
        descriptionPanel.surface(Surface.PANEL_INSET);
        descriptionPanel.padding(Insets.of(3, 0, 3, 3));
        descriptionPanel.margins(Insets.of(4));
        
        var overlay = Containers.overlay(panel);
        
        var titleLabel = Components.label(class_2561.method_43471(augmentKey(id)).method_27695(class_124.field_1067, class_124.field_1074));
        titleLabel.margins(Insets.of(3, 1, 0, 0));
        
        descriptionPanel.child(Components.label(class_2561.method_43471(augmentKey(id) + ".desc").method_27695(class_124.field_1056, class_124.field_1080)));
        for (int i = 1; i < 8; i++) {
            var key = augmentKey(id) + ".desc." + i;
            if (class_1074.method_4663(key))
                descriptionPanel.child(Components.label(class_2561.method_43471(key).method_27695(class_124.field_1056, class_124.field_1080)));
            
        }
        
        var requiredStationBlock = class_7923.field_41175.method_10223(researchRecipe.getRequiredStation());
        var requiredStationLabel = Components.label(class_2561.method_43469("oritech.text.required_station", requiredStationBlock.method_9518()));
        descriptionPanel.child(requiredStationLabel.margins(Insets.of(4, 2, 0, 0)));
        
        var hasRequiredStation = false;
        for (int i = 0; i < 3; i++) {
            var station = this.field_2797.blockEntity.availableStations.getOrDefault(i, null);
            if (station == null) continue;
            if (station.working) continue;
            if (!requiredStationBlock.equals(station.type)) continue;
            hasRequiredStation = true;
        }
        
        if (!operation.equals(PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            
            if (operation.equals(PlayerAugments.AugmentApplicatorOperation.RESEARCH)) {
                var rfCost = researchRecipe.getRfCost();
                var parsedCost = TooltipHelper.getEnergyText(rfCost);
                
                descriptionPanel.child(Components.label(class_2561.method_43469("oritech.text.augment_research_time", researchRecipe.getTime() / 20).method_27692(class_124.field_1068)).margins(Insets.of(4, 0, 0, 0)));
                descriptionPanel.child(Components.label(class_2561.method_43469("oritech.text.energy_cost", parsedCost).method_27692(class_124.field_1068)).margins(Insets.of(4, 0, 0, 0)));
                
                if (this.field_2797.blockEntity.getEnergyStorageForMultiblock(null).getAmount() < rfCost)
                    hasEnergy = false;
                
            }
            
            descriptionPanel.child(Components.label(class_2561.method_43471("oritech.text.augment_resource_cost").method_27692(class_124.field_1068)).margins(Insets.of(4, 0, 0, 0)));
            
            var itemContainer = Containers.horizontalFlow(Sizing.fill(100), Sizing.content(1));
            var shownCost = researchRecipe.getResearchCost();
            if (operation.equals(PlayerAugments.AugmentApplicatorOperation.ADD)) {
                shownCost = researchRecipe.getApplyCost();
            }
            
            for (var wantedInput : shownCost) {
                var type = wantedInput.ingredient();
                var count = wantedInput.count();
                var matchingIngredients = this.field_2797.blockEntity.inventory.heldStacks.stream().filter(type).mapToInt(class_1799::method_7947).sum();
                var playerMatchingIngredients = this.field_2797.player.method_31548().field_7547.stream().filter(type).mapToInt(class_1799::method_7947).sum();
                if (playerMatchingIngredients + matchingIngredients < count) {
                    hasResources = false;
                    break;
                }
            }
            
            for (var input : shownCost) {
                var shownItem = Arrays.stream(input.ingredient().method_8105()).findFirst().get().method_7909();
                var shownStack = new class_1799(shownItem, input.count());
                
                var allMatchingItems = Arrays.stream(input.ingredient().method_8105()).map(class_1799::method_7964).toList();
                var combinedList = new ArrayList<class_2561>();
                combinedList.add(class_2561.method_43471("oritech.text.augment_ingredient_tip").method_27695(class_124.field_1067, class_124.field_1080));
                combinedList.addAll(allMatchingItems);
                
                var shown = Components.item(shownStack).showOverlay(true).setTooltipFromStack(false);
                
                if (allMatchingItems.size() > 1) {
                    shown.tooltip(combinedList);
                } else {
                    shown.setTooltipFromStack(true);
                }
                itemContainer.child(shown.margins(Insets.of(2)));
            }
            descriptionPanel.child(itemContainer);
        }
        
        var buttonPanel = Containers.horizontalFlow(Sizing.fill(100), Sizing.fixed(26));
        buttonPanel.margins(Insets.of(2, 0, 4, 4));
        buttonPanel.horizontalAlignment(HorizontalAlignment.RIGHT);
        
        var confirmKey = "text.oritech.begin_research";
        if (operation.equals(PlayerAugments.AugmentApplicatorOperation.ADD)) {
            confirmKey = "text.oritech.install";
        } else if (operation.equals(PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            confirmKey = "text.oritech.remove";
        } else if (operation.equals(PlayerAugments.AugmentApplicatorOperation.NONE)) {
            confirmKey = "text.oritech.noop";
        }
        
        var cancelButton = Components.button(class_2561.method_43471("text.oritech.cancel").method_54663(GRAY_TEXT_COLOR), component -> overlay.remove());
        cancelButton.textShadow(false);
        
        var confirmButton = Components.button(class_2561.method_43471(confirmKey).method_54663(GRAY_TEXT_COLOR), component -> {
            onAugmentClick(id, operation, true);
            overlay.remove();
        });
        confirmButton.textShadow(false);
        
        cancelButton.renderer(ORITECH_BUTTON);
        confirmButton.renderer(ORITECH_BUTTON);
        
        if ((!hasResources || !hasEnergy) && isCreative) {
            hasResources = true;
            hasEnergy = true;
            var text = class_2561.method_43470("[C] ").method_27692(class_124.field_1064).method_10852(class_2561.method_43471(confirmKey));
            confirmButton.method_25355(text);
            confirmButton.tooltip(class_2561.method_43471("text.oritech.augmenter_creative_tooltip"));
        }
        
        if (operation.equals(PlayerAugments.AugmentApplicatorOperation.NONE) || operation.equals(PlayerAugments.AugmentApplicatorOperation.RESEARCH) && (!hasRequiredStation || !hasResources || !hasEnergy) || operation.equals(PlayerAugments.AugmentApplicatorOperation.ADD) && !hasResources) {
            confirmButton.active(false);
        }
        
        buttonPanel.child(cancelButton.margins(Insets.of(2)));
        buttonPanel.child(confirmButton.margins(Insets.of(2, 2, 2, 0)));
        
        
        panel.child(titleLabel);
        panel.child(descriptionPanel);
        panel.child(buttonPanel);
        
        overlay.zIndex(100);
        root.child(overlay);
        
    }
    
    private void addEnergyBar(FlowLayout panel) {
        
        var insetSize = 1;
        var tooltipText = class_2561.method_43469("tooltip.oritech.energy_indicator", 10, 50);
        
        var width = 17;
        var height = 80;
        
        var frame = Containers.horizontalFlow(Sizing.fixed(width + insetSize * 2), Sizing.fixed(height + insetSize * 2));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of(insetSize));
        panel.child(frame);
        
        var indicator_background = Components.texture(GUI_COMPONENTS, 24, 0, 24, 96, 98, 96);
        indicator_background.sizing(Sizing.fixed(width), Sizing.fixed(height));
        
        energyIndicator = Components.texture(GUI_COMPONENTS, 0, 0, 24, (96), 98, 96);
        energyIndicator.sizing(Sizing.fixed(width), Sizing.fixed(height));
        energyIndicator.positioning(Positioning.absolute(0, 0));
        energyIndicator.tooltip(tooltipText);
        
        frame
          .child(indicator_background)
          .child(energyIndicator);
    }
    
    private static final class AugmentUiState {
        private BoxComponent highlight;
        private TextureComponent background;
        private TextureComponent icon;
        private BoxComponent blocker;
        private PlayerAugments.AugmentApplicatorOperation openOp;
        private final FlowLayout parent;
        
        private AugmentUiState(BoxComponent highlight, TextureComponent background, TextureComponent icon, BoxComponent blocker, PlayerAugments.AugmentApplicatorOperation openOp, FlowLayout parent) {
            this.highlight = highlight;
            this.background = background;
            this.icon = icon;
            this.blocker = blocker;
            this.openOp = openOp;
            this.parent = parent;
        }
    }
    
    private static void drawLine(class_332 context, Vector2i from, Vector2i to, int color) {
        
        if (from.distanceSquared(to) < 0.1) return;
        
        var matrices = context.method_51448();
        matrices.method_22903();
        
        var pos = matrices.method_23760().method_23761();
        var normal = AugmentSelectionScreen.getNormalVector(from, to).normalize();
        var offset = normal.mul(1);
        var zIndex = 1.1f;
        
        var buffer = context.method_51450().getBuffer(class_1921.method_51784());
        buffer.method_22918(pos, from.x - offset.x, from.y - offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, from.x + offset.x, from.y + offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, to.x + offset.x, to.y + offset.y, zIndex).method_39415(color);
        buffer.method_22918(pos, to.x - offset.x, to.y - offset.y, zIndex).method_39415(color);
        context.method_51452();
        
        matrices.method_22909();
    }

    public static String augmentKey(class_2960 id) {
        return "oritech.text." + id.method_12832().replace('/', '.');
    }
    
    private static class CustomFlowRootContainer extends FlowLayout {
        
        public static FlowLayout verticalFlow(Sizing horizontalSizing, Sizing verticalSizing) {
            return new CustomFlowRootContainer(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        }
        
        protected CustomFlowRootContainer(Sizing horizontalSizing, Sizing verticalSizing, Algorithm algorithm) {
            super(horizontalSizing, verticalSizing, algorithm);
        }
        
        @Override
        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            if (main != null)
                return main.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
    }
    
    private static class DraggableScrollContainer<C extends io.wispforest.owo.ui.core.Component> extends ScrollContainer<C> {
        
        protected DraggableScrollContainer(ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child) {
            super(direction, horizontalSizing, verticalSizing, child);
        }
        
        @Override
        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            var inScrollBar = this.isInScrollbar(this.x + mouseX, this.y + mouseY);
            
            double delta = this.direction.choose(deltaX, deltaY);
            double selfSize = this.direction.sizeGetter.apply(this) - this.direction.insetGetter.apply(this.padding.get());
            double scalar = (this.maxScroll) / (selfSize - this.lastScrollbarLength);
            if (!Double.isFinite(scalar)) scalar = 0;
            
            scalar *= -0.5f;
            
            this.scrollBy(delta * scalar, true, false);
            
            if (inScrollBar)
                this.scrollbaring = true;
            
            return false;
        }
        
        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            
            var offset = new Vector2i((int) -this.currentScrollPosition, 0).add(this.x, this.y);
            
            for (var dependency : dependencyLines.values()) {
                drawLine(context, new Vector2i(dependency.method_15442()).add(offset), new Vector2i(dependency.method_15441()).add(offset), new Color(0.1f, 0.15f, 0.2f, 1f).argb());
            }
            
        }
        
        public double getScrollPosition() {
            return currentScrollPosition;
        }
        
    }
    
    public static class SizedIngredientTooltipComponent implements class_5684 {
        
        private final List<SizedIngredient> items;
        private final int size = 16;
        private final int spacing = 3;
        
        public SizedIngredientTooltipComponent(List<SizedIngredient> items) {
            this.items = items;
        }
        
        
        @Override
        public int method_32661() {
            return size + spacing + 5;
        }
        
        @Override
        public int method_32664(class_327 textRenderer) {
            return (size + spacing) * items.size();
        }
        
        @Override
        public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
            context.push();
            // context.getMatrices().translate(0, spacing, 0);
            
            for (int i = 0; i < items.size(); i++) {
                var ingredient = items.get(i);
                if (ingredient.ingredient().method_8105().length == 0) continue;
                var stack = Arrays.stream(ingredient.ingredient().method_8105()).findFirst().get();
                stack = new class_1799(stack.method_7909(), ingredient.count());
                
                var itemX = x + (size + spacing) * i;
                var itemY = y + spacing;
                
                context.method_51427(stack, itemX, itemY);
                
                if (stack.method_7947() > 1) {
                    context.method_51448().method_46416(0, 0, 200);
                    context.method_51433(textRenderer, String.valueOf(stack.method_7947()), itemX + 19 - 2 - textRenderer.method_1727(String.valueOf(stack.method_7947())), itemY + 6 + 3, 16777215, true);
                }
                
            }
            
            context.pop();
        }
    }
    
}
