package rearth.oritech.client.ui;

import io.wispforest.owo.client.screens.SlotGenerator;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.client.init.ModScreens;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_746;

public class ItemFilterScreenHandler extends class_1703 {
    
    @NotNull
    protected final class_2338 blockPos;
    @NotNull
    protected final ItemFilterBlockEntity blockEntity;
    
    public ItemFilterScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(buf.method_10811())));
    }
    
    public ItemFilterScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(ModScreens.ITEM_FILTER_SCREEN, syncId);
        
        this.blockPos = blockEntity.method_11016();
        this.blockEntity = (ItemFilterBlockEntity) blockEntity;
        
        SlotGenerator.begin(this::method_7621, 8, 84)
          .playerInventory(playerInventory);
    }
    
    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        // slots are 0-27 for inventory, 28-35 for hotbar
        // but player inventory is 0-8 for hotbar, 9-35 for inventory
        var slotStack = player.method_31548().method_5438((slot + 9) % 36);
        if (slotStack.method_7960()) return class_1799.field_8037;

        var displayStack = new class_1799(slotStack.method_7909(), 1);
        displayStack.method_57365(slotStack.method_57353());

        var data = blockEntity.getFilterSettings();
        for (var item : data.items().values()) {
            // don't add item to filter if it's already in filter
            if (item.method_31574(displayStack.method_7909())) return class_1799.field_8037;
        }
        var newItems = new HashMap<>(data.items());
        for (int i = 0; i < 12; i++) {
            if (!newItems.containsKey(i)) {
                newItems.put(i, displayStack);
                break;
            }
        }
        
        var newData = new ItemFilterBlockEntity.FilterData(data.useNbt(), data.useWhitelist(), data.useComponents(), newItems);
        blockEntity.setFilterSettings(newData);
        if (Objects.requireNonNull(blockEntity.method_10997()).field_9236) {
            if (player instanceof class_746 clientPlayer && clientPlayer.field_3937.field_1755 instanceof ItemFilterScreen filterScreen) {
                filterScreen.updateItemFilters();
            }
        }

        return class_1799.field_8037;
    }
    
    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }
}
