package rearth.oritech.client.renderers;

import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import rearth.oritech.block.entity.storage.SmallTankEntity;

public class SmallTankRenderer implements class_827<SmallTankEntity> {
    
    @Override
    public void render(SmallTankEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        var storage = entity.fluidStorage;
        if (storage.getAmount() <= 0 || storage.getFluid().equals(class_3612.field_15906)) return;
        
        var fluid = storage.getFluid();
        var fill = storage.getAmount() / (float) storage.getCapacity();
        
        var sprite = FluidStackHooks.getStillTexture(fluid);
        var spriteColor = FluidStackHooks.getColor(fluid);
        var consumer = vertexConsumers.getBuffer(class_1921.method_23583());
        
        var parsedColor = Color.ofArgb(spriteColor);
        var opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1f);
        spriteColor = opaqueColor.argb();
        
        matrices.method_22903();
        matrices.method_22904(0.126, 0.126, 0.126);
        matrices.method_22905(0.745f, 0.745f * fill, 0.745f);
        
        var entry = matrices.method_23760();
        var modelMatrix = entry.method_23761();
        
        // Draw the cube using quads
        for (class_2350 direction : class_2350.values()) {
            if (direction.equals(class_2350.field_11033)) continue; // skip bottom, as it's never visible
            drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        
        matrices.method_22909();
        
    }
    
    public static void drawQuad(class_2350 direction, class_4588 consumer, Matrix4f modelMatrix, class_4587.class_4665 normalMatrix, class_1058 sprite, int color, int light, int overlay) {
        // Define the vertices of the quad based on the direction it's facing
        
        var normal = direction.method_23955();
        
        var positions = getQuadVerticesByDirection(direction);
        
        for (int i = positions.length - 1; i >= 0; i--) {
            
            var pos = positions[i];
            var u = sprite.method_4580(getFrameU()[i]);
            var v = sprite.method_4570(getFrameV()[i]);
            
            consumer.method_22918(modelMatrix, pos[0], pos[1], pos[2])
              .method_39415(color)
              .method_22913(u, v)
              .method_60803(light)
              .method_22922(overlay)
              .method_60831(normalMatrix, normal.x, normal.y, normal.z);
        }
        
    }
    
    private static float[] getFrameU() {
        return new float[]{0, 1, 1, 0};
    }
    
    private static float[] getFrameV() {
        return new float[]{0, 0, 1, 1};
    }
    
    private static float[][] getQuadVerticesByDirection(class_2350 direction) {
        // Define the vertices for each face of the cube
        return switch (direction) {
            case field_11036 -> new float[][]{
              {0, 1, 0}, // Top-left
              {1, 1, 0}, // Top-right
              {1, 1, 1}, // Bottom-right
              {0, 1, 1}  // Bottom-left
            };
            case field_11033 -> new float[][]{
              {0, 0, 1}, // Top-left
              {1, 0, 1}, // Top-right
              {1, 0, 0}, // Bottom-right
              {0, 0, 0}  // Bottom-left
            };
            case field_11043 -> new float[][]{
              {1, 1, 0}, // Top-left
              {0, 1, 0}, // Top-right
              {0, 0, 0}, // Bottom-right
              {1, 0, 0}  // Bottom-left
            };
            case field_11035 -> new float[][]{
              {0, 1, 1}, // Top-left
              {1, 1, 1}, // Top-right
              {1, 0, 1}, // Bottom-right
              {0, 0, 1}  // Bottom-left
            };
            case field_11039 -> new float[][]{
              {0, 1, 0}, // Top-left
              {0, 1, 1}, // Top-right
              {0, 0, 1}, // Bottom-right
              {0, 0, 0}  // Bottom-left
            };
            case field_11034 -> new float[][]{
              {1, 1, 1}, // Top-left
              {1, 1, 0}, // Top-right
              {1, 0, 0}, // Bottom-right
              {1, 0, 1}  // Bottom-left
            };
        };
    }
}
