package rearth.oritech.client.renderers;

import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.interaction.PowerPoleEntity;
import rearth.oritech.util.Geometry;

public class PowerPoleCableRenderer implements class_827<PowerPoleEntity> {
    
    public static final class_2960 CABLE_TEXTURE = class_2960.method_60656("textures/block/white_concrete.png");
    
    public static final int CABLE_SEGMENT_COUNT = 12;
    
    @Override
    public void render(@NotNull PowerPoleEntity blockEntity, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, int packedOverlay) {
        
        var connections = blockEntity.getConnections();
        if (connections.isEmpty() || blockEntity.method_11015()) return;
        
        var camPos = class_310.method_1551().field_1719.method_24515();
        var poleDist = blockEntity.method_11016().method_10262(camPos);
        
        var consumer = bufferSource.getBuffer(class_1921.method_23572(CABLE_TEXTURE));
        var ownPos = blockEntity.method_11016();
        
        var ownFacing = blockEntity.getFacingForMultiblock();
        var ownSideVec = class_243.method_24954(Geometry.getForward(ownFacing));
        
        var centerPos = new class_243(0.5, 0.5, 0.5);
        
        poseStack.method_22903();
        poseStack.method_46416(0, 0.35f, 0);
        
        for (var target : connections) {
            if (target == null) continue;
            
            var targetDist = target.pos().method_10262(camPos);
            if (targetDist < poleDist) continue;    // only render connections from the closer side
            
            var startWorldA = class_243.method_24953(ownPos).method_1019(ownSideVec);
            var startWorldB = class_243.method_24953(ownPos).method_1020(ownSideVec);
            
            var targetArmVec = class_243.method_24954(Geometry.getForward(target.facing()));
            
            var targetWorldA = class_243.method_24953(target.pos()).method_1019(targetArmVec);
            var targetWorldB = class_243.method_24953(target.pos()).method_1020(targetArmVec);
            
            var distDirect = startWorldA.method_1025(targetWorldA) + startWorldB.method_1025(targetWorldB);
            var distCross = startWorldA.method_1025(targetWorldB) + startWorldB.method_1025(targetWorldA);
            
            class_243 targetForStartA;
            class_243 targetForStartB;
            
            if (distDirect < distCross) {
                targetForStartA = targetWorldA;
                targetForStartB = targetWorldB;
            } else {
                targetForStartA = targetWorldB;
                targetForStartB = targetWorldA;
            }
            
            var localStartA = centerPos.method_1019(ownSideVec);
            var localStartB = centerPos.method_1020(ownSideVec);
            
            var localTargetA = targetForStartA.method_1023(ownPos.method_10263(), ownPos.method_10264(), ownPos.method_10260());
            var localTargetB = targetForStartB.method_1023(ownPos.method_10263(), ownPos.method_10264(), ownPos.method_10260());
            
            float thickness = 0.05f;
            
            renderHangingCable(poseStack, consumer, localStartA, localTargetA, thickness, packedLight);
            renderHangingCable(poseStack, consumer, localStartB, localTargetB, thickness, packedLight);
        }
        
        poseStack.method_22909();
    }
    
    /**
     * Renders a cable hanging between two points in local render space.
     * @param startPos The start position relative to the BlockEntity origin (e.g. 0.5, 0.5, 0.5 is center).
     * @param endPos   The end position relative to the BlockEntity origin.
     */
    private void renderHangingCable(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 endPos, float thickness, int packedLight) {
        poseStack.method_22903();
        
        // Calculate the full vector from start to end
        var totalOffset = endPos.method_1020(startPos);
        
        var segments = CABLE_SEGMENT_COUNT;
        var totalLength = (float) totalOffset.method_1033();
        var sag = totalLength * 0.05f; // Sag amount based on distance
        sag = Math.min(sag, 4);
        
        var currentPos = startPos; // Start drawing exactly at the start offset
        
        for (int i = 0; i < segments; i++) {
            var t = (float) (i + 1) / segments;
            
            // Linear interpolation from Start to End
            var nextPos = startPos.method_1019(totalOffset.method_1021(t));
            
            // note: The same formula is also used in cablemath, but since some values are precalculated here its duplicated
            
            // Parabolic Sag to Y component
            // Formula: -4 * sag * t * (1-t)
            // We use (t * (1-t)) which peaks at t=0.5 with value 0.25. Multiplied by 4 gives 1.0.
            var sagY = -sag * 4 * t * (1 - t);
            nextPos = nextPos.method_1031(0, sagY, 0);
            
            // Calculate vector for this specific segment
            var segmentDelta = nextPos.method_1020(currentPos);
            
            // To prevent gaps between segments due to rotation, we can slightly overscale length,
            // or rely on the specific joint math. Simple scaling usually works fine.
            var drawDelta = segmentDelta.method_1021(1.02); // 2% overlap to hide cracks
            
            drawSegment(poseStack, consumer, currentPos, drawDelta, thickness, packedLight);
            
            currentPos = nextPos;
        }
        
        poseStack.method_22909();
    }
    
    private void drawSegment(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 delta, float thickness, int packedLight) {
        poseStack.method_22903();
        
        // Move to start of segment
        poseStack.method_22904(startPos.field_1352, startPos.field_1351, startPos.field_1350);
        
        // Calculate rotations to align the Y-axis (length) with the segment delta
        var xzLen = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        var yRot = (float) (-Math.atan2(-delta.field_1352, delta.field_1350)); // Standard MC Yaw calculation
        var xRot = (float) (-Math.atan2(delta.field_1351, xzLen));    // Standard MC Pitch calculation
        
        poseStack.method_22907(class_7833.field_40716.rotation(yRot));
        poseStack.method_22907(class_7833.field_40714.rotation(xRot + (float) (Math.PI / 2)));
        
        // Draw the Box
        float length = (float) delta.method_1033();
        float r = thickness;
        
        int red = 50, green = 50, blue = 50, alpha = 255;
        var pose = poseStack.method_23760();
        
        // --- Side 1 (Front) ---
        addVertex(consumer, pose, -r, 0, r, red, green, blue, alpha, 0, 0, 0, 0, 1, packedLight);
        addVertex(consumer, pose, r, 0, r, red, green, blue, alpha, 1, 0, 0, 0, 1, packedLight);
        addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 1, 1, 0, 0, 1, packedLight);
        addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 0, 1, 0, 0, 1, packedLight);
        
        // --- Side 2 (Back) ---
        addVertex(consumer, pose, r, 0, -r, red, green, blue, alpha, 0, 0, 0, 0, -1, packedLight);
        addVertex(consumer, pose, -r, 0, -r, red, green, blue, alpha, 1, 0, 0, 0, -1, packedLight);
        addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 1, 1, 0, 0, -1, packedLight);
        addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 0, 1, 0, 0, -1, packedLight);
        
        // --- Side 3 (Left) ---
        addVertex(consumer, pose, -r, 0, -r, red, green, blue, alpha, 0, 0, -1, 0, 0, packedLight);
        addVertex(consumer, pose, -r, 0, r, red, green, blue, alpha, 1, 0, -1, 0, 0, packedLight);
        addVertex(consumer, pose, -r, length, r, red, green, blue, alpha, 1, 1, -1, 0, 0, packedLight);
        addVertex(consumer, pose, -r, length, -r, red, green, blue, alpha, 0, 1, -1, 0, 0, packedLight);
        
        // --- Side 4 (Right) ---
        addVertex(consumer, pose, r, 0, r, red, green, blue, alpha, 0, 0, 1, 0, 0, packedLight);
        addVertex(consumer, pose, r, 0, -r, red, green, blue, alpha, 1, 0, 1, 0, 0, packedLight);
        addVertex(consumer, pose, r, length, -r, red, green, blue, alpha, 1, 1, 1, 0, 0, packedLight);
        addVertex(consumer, pose, r, length, r, red, green, blue, alpha, 0, 1, 1, 0, 0, packedLight);
        
        poseStack.method_22909();
    }
    
    private void addVertex(class_4588 consumer, class_4587.class_4665 pose, float x, float y, float z, int r, int g, int b, int a, float u, float v, float nx, float ny, float nz, int packedLight) {
        consumer.method_22918(pose.method_23761(), x, y, z)
          .method_1336(r, g, b, a)
          .method_22913(u, v)
          .method_22922(class_4608.field_21444)
          .method_60803(packedLight)
          .method_60831(pose, nx, ny, nz);
    }
    
    @Override
    public int method_33893() {
        return 256;
    }
    
    @Override
    public boolean shouldRenderOffScreen(PowerPoleEntity blockEntity) {
        return true;
    }
}