package rearth.oritech.client.renderers;

import rearth.oritech.Oritech;
import rearth.oritech.util.ColorableMachine;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

import java.util.Locale;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class MachineModel<T extends class_2586 & GeoAnimatable> extends DefaultedBlockGeoModel<T> {
    public MachineModel(String subpath) {
        super(Oritech.id(subpath));
    }
    
    @Override
    public class_2960 getTextureResource(T animatable) {
        
        if (animatable instanceof ColorableMachine colorableMachine && colorableMachine.supportRecoloring()) {
            var color = colorableMachine.getCurrentColor();
            var base = super.getTextureResource(animatable);
            
            if (color.equals(ColorableMachine.ColorVariant.ORANGE)) return base;
            
            var colorFileSuffix = color.toString().toLowerCase(Locale.ROOT);
            
            return class_2960.method_60655(base.method_12836(), base.method_12832().replace("models", "models/colored").replace(".png", "_" + colorFileSuffix + ".png"));
        } else {
            return super.getTextureResource(animatable);
        }
    }
    
    
    public class_2960 getBaseTexturePath(T animatable) {
            return super.getTextureResource(animatable);
    }
}
