package rearth.oritech.client.renderers;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.util.BeamRenderer;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_7833;

import static net.minecraft.class_2350.*;


public class LaserArmRenderer<T extends LaserArmBlockEntity & GeoAnimatable> extends GeoBlockRenderer<T> {
    
    public LaserArmRenderer(String modelPath) {
        super(new LaserArmModel<>(modelPath));
    }
    
    public static final class_2960 BEAM_TEXTURE = class_2960.method_60656("textures/block/white_concrete.png");
    private static final class_243 BEAM_START_OFFSET = new class_243(0, 1.65, 0);
    
    public static final int GLOW_COLOR_START = 0x998AF2DF;
    public static final int GLOW_COLOR_END   = 0x99135B50;
    
    public static final int CORE_COLOR_START = BeamRenderer.color(200, 220, 255, 100);
    public static final int CORE_COLOR_END   = BeamRenderer.color(180, 230, 255, 100);
    
    private static final HashMap<Long, class_243> cachedOffsets = new HashMap<>();
    
    @Override
    public int method_33893() {
        return 128;
    }
    
    @Override
    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
    
    @Override
    public void postRender(class_4587 matrices, T laserEntity, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        if (laserEntity.getCurrentTarget() == null || !laserEntity.isFiring()) return;
        
        var facing = laserEntity.method_11010().method_11654(class_2741.field_12525);
        var startPos = laserEntity.laserHead;
        var startOffset = new class_243(0, 1.65f, 0);
        
        var targetPos = laserEntity.getVisualTarget();
        var targetBlock = laserEntity.method_10997().method_8320(laserEntity.getCurrentTarget()).method_26204();
        if (laserEntity.isTargetingAtomicForge(targetBlock)) { // adjust so the beam end faces one of the corner pillars
            var moveX = 0.5;
            var moveZ = 0.5;
            if (startPos.field_1352 < targetPos.field_1352) moveX = -0.5;
            if (startPos.field_1350 < targetPos.field_1350) moveZ = -0.5;
            targetPos = targetPos.method_1031(moveX, 0.2, moveZ);
        } else if (laserEntity.isTargetingDeepdrill(targetBlock)) {
            var offset = cachedOffsets.computeIfAbsent(laserEntity.method_11016().method_10063(), id -> idToOffset(class_2338.method_10092(id), 0.5f, laserEntity.method_10997(), laserEntity.getCurrentTarget()));
            targetPos = targetPos.method_1019(offset);
        }
        
        if (laserEntity.lastRenderPosition == null) laserEntity.lastRenderPosition = targetPos;
        targetPos = lerp(laserEntity.lastRenderPosition, targetPos, 0.06f);
        laserEntity.lastRenderPosition = targetPos;
        
        var targetPosOffset = worldToOffsetPosition(facing, targetPos, startPos).method_1019(startOffset);
        
        var forward = targetPos.method_1020(startPos).method_1029();
        if (!laserEntity.isTargetingEnergyContainer() && !laserEntity.isTargetingBuddingAmethyst() && laserEntity.method_10997().field_9229.method_43057() > 0.7)
            ParticleContent.LASER_BEAM_EFFECT.spawn(laserEntity.method_10997(), targetPos.method_1031(0.5, 0, 0.5).method_1020(forward.method_1021(0.6)));
        
        
        matrices.method_22903();
        var beamConsumer = bufferSource.getBuffer(class_1921.method_23026(BEAM_TEXTURE));
        
        float thickness = (float) (0.03f + Math.sin((laserEntity.method_10997().method_8510() + partialTick) * 0.3) * 0.015f);
        
        var deltaVec = targetPosOffset.method_1020(startOffset);
        
        // glowing core
        BeamRenderer.renderStraightBeam(
          matrices,
          beamConsumer,
          BEAM_START_OFFSET,
          deltaVec,
          thickness * 0.2f,
          class_765.field_32767,
          CORE_COLOR_START,
          CORE_COLOR_END
        );
        
        // outer
        BeamRenderer.renderStraightBeam(
          matrices,
          beamConsumer,
          BEAM_START_OFFSET,
          deltaVec,
          thickness,
          class_765.field_32767,
          GLOW_COLOR_START,
          GLOW_COLOR_END
        );
        
        matrices.method_22909();
    }
    
    public static class_243 idToOffset(class_2338 source, float range, class_1937 world, class_2338 targetPos) {
        
        var drillFacing = world.method_8320(targetPos).method_11654(class_2741.field_12481);
        var drillCenter = Geometry.rotatePosition(new class_243(1, 1.4, 0), drillFacing);
        
        var random = class_5819.method_43049(source.method_10063());
        return new class_243((random.method_43057() * 2 - 1) * range, (random.method_43057() * 2 - 1) * range, (random.method_43057() * 2 - 1) * range).method_1019(drillCenter);
    }
    
    @Override
    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        if (Objects.requireNonNull(facing) == class_2350.field_11033) {
            poseStack.method_46416(0,  1, 0);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180));
        } else if (facing == class_2350.field_11039) {
            poseStack.method_22904(0.5,  0.5, 0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90));
        } else if (facing == class_2350.field_11034) {
            poseStack.method_22904(-0.5,  0.5, 0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(270));
        } else if (facing == class_2350.field_11035) {
            poseStack.method_22904(0,  0.5, -0.5);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90));
        } else if (facing == class_2350.field_11043) {
            poseStack.method_22904(0,  0.5, 0.5);
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(90));
        }
    }
    
    public static class_243 lerp(class_243 a, class_243 b, float f) {
        return new class_243(lerp(a.field_1352, b.field_1352, f), lerp(a.field_1351, b.field_1351, f), lerp(a.field_1350, b.field_1350, f));
    }
    
    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }
    
    private static class_243 worldToOffsetPosition(class_2350 facing, class_243 worldTarget, class_243 ownPos) {
        class_243 relativeWorld = worldTarget.method_1020(ownPos);
        
        double relX = relativeWorld.method_10216();
        double relY = relativeWorld.method_10214();
        double relZ = relativeWorld.method_10215();
        
        if (Objects.requireNonNull(facing) == field_11043) {
            return new class_243(relX, -relZ, relY);
        } else if (facing == field_11035) {
            return new class_243(relX, relZ, -relY);
        } else if (facing == field_11039) {
            return new class_243(relY, -relX, relZ);
        } else if (facing == field_11034) {
            return new class_243(-relY, relX, relZ);
        } else if (facing == field_11036) {
            return new class_243(relX, relY, relZ);
        } else if (facing == field_11033) {
            return new class_243(relX, -relY, -relZ);
        }
        throw new IllegalArgumentException();
        
    }
}


