package rearth.oritech.client.renderers;

import rearth.oritech.block.entity.pipes.ItemPipeInterfaceEntity;
import java.util.HashSet;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class ItemPipeTransferRenderer implements class_827<ItemPipeInterfaceEntity> {
    
    @Override
    public void render(ItemPipeInterfaceEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        if (entity.activeStacks == null || entity.activeStacks.isEmpty()) return;
        
        var time = entity.method_10997().method_8510() + tickDelta;
        var removedStacks = new HashSet<ItemPipeInterfaceEntity.RenderStackData>();
        
        for (var renderedStack : entity.activeStacks) {
            var age = time - renderedStack.startedAt();
            var neededTime = ItemPipeInterfaceEntity.calculatePathLength(renderedStack.pathLength());    // about 2 blocks/s, but much faster on longer paths
            var progress = age / neededTime;
            if (progress > 1) {
                removedStacks.add(renderedStack);
                continue;
            }
            
            progress = sigmoidFitted(progress);
            
            // get position in path at current progress (traverse path to current progress)
            var targetPathProgress = renderedStack.pathLength() * progress;
            var pathProgress = 0;
            var pathPosition = renderedStack.path().getFirst();
            class_243 targetPos = class_243.field_1353;
            
            for (var segment : renderedStack.path()) {
                var segmentDist = segment.method_19455(pathPosition);
                
                if (pathProgress + segmentDist < targetPathProgress) {
                    pathProgress += segmentDist;
                    pathPosition = segment;
                } else {    // reaching or overshooting target
                    var remainingDist = targetPathProgress - pathProgress;
                    var targetOffset = class_243.method_24954(segment.method_10059(pathPosition)).method_1029().method_1021(remainingDist);
                    targetPos = class_243.method_24954(pathPosition).method_1019(targetOffset);
                    break;
                }
                
            }
            
            var offset = targetPos.method_1020(class_243.method_24954(entity.method_11016()));
            
            matrices.method_22903();
            matrices.method_22904(offset.field_1352 + 0.5, offset.field_1351 + 0.5, offset.field_1350 + 0.5);
            matrices.method_22905(0.4f, 0.4f, 0.4f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-140));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-30));
            
            var renderedItem = renderedStack.rendered();
            
            class_310.method_1551().method_1480().method_23178(
              renderedItem,
              class_811.field_4317,
              light,
              class_4608.field_21444,
              matrices,
              vertexConsumers,
              entity.method_10997(),
              0
            );
            
            matrices.method_22909();
            
        }
        
        entity.activeStacks.removeAll(removedStacks);
        
    }
    
    private static double sigmoidFitted(double x) {
        return sigmoid((x - 0.5) * 2) + 0.5f;
    }
    
    private static double sigmoid(double x) {
        return x / (1 + Math.abs(x));
    }
}
